/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.StaticInit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public abstract class FileArchiver
extends StaticInit {
    private static final int ARCHIVE_CHECK_FREQUENCY = 100;
    private int a = 100;
    private static final ConfigValue<Integer> b = new ConfigValue(ConfigKey.LOG_MAXSIZE);
    private static final ConfigValue<Integer> c = new ConfigValue(ConfigKey.LOG_MAXNUMBER);
    private boolean d;

    @Nullable
    protected abstract File getFile();

    protected void archivIfNeeded() {
        if (++this.a < 100) {
            return;
        }
        this.a();
    }

    protected void writeNewFileHeader(OutputStream out) throws IOException {
        out.write(new byte[]{-17, -69, -65});
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private final synchronized void a() {
        this.a = 0;
        File file = this.getFile();
        if (file == null) {
            return;
        }
        long l2 = file.length();
        if (!this.d && (float)(l2 / 1024L) / 1024.0f > (float)this.getMaxLogSize()) {
            String string = file.getParent() + File.separator + file.getName();
            String string2 = null;
            File file2 = null;
            try {
                int n2 = 1;
                while (file2 == null || file2.exists()) {
                    string2 = string + "." + n2 + ".zip";
                    file2 = new File(string2);
                    ++n2;
                }
                FileArchiver.a(file, file2);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    this.writeNewFileHeader(fileOutputStream);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    LogManager.getConfigLogger().error("unable to clear log file! stopping archiving...");
                    this.d = true;
                }
                if (c.get() > 0) {
                    FileArchiver.b(file);
                }
            }
            catch (IOException iOException) {
                LogManager.getConfigLogger().error("unable to archive log file to " + string2);
            }
        }
    }

    protected int getMaxLogSize() {
        return b.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        try {
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            FastBufferedInputStream fastBufferedInputStream = new FastBufferedInputStream(new FileInputStream(file), 1024);
            IOFunctions.copyData(fastBufferedInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
            zipOutputStream.finish();
            zipOutputStream.flush();
            fileOutputStream.flush();
            fastBufferedInputStream.close();
        }
        finally {
            zipOutputStream.close();
            fileOutputStream.close();
        }
    }

    public File @Nonnull [] listSortedArchives() {
        File file = this.getFile();
        if (file == null) {
            return new File[0];
        }
        return FileArchiver.a(file);
    }

    public long lastModified() {
        File file = this.getFile();
        if (file == null) {
            return 0L;
        }
        return file.lastModified();
    }

    @Nonnull
    private static File[] a(final @Nonnull File file) {
        File file2 = file.getParentFile();
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(file.getName()) && name.matches(".*\\.\\d+\\.zip");
            }
        });
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.compare(o1.lastModified(), o2.lastModified());
            }
        });
        return fileArray;
    }

    private static void b(@Nonnull File file) {
        int n2;
        File[] fileArray = FileArchiver.a(file);
        if (fileArray.length > (n2 = c.get().intValue()) && n2 > 0) {
            int n3 = fileArray.length - n2;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (fileArray[i2].delete()) continue;
                LogManager.getConfigLogger().error("unable to delete old log file " + String.valueOf(fileArray[i2]));
            }
        }
    }
}

