/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.error.HasErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.i18n.Localized;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class StringFunctions {
    private static final String SPACE33 = "                                 ";
    private static final int SPACE33_LENGTH = "                                 ".length();
    private static final ThreadLocal<HashMap<Locale, Collator>> a = new ThreadLocal();
    private static final HashMap<String, Integer> b = new HashMap(0);

    private StringFunctions() {
    }

    public static final String traceToString(Throwable throwable) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(fastByteArrayOutputStream));
        return new String(fastByteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public static final String getUserFriendlyErrorMessage(@Nonnull Throwable th) {
        Object object = th.getMessage();
        try {
            Object[] objectArray;
            if ((th instanceof RuntimeException || th instanceof Error || th.getClass() == IOException.class) && (object == null || ((String)object).length() < 20)) {
                if (object == null) {
                    object = th.getClass().getSimpleName();
                }
                objectArray = th.getStackTrace();
                for (StackTraceElement stackTraceElement : objectArray) {
                    if (stackTraceElement == null || stackTraceElement.getClassName() == StringFunctions.class.getName()) continue;
                    object = (String)object + " - at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
                    break;
                }
            }
            if (!(th instanceof RuntimeException || th instanceof HasErrorCode || th instanceof Localized || th.getClass() == IOException.class)) {
                void var6_10;
                objectArray = th.getClass().getSimpleName().split("(?<=[a-z])(?=[A-Z])");
                StringBuilder stringBuilder = new StringBuilder();
                Object[] objectArray2 = objectArray;
                int n2 = objectArray2.length;
                boolean bl = false;
                while (var6_10 < n2) {
                    Object object2 = objectArray2[var6_10];
                    if (!"Exception".equals(object2) && !"Error".equals(object2)) {
                        if (((String)object2).endsWith("Exception")) {
                            object2 = ((String)object2).substring(0, ((String)object2).length() - "Exception".length());
                        }
                        stringBuilder.append((String)object2).append(' ');
                    }
                    ++var6_10;
                }
                object = stringBuilder.length() == 0 ? object : stringBuilder.toString().trim() + ": " + (String)object;
            } else if (th instanceof NumberFormatException) {
                object = "Can't convert number. " + (String)object;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (object == null || ((String)object).isEmpty()) {
            object = th.toString();
        }
        return object;
    }

    @Nonnull
    public static final String getUserFriendlyErrorMessage(@Nonnull Throwable th, boolean showCauses) {
        if (!showCauses) {
            return StringFunctions.getUserFriendlyErrorMessage(th);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while (th != null) {
            String string2 = StringFunctions.getUserFriendlyErrorMessage(th);
            if (!Objects.equals(string, string2)) {
                if (!stringBuilder.isEmpty()) {
                    stringBuilder.append("\n- ");
                }
                stringBuilder.append(string2);
            }
            string = string2;
            th = th.getCause();
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static final String getUserFriendlyErrorMessage(URLConnection conn) {
        Object object;
        IOException iOException;
        InputStream inputStream;
        try {
            inputStream = conn.getInputStream();
            iOException = null;
        }
        catch (IOException iOException2) {
            inputStream = conn instanceof HttpURLConnection ? ((HttpURLConnection)conn).getErrorStream() : null;
            if (inputStream == null) {
                return StringFunctions.getUserFriendlyErrorMessage(iOException2);
            }
            iOException = iOException2;
        }
        String string = conn.getContentType();
        try (String[] stringArray = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
            object = stringArray.useDelimiter("\\A").hasNext() ? stringArray.next() : "";
        }
        if (((String)object).length() == 0 && iOException != null) {
            return StringFunctions.getUserFriendlyErrorMessage(iOException);
        }
        if (((String)object).length() > 0 && string != null) {
            String string2;
            stringArray = string.split(";");
            switch (string2 = stringArray[0].trim()) {
                case "text/html": {
                    try {
                        final StringBuilder stringBuilder = new StringBuilder();
                        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){
                            private boolean b;

                            @Override
                            public void handleStartTag(HTML.Tag t, MutableAttributeSet a2, int pos) {
                                if (t == HTML.Tag.TITLE || t == HTML.Tag.STYLE) {
                                    this.b = true;
                                } else if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '\n' && (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.LI || t == HTML.Tag.PRE || t == HTML.Tag.UL || t == HTML.Tag.BLOCKQUOTE)) {
                                    stringBuilder.append("\n");
                                }
                            }

                            @Override
                            public void handleEndTag(HTML.Tag t, int pos) {
                                if (t == HTML.Tag.TITLE || t == HTML.Tag.STYLE) {
                                    this.b = false;
                                }
                                if (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.LI || t == HTML.Tag.TR) {
                                    stringBuilder.append('\n');
                                }
                            }

                            @Override
                            public void handleText(char[] text, int pos) {
                                if (!this.b) {
                                    stringBuilder.append(text);
                                }
                            }
                        };
                        ParserDelegator parserDelegator = new ParserDelegator();
                        parserDelegator.parse(new FastStringReader((String)object), parserCallback, Boolean.TRUE);
                        if (stringBuilder.length() <= 0) break;
                        object = stringBuilder.toString();
                    }
                    catch (Exception exception) {}
                    break;
                }
                case "application/json": {
                    Map map = (HashMap)new Json().fromJson((String)object, (Type)((Object)HashMap.class), Json.NULL_MAP, null);
                    String[] stringArray = new String[]{"error_description", "error", "message"};
                    block17: while (true) {
                        for (String string3 : stringArray) {
                            String string4;
                            Object v = map.get(string3);
                            if (v == null || StringFunctions.isEmpty(string4 = v.toString())) continue;
                            object = string4;
                            if (!"error".equals(string3) || !(v instanceof Map)) break block17;
                            map = (Map)v;
                        }
                        break;
                    }
                    if (map.get("message_detail") != null) {
                        object = (String)object + ", " + String.valueOf(map.get("message_detail"));
                    }
                    if (map.get("code") == null) break;
                    object = (String)object + " (" + String.valueOf(map.get("code")) + ")";
                }
            }
        }
        if (((String)object).length() > 250) {
            object = ((String)object).substring(0, 247) + "...";
        }
        return object;
    }

    @Deprecated
    public static String getHTMLEncoded(String toConvert) {
        return StringFunctions.encodeHTML(toConvert, false);
    }

    public static String encodeHTML(String text) {
        return StringFunctions.encodeHTML(text, true);
    }

    public static String encodeHTML(@Nullable String text, boolean encodeWhitespaces) {
        if (text == null) {
            return null;
        }
        int n2 = text.length();
        StringBuilder stringBuilder = null;
        int n3 = 0;
        char c2 = '\u0000';
        block13: for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = c2;
            c2 = text.charAt(i2);
            switch (c2) {
                case '\n': {
                    if (encodeWhitespaces) break;
                    continue block13;
                }
                case ' ': {
                    if (encodeWhitespaces && c3 == ' ') break;
                    continue block13;
                }
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    break;
                }
                default: {
                    continue block13;
                }
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n2);
            }
            stringBuilder.append(text, n3, i2);
            n3 = i2 + 1;
            switch (c2) {
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block13;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block13;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block13;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block13;
                }
                case '\n': {
                    stringBuilder.append("<BR>");
                    continue block13;
                }
                case ' ': {
                    stringBuilder.append("&nbsp;");
                    c2 = '\u0000';
                }
            }
        }
        if (stringBuilder == null) {
            return text;
        }
        stringBuilder.append(text, n3, n2);
        return stringBuilder.toString();
    }

    public static String decodeHTML(String str) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        int n3 = str.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            char c2 = str.charAt(i2);
            if (c2 != '&' || (n4 = str.indexOf(59, i2)) <= 0) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(str, n2, i2);
            n2 = n4 + 1;
            try {
                int n5;
                if (str.charAt(i2 + 1) == '#') {
                    n5 = str.charAt(i2 + 2) != 'x' ? Integer.parseInt(str.substring(i2 + 2, n4)) : Integer.parseInt(str.substring(i2 + 3, n4), 16);
                } else {
                    Integer n6 = b.get(str.substring(i2 + 1, n4));
                    n5 = n6;
                }
                stringBuilder.append((char)n5);
            }
            catch (Exception exception) {
                stringBuilder.append(str.substring(i2, ++n4));
            }
            i2 = n4;
        }
        if (stringBuilder != null) {
            stringBuilder.append(str, n2, n3);
            return stringBuilder.toString();
        }
        return str;
    }

    public static String encodeXML(String s) {
        StringBuilder stringBuilder = null;
        int n2 = s.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = s.charAt(i2);
            if (c2 == '\u0000') continue;
            if (c2 < ' ' || c2 == '<' || c2 == '>' || c2 == '&' || c2 == '\"' || c2 == '[' || c2 == ']') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder().append(s, 0, i2);
                }
                stringBuilder.append("&#").append((int)c2).append(";");
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder == null ? s : stringBuilder.toString();
    }

    public static Boolean likeCaseSensitive(String fi, String pa) {
        if (pa.length() == 0) {
            return Boolean.FALSE;
        }
        char[] cArray = fi.toCharArray();
        char[] cArray2 = pa.toCharArray();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        block4: while (cArray2.length > n2 && cArray.length > n3) {
            char c2 = cArray2[n2++];
            switch (c2) {
                case '*': {
                    bl = true;
                    continue block4;
                }
                case '?': {
                    ++n3;
                    continue block4;
                }
            }
            if (bl) {
                while (n3 < cArray.length && cArray[n3] != c2) {
                    ++n3;
                }
                if (n3 >= cArray.length) {
                    return Boolean.FALSE;
                }
                int n4 = n2 - 1;
                int n5 = ++n3;
                while (cArray2.length > n2 && cArray.length > n3) {
                    if (cArray[n3] != (c2 = cArray2[n2++])) {
                        Boolean bl2;
                        if (c2 == '*') {
                            --n2;
                            break;
                        }
                        if (c2 == '?' && (bl2 = StringFunctions.likeCaseSensitive(fi.substring(n3), pa.substring(--n2))).booleanValue()) {
                            return Boolean.TRUE;
                        }
                        n2 = n4;
                        n3 = n5;
                        continue block4;
                    }
                    ++n3;
                }
                if (cArray2.length == n2 && cArray.length > n3) {
                    n2 = n4;
                    n3 = n5;
                    continue;
                }
                bl = false;
                continue;
            }
            if (cArray[n3] != c2) {
                return Boolean.FALSE;
            }
            ++n3;
        }
        while (cArray2.length > n2) {
            if (cArray2[n2++] == '*') continue;
            return Boolean.FALSE;
        }
        if (cArray.length > n3 && !bl) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String numberToRomanNumerals(long n2) {
        if (n2 <= 0L) {
            return String.valueOf(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        a[] aArray = com.inet.lib.util.StringFunctions$a.values();
        for (int i2 = aArray.length - 1; i2 >= 0; --i2) {
            while (n2 >= (long)aArray[i2].n) {
                stringBuilder.append((Object)aArray[i2]);
                n2 -= (long)aArray[i2].n;
            }
        }
        return stringBuilder.toString();
    }

    public static String numberToAlphabetic(int num) {
        StringBuilder stringBuilder = new StringBuilder();
        while (num > 0) {
            int n2 = --num % 26;
            char c2 = (char)(n2 + 97);
            stringBuilder.insert(0, c2);
            num = (num - n2) / 26;
        }
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String listProperties(@Nonnull Properties props, String what) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Listing ").append(what).append('\n');
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        String[] stringArray = props.propertyNames();
        while (stringArray.hasMoreElements()) {
            String[] stringArray2 = (String[])stringArray.nextElement();
            if (stringArray2.equals("password") || stringArray2.equals("licensekey")) continue;
            String string = props.getProperty((String)stringArray2);
            String string2 = (String)stringArray2 + SPACE33.substring(Math.min(stringArray2.length(), SPACE33_LENGTH)) + "::= " + String.valueOf(string);
            arrayList.add((CallSite)((Object)string2));
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (String string : stringArray) {
            stringBuilder.append(string).append('\n');
        }
        stringBuilder.append("End of listing ").append(what);
        return stringBuilder.toString();
    }

    @Nonnull
    public static Collator getCollator() {
        return StringFunctions.getCollator(ClientLocale.getThreadLocale());
    }

    public static Collator getCollator(@Nonnull Locale locale) {
        Collator collator;
        HashMap<Locale, Collator> hashMap = a.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            a.set(hashMap);
        }
        if ((collator = hashMap.get(locale)) == null) {
            collator = Collator.getInstance(locale);
            hashMap.put(locale, collator);
        }
        return collator;
    }

    public static String stringValueOf(Object value) {
        return value == null ? null : value.toString();
    }

    static {
        b.put("quot", 34);
        b.put("amp", 38);
        b.put("lt", 60);
        b.put("gt", 62);
        b.put("nbsp", 160);
        b.put("iexcl", 161);
        b.put("cent", 162);
        b.put("pound", 163);
        b.put("curren", 164);
        b.put("yen", 165);
        b.put("brvbar", 166);
        b.put("sect", 167);
        b.put("uml", 168);
        b.put("copy", 169);
        b.put("ordf", 170);
        b.put("laquo", 171);
        b.put("not", 172);
        b.put("shy", 173);
        b.put("reg", 174);
        b.put("macr", 175);
        b.put("deg", 176);
        b.put("plusmn", 177);
        b.put("sup2", 178);
        b.put("sup3", 179);
        b.put("acute", 180);
        b.put("micro", 181);
        b.put("para", 182);
        b.put("middot", 183);
        b.put("cedil", 184);
        b.put("sup1", 185);
        b.put("ordm", 186);
        b.put("raquo", 187);
        b.put("frac14", 188);
        b.put("frac12", 189);
        b.put("frac34", 190);
        b.put("iquest", 191);
        b.put("Agrave", 192);
        b.put("Aacute", 193);
        b.put("Acirc", 194);
        b.put("Atilde", 195);
        b.put("Auml", 196);
        b.put("Aring", 197);
        b.put("AElig", 198);
        b.put("Ccedil", 199);
        b.put("Egrave", 200);
        b.put("Eacute", 201);
        b.put("Ecirc", 202);
        b.put("Euml", 203);
        b.put("Igrave", 204);
        b.put("Iacute", 205);
        b.put("Icirc", 206);
        b.put("Iuml", 207);
        b.put("ETH", 208);
        b.put("Ntilde", 209);
        b.put("Ograve", 210);
        b.put("Oacute", 211);
        b.put("Ocirc", 212);
        b.put("Otilde", 213);
        b.put("Ouml", 214);
        b.put("times", 215);
        b.put("Oslash", 216);
        b.put("Ugrave", 217);
        b.put("Uacute", 218);
        b.put("Ucirc", 219);
        b.put("Uuml", 220);
        b.put("Yacute", 221);
        b.put("THORN", 222);
        b.put("szlig", 223);
        b.put("agrave", 224);
        b.put("aacute", 225);
        b.put("acirc", 226);
        b.put("atilde", 227);
        b.put("auml", 228);
        b.put("aring", 229);
        b.put("aelig", 230);
        b.put("ccedil", 231);
        b.put("egrave", 232);
        b.put("eacute", 233);
        b.put("ecirc", 234);
        b.put("euml", 235);
        b.put("igrave", 236);
        b.put("iacute", 237);
        b.put("icirc", 238);
        b.put("iuml", 239);
        b.put("eth", 240);
        b.put("ntilde", 241);
        b.put("ograve", 242);
        b.put("oacute", 243);
        b.put("ocirc", 244);
        b.put("otilde", 245);
        b.put("ouml", 246);
        b.put("divide", 247);
        b.put("oslash", 248);
        b.put("ugrave", 249);
        b.put("uacute", 250);
        b.put("ucirc", 251);
        b.put("uuml", 252);
        b.put("yacute", 253);
        b.put("thorn", 254);
        b.put("yuml", 255);
        b.put("Alpha", 913);
        b.put("alpha", 945);
        b.put("Beta", 914);
        b.put("beta", 946);
        b.put("Gamma", 915);
        b.put("gamma", 947);
        b.put("Delta", 916);
        b.put("delta", 948);
        b.put("Epsilon", 917);
        b.put("epsilon", 949);
        b.put("Zeta", 918);
        b.put("zeta", 950);
        b.put("Eta", 919);
        b.put("eta", 951);
        b.put("Theta", 920);
        b.put("theta", 952);
        b.put("Iota", 921);
        b.put("iota", 953);
        b.put("Kappa", 922);
        b.put("kappa", 954);
        b.put("Lambda", 923);
        b.put("lambda", 955);
        b.put("Mu", 924);
        b.put("mu", 956);
        b.put("Nu", 925);
        b.put("nu", 957);
        b.put("Xi", 926);
        b.put("xi", 958);
        b.put("Omicron", 927);
        b.put("omicron", 959);
        b.put("Pi", 928);
        b.put("pi", 960);
        b.put("Rho", 929);
        b.put("rho", 961);
        b.put("Sigma", 931);
        b.put("sigmaf", 962);
        b.put("sigma", 963);
        b.put("Tau", 932);
        b.put("tau", 964);
        b.put("Upsilon", 933);
        b.put("upsilon", 965);
        b.put("Phi", 934);
        b.put("phi", 966);
        b.put("Chi", 935);
        b.put("chi", 967);
        b.put("Psi", 936);
        b.put("psi", 968);
        b.put("Omega", 937);
        b.put("omega", 969);
        b.put("thetasym", 977);
        b.put("upsih", 978);
        b.put("piv", 982);
        b.put("forall", 8704);
        b.put("part", 8706);
        b.put("exist", 8707);
        b.put("empty", 8709);
        b.put("nabla", 8711);
        b.put("isin", 8712);
        b.put("notin", 8713);
        b.put("ni", 8715);
        b.put("prod", 8719);
        b.put("sum", 8721);
        b.put("minus", 8722);
        b.put("lowast", 8727);
        b.put("radic", 8730);
        b.put("prop", 8733);
        b.put("infin", 8734);
        b.put("ang", 8736);
        b.put("and", 8869);
        b.put("or", 8870);
        b.put("cap", 8745);
        b.put("cup", 8746);
        b.put("int", 8747);
        b.put("there4", 8756);
        b.put("sim", 8764);
        b.put("cong", 8773);
        b.put("asymp", 8776);
        b.put("ne", 8800);
        b.put("equiv", 8801);
        b.put("le", 8804);
        b.put("ge", 8805);
        b.put("sub", 8834);
        b.put("sup", 8835);
        b.put("nsub", 8836);
        b.put("sube", 8838);
        b.put("supe", 8839);
        b.put("oplus", 8853);
        b.put("otimes", 8855);
        b.put("perp", 8869);
        b.put("sdot", 8901);
        b.put("loz", 9674);
        b.put("lceil", 8968);
        b.put("rceil", 8969);
        b.put("lfloor", 8970);
        b.put("rfloor", 8971);
        b.put("lang", 9001);
        b.put("rang", 9002);
        b.put("larr", 8592);
        b.put("uarr", 8593);
        b.put("rarr", 8594);
        b.put("darr", 8595);
        b.put("harr", 8596);
        b.put("crarr", 8629);
        b.put("lArr", 8656);
        b.put("uArr", 8657);
        b.put("rArr", 8658);
        b.put("dArr", 8659);
        b.put("hArr", 8660);
        b.put("bull", 8226);
        b.put("hellip", 8230);
        b.put("prime", 8242);
        b.put("oline", 8254);
        b.put("frasl", 8260);
        b.put("weierp", 8472);
        b.put("image", 8465);
        b.put("real", 8476);
        b.put("trade", 8482);
        b.put("euro", 8364);
        b.put("alefsym", 8501);
        b.put("spades", 9824);
        b.put("clubs", 9827);
        b.put("hearts", 9829);
        b.put("diams", 9830);
        b.put("ensp", 8194);
        b.put("emsp", 8195);
        b.put("thinsp", 8201);
        b.put("zwnj", 8204);
        b.put("zwj", 8205);
        b.put("lrm", 8206);
        b.put("rlm", 8207);
        b.put("ndash", 8211);
        b.put("mdash", 8212);
        b.put("lsquo", 8216);
        b.put("rsquo", 8217);
        b.put("sbquo", 8218);
        b.put("ldquo", 8220);
        b.put("rdquo", 8221);
        b.put("bdquo", 8222);
        b.put("dagger", 8224);
        b.put("Dagger", 8225);
        b.put("permil", 8240);
        b.put("lsaquo", 8249);
        b.put("rsaquo", 8250);
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(1);
        public static final /* enum */ a b = new a(4);
        public static final /* enum */ a c = new a(5);
        public static final /* enum */ a d = new a(9);
        public static final /* enum */ a e = new a(10);
        public static final /* enum */ a f = new a(40);
        public static final /* enum */ a g = new a(50);
        public static final /* enum */ a h = new a(90);
        public static final /* enum */ a i = new a(100);
        public static final /* enum */ a j = new a(400);
        public static final /* enum */ a k = new a(500);
        public static final /* enum */ a l = new a(900);
        public static final /* enum */ a m = new a(1000);
        private final int n;
        private static final /* synthetic */ a[] o;

        public static a[] values() {
            return (a[])o.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(int n3) {
            this.n = n3;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d, e, f, g, h, i, j, k, l, m};
        }

        static {
            o = com.inet.lib.util.StringFunctions$a.a();
        }
    }
}

