/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.error.ErrorCode;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.io.SuffixFilter;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

@InternalApi
public class IOFunctions {
    public static final byte[] PREFIX_ZIP = new byte[]{80, 75};
    public static final byte[] PREFIX_ERROR = new byte[]{69, 82, 82, 79, 82};
    private static final I18nMessages a = new I18nMessages("com.inet.lib.i18n.LanguageResources", IOFunctions.class);
    private static final byte[] b = "data:image/png;base64,".getBytes(StandardCharsets.UTF_8);

    private IOFunctions() {
    }

    public static final void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().debug(a.getMsg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException)));
            }
        }
    }

    public static final void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().debug(a.getMsg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException)));
            }
        }
    }

    public static final void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().debug(a.getMsg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException)));
            }
        }
    }

    public static final void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().debug(a.getMsg("inet.lib.closefailed", iOException.getMessage(), StringFunctions.traceToString(iOException)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final String[] loadList(File file) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.isFile()) {
            object = null;
            BufferedReader bufferedReader = null;
            try {
                object = new FileReader(file);
                bufferedReader = new BufferedReader((Reader)object);
                String string = bufferedReader.readLine();
                while (string != null) {
                    if ((string = string.trim()).length() > 0) {
                        arrayList.add(string);
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOFunctions.close(bufferedReader);
                IOFunctions.close((Reader)object);
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().debug(a.getMsg("inet.lib.iofailure", iOException.getMessage(), StringFunctions.traceToString(iOException)));
                {
                    catch (Throwable throwable) {
                        IOFunctions.close(bufferedReader);
                        IOFunctions.close((Reader)object);
                        throw throwable;
                    }
                }
                IOFunctions.close(bufferedReader);
                IOFunctions.close((Reader)object);
            }
            IOFunctions.close(bufferedReader);
            IOFunctions.close((Reader)object);
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveList(File file, String[] lines) {
        FileOutputStream fileOutputStream = null;
        PrintStream printStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            printStream = new PrintStream(fileOutputStream);
            for (String string : lines) {
                printStream.println(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LogManager.getApplicationLogger().debug(a.getMsg("inet.lib.iofailure", fileNotFoundException.getMessage(), StringFunctions.traceToString(fileNotFoundException)));
            }
            catch (Throwable throwable) {
                IOFunctions.close(printStream);
                IOFunctions.close(fileOutputStream);
                throw throwable;
            }
            IOFunctions.close(printStream);
            IOFunctions.close(fileOutputStream);
        }
        IOFunctions.close(printStream);
        IOFunctions.close(fileOutputStream);
    }

    public static final Iterator<File> fileIterator(File basedir, String[] suffices) {
        return IOFunctions.fileIterator(basedir, new SuffixFilter(suffices, ""), false);
    }

    public static final Iterator<File> fileIterator(File basedir, String[] suffices, boolean collectdir) {
        return IOFunctions.fileIterator(basedir, new SuffixFilter(suffices, ""), collectdir);
    }

    public static final Iterator<File> fileIterator(File basedir, FileFilter filter) {
        return IOFunctions.fileIterator(basedir, filter, false);
    }

    public static final Iterator<File> fileIterator(File basedir, FileFilter filter, boolean collectdir) {
        ArrayList<File> arrayList = new ArrayList<File>();
        IOFunctions.a(arrayList, basedir, filter, collectdir);
        return arrayList.iterator();
    }

    private static final void a(List<File> list, File file, FileFilter fileFilter, boolean bl) {
        File[] fileArray = null;
        fileArray = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (bl) {
                        list.add(file2);
                    }
                    IOFunctions.a(list, file2, fileFilter, bl);
                    continue;
                }
                list.add(file2);
            }
        }
    }

    public static boolean isZipFile(FastBufferedInputStream bis) throws IOException {
        return IOFunctions.startsWith(bis, PREFIX_ZIP);
    }

    public static boolean startsWith(FastBufferedInputStream bis, byte[] prefix) throws IOException {
        bis.mark(prefix.length);
        byte[] byArray = new byte[prefix.length];
        bis.read(byArray, 0, prefix.length);
        bis.reset();
        return Arrays.equals(byArray, prefix);
    }

    public static boolean isZipFile(BufferedReader in) throws IOException {
        if (in == null) {
            return false;
        }
        in.mark(2);
        char[] cArray = new char[2];
        in.read(cArray, 0, cArray.length);
        in.reset();
        return Arrays.equals(cArray, new char[]{'P', 'K'});
    }

    public static boolean isDirectory(URL url) {
        if ("file".equals(url.getProtocol())) {
            File file = IOFunctions.getFile(url);
            return file.isDirectory();
        }
        return false;
    }

    public static boolean deleteDir(File dir) {
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < 10; ++i2) {
            nArray[0] = 0;
            if (IOFunctions.a(dir, nArray)) {
                if (dir.delete()) {
                    return true;
                }
                if (!dir.exists()) {
                    return false;
                }
            }
            if (nArray[0] == 0) break;
        }
        return dir.delete();
    }

    private static boolean a(File file, int[] nArray) {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    bl &= IOFunctions.a(file2, nArray);
                }
                if (file2.delete()) {
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static void deleteDir(Path directoryPath) throws IOException {
        final IOException[] iOExceptionArray = new IOException[1];
        final int[] nArray = new int[1];
        try {
            for (int i2 = 0; i2 < 10 && !Files.notExists(directoryPath, LinkOption.NOFOLLOW_LINKS); ++i2) {
                Files.walkFileTree(directoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.a(path);
                    }

                    public FileVisitResult a(Path path, IOException iOException) throws IOException {
                        return this.a(path);
                    }

                    private FileVisitResult a(Path path) {
                        block3: {
                            try {
                                Files.delete(path);
                                nArray[0] = nArray[0] + 1;
                            }
                            catch (NoSuchFileException noSuchFileException) {
                            }
                            catch (IOException iOException) {
                                if (iOExceptionArray[0] != null) break block3;
                                iOExceptionArray[0] = iOException;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                        return this.a((Path)object, iOException);
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.a((Path)object, basicFileAttributes);
                    }
                });
                if (nArray[0] != 0 && iOExceptionArray[0] != null) {
                    nArray[0] = 0;
                    iOExceptionArray[0] = null;
                    continue;
                }
                break;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            LogManager.getApplicationLogger().debug(noSuchFileException);
        }
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] stringArray = srcDir.list();
            Objects.requireNonNull(stringArray);
            for (String string : stringArray) {
                IOFunctions.copyDirectory(new File(srcDir, string), new File(dstDir, string));
            }
        } else {
            IOFunctions.copy(srcDir, dstDir);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    public static byte[] getFileBuffer(@Nonnull URL url) throws IOException {
        try (InputStream inputStream = IOFunctions.openStreamSupportingRedirect(url, 5000);){
            byte[] byArray = IOFunctions.readBytes(inputStream);
            return byArray;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static URL getFileURL(String fileName) throws MalformedURLException {
        if (fileName.startsWith("file:")) {
            try {
                return new URL(fileName).toURI().toURL();
            }
            catch (Exception exception) {
                fileName = fileName.substring(5);
            }
        }
        return IOFunctions.getFileURL(new File(fileName));
    }

    public static URL getFileURL(File file) throws MalformedURLException {
        try {
            String string;
            if (!file.isAbsolute() && !(string = file.getPath().replace('\\', '/')).startsWith("/")) {
                URI uRI = new URI(null, null, string, null);
                if (uRI.getScheme() != null) {
                    throw new MalformedURLException("Not a file protocol: " + uRI.getScheme());
                }
                return new URL("file", "", uRI.getRawPath());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return file.toURI().toURL();
    }

    public static String getFileName(URL fileURL) throws IllegalArgumentException {
        return IOFunctions.getFile(fileURL).getPath();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static File getFile(URL fileURL) throws IllegalArgumentException {
        String string = fileURL.getProtocol();
        if (!"file".equals(string)) {
            throw new IllegalArgumentException("Protocol is not file: " + String.valueOf(fileURL));
        }
        Object object = fileURL.getPath();
        object = EncodingFunctions.decodeUrlPath((String)object);
        String string2 = fileURL.getHost();
        if (string2 != null && string2.length() > 0) {
            object = "//" + string2 + (String)object;
        }
        return new File((String)object);
    }

    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static URL getURLFromString(String enteredURL) {
        if (enteredURL == null) {
            return null;
        }
        if (enteredURL.toLowerCase().startsWith("file:")) {
            try {
                return IOFunctions.getFileURL(enteredURL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        URL uRL = null;
        try {
            uRL = new URL(enteredURL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (uRL != null) {
            try {
                return uRL.toURI().toURL();
            }
            catch (Throwable throwable) {
                try {
                    return new URI(null, enteredURL, null).toURL();
                }
                catch (Throwable throwable2) {
                }
            }
        } else {
            try {
                return new File(enteredURL).toURI().toURL();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static String getDataUrlString(String mimeType, byte @Nonnull [] data) {
        return "data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(data);
    }

    public static URL getDataUrl(String mimeType, byte @Nonnull [] data) {
        try {
            return new URL(IOFunctions.getDataUrlString(mimeType, data));
        }
        catch (MalformedURLException malformedURLException) {
            throw (RuntimeException)ErrorCode.throwAny(malformedURLException);
        }
    }

    public static File replaceTempFileWithDirectory(File tempFile) throws IOException {
        if (!tempFile.delete()) {
            throw new IOException("Could not delete temp file: " + tempFile.getAbsolutePath());
        }
        if (!tempFile.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempFile.getAbsolutePath());
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void copy(File src, File dst) throws IOException {
        IOFunctions.copy(src.toPath(), dst.toPath());
    }

    @Nonnull
    public static InputStream getAsciiStream(String data) {
        byte[] byArray = new byte[data.length()];
        data.getBytes(0, byArray.length, byArray, 0);
        return new FastByteArrayInputStream(byArray);
    }

    @Nonnull
    public static String readAsciiString(InputStream in) throws IOException {
        byte[] byArray = IOFunctions.readBytes(in);
        return new String(byArray, 0);
    }

    @Nonnull
    public static String readAsciiString(File file) throws IOException {
        byte[] byArray = IOFunctions.readBytes(file);
        return new String(byArray, 0);
    }

    @Nonnull
    public static String readString(InputStream in, Charset charset) throws IOException {
        byte[] byArray = IOFunctions.readBytes(in);
        return new String(byArray, charset);
    }

    @Nonnull
    public static String readString(File file, Charset charset) throws IOException {
        byte[] byArray = IOFunctions.readBytes(file);
        return new String(byArray, charset);
    }

    public static byte[] readBytes(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = IOFunctions.readBytes(fileInputStream);
            return byArray;
        }
        finally {
            IOFunctions.close(fileInputStream);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(in.available());
        IOFunctions.copyData(in, fastByteArrayOutputStream);
        return fastByteArrayOutputStream.toByteArray();
    }

    public static long copyData(InputStream input, OutputStream output) throws IOException {
        int n2 = Math.max(4096, Math.min(65536, input.available()));
        byte[] byArray = new byte[n2];
        long l2 = 0L;
        while ((n2 = input.read(byArray)) > 0) {
            output.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static void skipAll(InputStream input) {
        try {
            IOFunctions.copyData(input, new OutputStream(){

                @Override
                public void write(int b2) {
                }

                @Override
                public void write(byte[] b2, int off, int len) {
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int readCompletely(InputStream input, byte[] b2) throws IOException {
        return IOFunctions.readCompletely(input, b2, 0, b2.length);
    }

    public static int readCompletely(InputStream input, byte[] b2, int off, int len) throws IOException {
        int n2;
        int n3;
        for (n2 = 0; n2 < len; n2 += n3) {
            n3 = input.read(b2, off + n2, len - n2);
            if (n3 >= 0) continue;
            return n2 == 0 ? -1 : n2;
        }
        return n2;
    }

    public static int compareIPAdress(String address1, String address2) throws Exception {
        if (address1 == null || address2 == null || address1.length() == 0 || address2.length() == 0) {
            throw new Exception("comparing address \"" + address1 + "\" with \"" + address2 + "\" is not possible");
        }
        int[] nArray = IOFunctions.a(address1);
        int[] nArray2 = IOFunctions.a(address2);
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (nArray[i2] < nArray2[i2]) {
                return -1;
            }
            if (nArray[i2] <= nArray2[i2]) continue;
            return 1;
        }
        return 0;
    }

    private static int[] a(String string) throws Exception {
        int[] nArray = new int[10];
        try {
            int n2;
            Object object;
            int n3;
            int n4 = string.lastIndexOf(37);
            if (n4 != -1) {
                string = string.substring(0, n4);
            }
            if ((n3 = string.indexOf(47)) != -1) {
                object = string.substring(n3 + 1, string.length());
                n2 = -1;
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string = n2 >= 0 && n2 <= 128 ? string.substring(0, n3) : string.substring(n3 + 1, string.length());
            }
            if (string.indexOf(46) != -1 && string.indexOf(58) == -1) {
                object = new StringTokenizer(string, ".");
                n2 = 6;
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    nArray[n2] = Integer.parseInt(string2);
                    ++n2;
                }
            } else if (string.indexOf(58) != -1) {
                string = IOFunctions.normalizeIPv6(string);
                object = new StringTokenizer(string, ":");
                n2 = 0;
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    if (string3.indexOf(46) != -1) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
                        while (stringTokenizer.hasMoreElements()) {
                            String string4 = stringTokenizer.nextToken();
                            nArray[n2] = Integer.parseInt(string4);
                            ++n2;
                        }
                        continue;
                    }
                    nArray[n2] = Integer.parseInt(string3, 16);
                    ++n2;
                }
            } else {
                throw new Exception("Address \"" + string + "\" is neither an Internet Protocol version 4 (IPv4) address nor an Internet Protocol version 6 (IPv6) address.");
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Address \"" + string + "\" is invalid");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new Exception("Address \"" + string + "\" is invalid");
        }
    }

    public static String normalizeIPv6(String addressString) {
        String[] stringArray = addressString.split(":");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].length() == 0 && i2 > 0) {
                int n2 = 8 - (stringArray.length - 1);
                String string = stringArray[stringArray.length - 1];
                if (n2 > 0 && string != null && string.indexOf(46) != -1) {
                    --n2;
                }
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(":");
                    }
                    stringBuilder.append("0");
                }
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(":");
            }
            if (stringArray[i2].length() == 0) {
                stringBuilder.append("0");
                continue;
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static byte[] serialize(Throwable th) {
        try {
            return IOFunctions.b(th);
        }
        catch (IOException iOException) {
            if (IOFunctions.a(th)) {
                return IOFunctions.serialize(th);
            }
            try {
                Exception exception = new Exception(th.toString());
                exception.setStackTrace(th.getStackTrace());
                return IOFunctions.b(exception);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(exception);
                throw runtimeException;
            }
        }
    }

    private static boolean a(Throwable throwable) {
        try {
            Throwable throwable2;
            Field field = Throwable.class.getDeclaredField("cause");
            field.setAccessible(true);
            while ((throwable2 = throwable.getCause()) != null) {
                Throwable throwable3 = throwable2.getCause();
                if (throwable3 == null) {
                    field.set(throwable, throwable);
                    return true;
                }
                throwable = throwable2;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static byte[] b(Throwable throwable) throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fastByteArrayOutputStream);
        objectOutputStream.writeObject(throwable);
        objectOutputStream.close();
        return fastByteArrayOutputStream.toByteArray();
    }

    public static void copy(Path file, Path targetFile) throws IOException {
        Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(final Path srcDir, final Path targetDir) throws IOException {
        if (Files.isDirectory(srcDir, new LinkOption[0])) {
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        Files.walkFileTree(srcDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Path path2 = targetDir.resolve(srcDir.toAbsolutePath().relativize(path.toAbsolutePath()).toString());
                try {
                    Files.copy(path, path2, copyOptionArray);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult b(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.copy(path, targetDir.resolve(srcDir.toAbsolutePath().relativize(path.toAbsolutePath()).toString()), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult a(Path path, IOException iOException) {
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult b(Path path, IOException iOException) throws IOException {
                throw iOException;
            }

            @Override
            public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                return this.a((Path)object, iOException);
            }

            @Override
            public /* synthetic */ FileVisitResult visitFileFailed(Object object, IOException iOException) throws IOException {
                return this.b((Path)object, iOException);
            }

            @Override
            public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.b((Path)object, basicFileAttributes);
            }

            @Override
            public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.a((Path)object, basicFileAttributes);
            }
        });
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    public static InputStream openStreamSupportingRedirect(@Nonnull URL url, int timeout) throws IOException {
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            int n2 = 0;
            while (true) {
                Object object;
                httpURLConnection.setConnectTimeout(timeout);
                httpURLConnection.setReadTimeout(timeout);
                httpURLConnection.setInstanceFollowRedirects(true);
                if (url.getUserInfo() != null) {
                    object = "Basic " + Base64.getEncoder().encodeToString(url.getUserInfo().getBytes(StandardCharsets.UTF_8));
                    httpURLConnection.setRequestProperty("Authorization", (String)object);
                }
                httpURLConnection.connect();
                int n3 = httpURLConnection.getResponseCode();
                if (n3 <= 300 || n3 >= 400 || n3 == 304 || n2 >= 5) break;
                object = httpURLConnection.getHeaderField("Location");
                httpURLConnection = (HttpURLConnection)new URL((String)object).openConnection();
                uRLConnection = httpURLConnection;
                ++n2;
            }
        }
        return uRLConnection.getInputStream();
    }

    public static boolean isPathTraversal(@Nullable String fileName) {
        if (fileName == null) {
            return false;
        }
        if (!fileName.contains("..")) {
            return false;
        }
        return (fileName = fileName.replace('\\', '/')).contains("/../") || fileName.startsWith("../") || fileName.endsWith("/..") || fileName.equals("..");
    }

    @Nonnull
    public static DataInputStream loadDataInputStream(@Nonnull RandomAccessFile raFile, int bufferSize) throws IOException {
        byte[] byArray = new byte[bufferSize];
        raFile.readFully(byArray);
        return new DataInputStream(new FastByteArrayInputStream(byArray));
    }

    public static void writeInt(@Nonnull WritableByteChannel channel, int value) throws IOException {
        channel.write(ByteBuffer.allocate(4).putInt(0, value));
    }

    public static int readInt(ReadableByteChannel channel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        channel.read(byteBuffer);
        return byteBuffer.getInt(0);
    }

    @Nullable
    public static String toJsonNullable(@Nullable Object data) {
        return data == null ? null : new Json().toJson(data);
    }

    @Nullable
    public static <T> T fromJsonNullable(@Nullable String json, @Nonnull Class<T> clazz) {
        return json == null || json.equals("null") ? null : (T)new Json().fromJson(json, clazz);
    }

    @Nullable
    public static <T> T fromJsonNullable(@Nullable String json, @Nonnull Type clazz) {
        return json == null || json.equals("null") ? null : (T)new Json().fromJson(json, clazz);
    }

    @Nullable
    public static <T> T fromJsonNullable(@Nullable String json, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields) {
        return json == null || json.equals("null") ? null : (T)new Json().fromJson(json, clazz, extraFields);
    }

    public static byte[] getDataURL(BufferedImage img) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(b);
        OutputStream outputStream = Base64.getEncoder().wrap(byteArrayOutputStream);
        ImageIO.write((RenderedImage)img, "png", outputStream);
        outputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

