/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import java.io.IOException;
import java.io.OutputStream;

@InternalApi
public class FastBufferedOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected OutputStream out;

    public FastBufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public FastBufferedOutputStream(OutputStream out, int size) {
        this.out = out;
        this.buf = new byte[size];
    }

    private void a() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.count >= this.buf.length) {
            this.a();
        }
        this.buf[this.count++] = (byte)b2;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.a();
            this.out.write(b2, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.a();
        }
        System.arraycopy(b2, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.a();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream outputStream = this.out;){
            this.a();
        }
    }
}

