/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.utils;

import com.inet.annotations.InternalApi;
import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class MimeTypes {
    public static final String UNKNOWN = "application/octet-stream";
    public static final String BIN = "application/crystalclear";
    public static final String PDF = "application/pdf";
    public static final String PS = "application/ps";
    public static final String RTF = "application/msword";
    public static final String XLS = "application/vnd.ms-excel";
    public static final String XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String CSV = "text/x-comma-separated-values";
    public static final String XML = "text/xml; charset=utf-8";
    public static final String TXT = "text/plain; charset=utf-8";
    public static final String HTM = "text/html; charset=utf-8";
    public static final String JPEG = "image/jpeg";
    public static final String JPG = "image/jpeg";
    public static final String JP2 = "image/jp2";
    public static final String PNG = "image/png";
    public static final String GIF = "image/gif";
    public static final String BMP = "image/bmp";
    public static final String SVG = "image/svg+xml";
    public static final String ICO = "image/x-icon";
    public static final String WEBP = "image/webp";
    public static final String AVIF = "image/avif";
    public static final String CSS = "text/css";
    public static final String ODS = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String JSON = "application/json; charset=utf-8";
    public static final String JAVASCRIPT = "application/javascript; charset=utf-8";
    public static final String WOFF = "application/font-woff";
    public static final String MARKDOWN = "text/x-markdown";
    public static final String DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String JRA = "application/jra";
    public static final String JAR = "application/java-archive";
    public static final String ZIP = "application/zip";
    public static final String JSON_BINARY = "application/binary-json";
    public static final String JSON_ERROR = "application/error-json";
    public static final String JSON_HELPDESK = "application/helpdesk-json";
    public static final String JSON_HELPDESK_ERROR = "application/helpdesk-error-json";
    public static final String MSI = "application/x-msi";
    public static final String DMG = "application/x-apple-diskimage";
    public static final String RPM = "application/x-redhat-package";
    public static final String DEB = "application/vnd.debian.binary-package";
    private static final HashMap<String, String> a = new HashMap();

    @Nonnull
    public static @Nonnull Set<@Nonnull String> getFileFilters(String mimeType) {
        HashSet<@Nonnull String> hashSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : a.entrySet()) {
            if (!entry.getValue().equals(mimeType)) continue;
            hashSet.add("*." + entry.getKey());
        }
        return hashSet;
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No file access")
    public static String getMimeType(String fileName) {
        if (fileName == null || ((String)fileName).isEmpty()) {
            return UNKNOWN;
        }
        String string = ((String)fileName).substring(((String)fileName).lastIndexOf(46) + 1);
        if ((string = a.get(string.toLowerCase())) == null) {
            try {
                if (!((String)fileName).contains(".")) {
                    fileName = "x." + (String)fileName;
                }
                string = Files.probeContentType(new File((String)fileName).toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                return UNKNOWN;
            }
        }
        return string;
    }

    @Nonnull
    public static String getMimeTypeFromData(byte[] data) {
        return MimeTypes.a(data, 0);
    }

    @Nonnull
    private static String a(byte[] byArray, int n2) {
        block17: while (true) {
            if (byArray == null || byArray.length < 5 + n2) {
                return UNKNOWN;
            }
            switch (byArray[n2]) {
                case 0: {
                    if (byArray[n2 + 4] != 106) break block17;
                    return JP2;
                }
                case -119: {
                    if (byArray[n2 + 1] != 80 || byArray[n2 + 2] != 78 || byArray[n2 + 3] != 71) break block17;
                    return PNG;
                }
                case 71: {
                    if (byArray[n2 + 1] != 73 || byArray[n2 + 2] != 70 || byArray[n2 + 3] != 56) break block17;
                    return GIF;
                }
                case 60: {
                    switch (byArray[n2 + 1]) {
                        case 33: {
                            if (MimeTypes.b(byArray, n2 + 2, "DOCTYPE")) {
                                if (MimeTypes.a(byArray, n2, "svg")) {
                                    return SVG;
                                }
                                if (MimeTypes.a(byArray, n2, "html")) {
                                    return HTM;
                                }
                                return XML;
                            }
                            if (byArray[n2 + 2] == 45) {
                                n2 += 3;
                                while (byArray.length > n2 && byArray[n2] != 62) {
                                    ++n2;
                                }
                                ++n2;
                                continue block17;
                            }
                        }
                        case 72: 
                        case 104: {
                            return HTM;
                        }
                        case 115: {
                            return SVG;
                        }
                        case 63: {
                            while (byArray.length > n2 && byArray[n2] != 62) {
                                ++n2;
                            }
                            String string = MimeTypes.a(byArray, n2 + 1);
                            return string == UNKNOWN ? XML : string;
                        }
                    }
                    break block17;
                }
                case -1: {
                    if (byArray[n2 + 1] != -40 || byArray[n2 + 2] != -1) break block17;
                    return "image/jpeg";
                }
                case 82: {
                    if (byArray[n2 + 1] != 73 || byArray[n2 + 2] != 70 || byArray[n2 + 3] != 70) break block17;
                    return WEBP;
                }
                case 10: 
                case 13: 
                case 32: {
                    ++n2;
                    continue block17;
                }
                case 91: 
                case 123: {
                    return JSON;
                }
                case 80: {
                    if (byArray[n2 + 1] != 75 || byArray[n2 + 2] != 3 || byArray[n2 + 3] != 4) break block17;
                    return ZIP;
                }
            }
            break;
        }
        return UNKNOWN;
    }

    private static boolean a(byte[] byArray, int n2, String string) {
        String string2 = new String(byArray, n2, Math.min(50, byArray.length - n2)).toLowerCase();
        return string2.contains(string.toLowerCase());
    }

    private static boolean b(byte[] byArray, int n2, String string) {
        if (byArray == null || string == null) {
            return false;
        }
        int n3 = string.length();
        if (n2 < 0 || n2 + n3 > byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[n2 + i2] == (byte)string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    static {
        a.put("pdf", PDF);
        a.put("ps", PS);
        a.put("rtf", RTF);
        a.put("pdf", PDF);
        a.put("xls", XLS);
        a.put("xlsx", XLSX);
        a.put("csv", CSV);
        a.put("xml", XML);
        a.put("txt", TXT);
        a.put("html", HTM);
        a.put("htm", HTM);
        a.put("jpg", "image/jpeg");
        a.put("jpeg", "image/jpeg");
        a.put("jp2", JP2);
        a.put("png", PNG);
        a.put("gif", GIF);
        a.put("bmp", BMP);
        a.put("ico", ICO);
        a.put("webp", WEBP);
        a.put("avif", AVIF);
        a.put("css", CSS);
        a.put("svg", SVG);
        a.put("ods", ODS);
        a.put("json", JSON);
        a.put("js", JAVASCRIPT);
        a.put("woff", WOFF);
        a.put("jra", JRA);
        a.put("jar", JAR);
        a.put("zip", ZIP);
        a.put("docx", DOCX);
        a.put("msi", MSI);
        a.put("dmg", DMG);
        a.put("rpm", RPM);
        a.put("deb", DEB);
    }
}

