/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.security;

import com.inet.http.security.CombinedKeyStore;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.security.KeyStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public class CombinedKeyStoreEx
extends CombinedKeyStore {
    @Override
    protected void logRootCertificates(@Nonnull String algorithm, @Nonnull KeyStoreSpi spi) {
        Logger logger = LogManager.getConfigLogger();
        if (logger.isDebug()) {
            ForkJoinPool.commonPool().execute(() -> {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(algorithm).append('\n');
                Enumeration<String> enumeration = spi.engineAliases();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    Certificate certificate = spi.engineGetCertificate(string2);
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    stringBuilder.append('\t').append(x509Certificate.getIssuerX500Principal()).append('\n');
                }
                logger.debug(stringBuilder);
            });
        }
    }
}

