/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.font.FontFamily;
import com.inet.font.FontPool;
import com.inet.font.IRendererPostscript;
import com.inet.font.cache.FontNameProcessor;
import com.inet.font.layout.SoftFontLayoutMap;
import com.inet.font.layout.TTFontLayout;
import com.inet.font.truetype.InstalledFontTT;
import com.inet.font.truetype.InstalledFontTTSupplier;
import com.inet.font.unicode.IUnicodeRange;
import com.inet.font.unicode.UnicodeCharBlock;
import com.inet.logging.LogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ReplacingFontFinder
implements Serializable {
    private static final long serialVersionUID = 19990523L;
    private transient SoftFontLayoutMap a;
    private Map b;
    private IRendererPostscript c;
    private EMB_FONT_CONSUMER d;

    public ReplacingFontFinder(SoftFontLayoutMap ttFontLayouts, Map installedFonts, IRendererPostscript postscript, EMB_FONT_CONSUMER consumer) {
        this.a = ttFontLayouts;
        this.b = installedFonts;
        this.c = postscript;
        this.d = consumer;
    }

    @Nullable
    TTFontLayout a(int n2, InstalledFontTT installedFontTT, int n3, int n4) {
        TTFontLayout tTFontLayout = null;
        InstalledFontTT installedFontTT2 = this.a(n2, installedFontTT, n3);
        if (installedFontTT2 != null && (tTFontLayout = (TTFontLayout)this.a.get(installedFontTT2.filenameOfTTFont(), n3, n4)) == null) {
            tTFontLayout = new TTFontLayout(installedFontTT2, installedFontTT2.filenameOfTTFont(), n3, n4);
            this.a.put(tTFontLayout);
        }
        return tTFontLayout;
    }

    public Map getInstalledFontMap() {
        return this.b;
    }

    public SoftFontLayoutMap getFontLayoutMap() {
        return this.a;
    }

    private static Comparator<FontFamily> a(String string, int n2, Map map, b ... bArray) {
        return new a(string, n2, map, bArray);
    }

    @Nullable
    public InstalledFontTT getInstalledFontByNameAndStyle(String fontFamilyName, int fontStyle) {
        String string = FontNameProcessor.getCompositeName(fontFamilyName, fontStyle);
        InstalledFontTT installedFontTT = (InstalledFontTT)this.b.get(string);
        if (installedFontTT == null && (installedFontTT = InstalledFontTTSupplier.getInstalledFont(fontFamilyName, fontStyle, this.c, true, this)) != null) {
            this.b.put(string, installedFontTT);
        }
        return installedFontTT;
    }

    @Nullable
    private FontFamily a(IUnicodeRange iUnicodeRange, String string, String string2, int n2, int n3) {
        InstalledFontTT installedFontTT;
        String string3;
        int n4;
        Object object;
        List<FontFamily> list = FontPool.getFontInstalled();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            FontFamily fontFamily = list.get(i2);
            if (fontFamily.isSymbolicFont()) {
                list.remove(i2);
                continue;
            }
            if (string2 != null && string2.equals(fontFamily.getName())) {
                list.remove(i2);
                continue;
            }
            object = fontFamily.getUnicodeCharBlocks();
            if (object != null && object.contains(iUnicodeRange)) continue;
            list.remove(i2);
        }
        Comparator<FontFamily> comparator = ReplacingFontFinder.a(string, n2, this.b, com.inet.font.truetype.ReplacingFontFinder$b.values());
        list.sort(comparator);
        for (n4 = 0; n4 < list.size(); ++n4) {
            object = list.get(n4);
            if (n3 >= 0) {
                string3 = FontNameProcessor.getCompositeName(((FontFamily)object).getName(), n2);
                installedFontTT = (InstalledFontTT)this.b.get(string3);
                if (installedFontTT == null) {
                    installedFontTT = InstalledFontTTSupplier.getInstalledFont(((FontFamily)object).getName(), n2, this.c, true, this);
                }
                if (!installedFontTT.canDisplay(n3)) continue;
                this.b.put(string3, installedFontTT);
            }
            return object;
        }
        if (n3 >= 0) {
            list = FontPool.getFontInstalled();
            for (n4 = 0; n4 < list.size(); ++n4) {
                object = list.get(n4);
                string3 = FontNameProcessor.getCompositeName(((FontFamily)object).getName(), n2);
                installedFontTT = (InstalledFontTT)this.b.get(string3);
                if (installedFontTT == null) {
                    installedFontTT = InstalledFontTTSupplier.getInstalledFont(((FontFamily)object).getName(), n2, this.c, true, this);
                }
                if (!installedFontTT.canDisplay(n3)) continue;
                this.b.put(string3, installedFontTT);
                return object;
            }
        }
        return null;
    }

    private InstalledFontTT a(int n2, InstalledFontTT installedFontTT, int n3) {
        String string;
        UnicodeCharBlock unicodeCharBlock;
        FontFamily fontFamily;
        InstalledFontTT installedFontTT2 = null;
        String string2 = installedFontTT.getFontType();
        if (string2 == null && LogManager.getApplicationLogger().isDebug()) {
            LogManager.getApplicationLogger().debug("-------Font type for " + installedFontTT.filenameOfTTFont() + " is not found");
        }
        if ((fontFamily = this.a(unicodeCharBlock = UnicodeCharBlock.getUnicodeBlock(n2), string2, installedFontTT.filenameOfTTFont(), n3, n2)) == null && n2 > 65535) {
            unicodeCharBlock = UnicodeCharBlock.NON_PLAIN_0;
            fontFamily = this.a(unicodeCharBlock, string2, installedFontTT.filenameOfTTFont(), n3, n2);
        }
        if (fontFamily != null && (installedFontTT2 = (InstalledFontTT)this.b.get(string = FontNameProcessor.getCompositeName(fontFamily.getName(), n3))) == null) {
            installedFontTT2 = InstalledFontTTSupplier.getInstalledFont(fontFamily.getName(), n3, this.c, true, this);
            this.b.put(string, installedFontTT2);
        }
        return installedFontTT2;
    }

    public IRendererPostscript getPostscript() {
        return this.c;
    }

    @Nullable
    public FontFamily getReplacingFontFamily(IUnicodeRange unicodeRange, String fontType, int fontStyle, int ch) {
        return this.a(unicodeRange, fontType, null, fontStyle, ch);
    }

    public boolean isJAVA_EXPORT() {
        return this.d == EMB_FONT_CONSUMER.JAVA;
    }

    public static List<String> getFontNameList(@Nullable String fontType) {
        List<Object> list = new ArrayList();
        List<FontFamily> list2 = FontPool.getFontInstalled();
        list = fontType == null ? list2.stream().map(fontFamily -> fontFamily.getName()).collect(Collectors.toList()) : list2.stream().filter(fontFamily -> fontType.equals(fontFamily.getFontType())).map(fontFamily -> fontFamily.getName()).collect(Collectors.toList());
        return list;
    }

    public static final class EMB_FONT_CONSUMER
    extends Enum<EMB_FONT_CONSUMER> {
        public static final /* enum */ EMB_FONT_CONSUMER JAVA = new EMB_FONT_CONSUMER();
        public static final /* enum */ EMB_FONT_CONSUMER PDF = new EMB_FONT_CONSUMER();
        public static final /* enum */ EMB_FONT_CONSUMER PS = new EMB_FONT_CONSUMER();
        private static final /* synthetic */ EMB_FONT_CONSUMER[] a;

        public static EMB_FONT_CONSUMER[] values() {
            return (EMB_FONT_CONSUMER[])a.clone();
        }

        public static EMB_FONT_CONSUMER valueOf(String name) {
            return Enum.valueOf(EMB_FONT_CONSUMER.class, name);
        }

        private static /* synthetic */ EMB_FONT_CONSUMER[] a() {
            return new EMB_FONT_CONSUMER[]{JAVA, PDF, PS};
        }

        static {
            a = EMB_FONT_CONSUMER.a();
        }
    }

    private static class a
    implements Comparator<FontFamily> {
        private b[] a;
        private String b;
        private int c;
        private Map d;
        private static final boolean isType1 = false;

        private a(String string, int n2, Map map, b[] bArray) {
            this.b = string;
            this.c = n2;
            this.a = bArray;
            this.d = map;
        }

        public int a(FontFamily fontFamily, FontFamily fontFamily2) {
            block7: for (b b2 : this.a) {
                switch (b2) {
                    case c: {
                        int n2 = fontFamily.getFontRank() - fontFamily2.getFontRank();
                        if (n2 == 0) continue block7;
                        return n2;
                    }
                    case a: {
                        if (fontFamily.isType1() == fontFamily2.isType1()) continue block7;
                        if (!fontFamily.isType1()) {
                            return -1;
                        }
                        return 1;
                    }
                    case e: {
                        String string = FontNameProcessor.getCompositeName(fontFamily.getName(), this.c);
                        Object v = this.d.get(string);
                        String string2 = FontNameProcessor.getCompositeName(fontFamily2.getName(), this.c);
                        Object v2 = this.d.get(string2);
                        if (v != null) {
                            if (v2 != null) continue block7;
                            return -1;
                        }
                        if (v2 == null) continue block7;
                        return 1;
                    }
                    case d: {
                        if (fontFamily.getStyle() == this.c) {
                            if (fontFamily2.getStyle() == this.c) continue block7;
                            return -1;
                        }
                        if (fontFamily2.getStyle() != this.c) continue block7;
                        return 1;
                    }
                    case b: {
                        if (fontFamily.getFontType() == this.b) {
                            if (fontFamily2.getFontType() == this.b) continue block7;
                            return -1;
                        }
                        if (fontFamily2.getFontType() != this.b) continue block7;
                        return 1;
                    }
                }
            }
            return fontFamily.getName().compareTo(fontFamily2.getName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((FontFamily)object, (FontFamily)object2);
        }
    }

    private static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        public static final /* enum */ b d = new b();
        public static final /* enum */ b e = new b();
        private static final /* synthetic */ b[] f;

        public static b[] values() {
            return (b[])f.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c, d, e};
        }

        static {
            f = com.inet.font.truetype.ReplacingFontFinder$b.a();
        }
    }
}

