/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.font.FontUtils;
import com.inet.font.cepack.AdobeCharNames;
import com.inet.font.cepack.CEFontData;
import com.inet.font.layout.AdobeCEFontLayout;
import com.inet.font.layout.HasEncodingDifferences;
import com.inet.lib.list.CharCharMap;
import com.inet.lib.list.CharList;
import com.inet.logging.LogManager;
import com.inet.shared.utils.MemoryStream;
import java.io.Serializable;
import java.util.ArrayList;

public class Type1CEFont
implements HasEncodingDifferences,
Serializable {
    static final long serialVersionUID = 39766621012L;
    private static final boolean USE_UNI_NAMES_AS_DEFAULT = false;
    private static final byte[] a = FontUtils.getBytes(" /uni");
    private static final byte[] b = FontUtils.getBytes(" /uni" + "0".toUpperCase());
    private static final byte[] c = FontUtils.getBytes(" /uni" + "00".toUpperCase());
    private static final byte[] d = FontUtils.getBytes(" /uni000");
    private static final byte[] e = FontUtils.getBytes(" /u");
    private static final byte[] f = FontUtils.getBytes("/CIDInit /ProcSet findresource begin 12 dict begin begincmap ");
    private static final byte[] g = FontUtils.getBytes("/CIDSystemInfo << /Registry (F4+0) /Ordering (T1UV) /Supplement 0 >> def\n");
    private static final byte[] h = FontUtils.getBytes("/CMapName /F4+0 def\n/CMapType 2 def\n");
    private static final byte[] i = FontUtils.getBytes("1 begincodespacerange ");
    private static final byte[] j = FontUtils.getBytes(" endcodespacerange\n");
    private static final byte[] k = FontUtils.getBytes(" beginbfchar\n");
    private static final byte[] l = FontUtils.getBytes("endbfchar\n");
    private static final byte[] m = FontUtils.getBytes("endcmap CMapName currentdict /CMap defineresource pop end end");
    private static final int MAX_SIZE = 255;
    private static final int CONTROL_SYMBOLS_SIZE = 32;
    private static final int ASCII_INTERVAL_SIZE = 128;
    private char[] n = new char[256];
    private CharCharMap o;
    private CharList p = new CharList();
    private int q = -1;
    private int r = -1;
    private int s = -1;
    private int t = -1;
    private int u;
    private int v;
    private String w;
    private CEFontData x;
    private ArrayList<AdobeCEFontLayout> y;
    private MemoryStream z;
    private boolean A = false;
    private int B;
    private int C;

    public Type1CEFont(String name, int javaStyle, int fontFamilyID) {
        this.w = name;
        this.o = new CharCharMap();
        this.x = CEFontData.getFont(fontFamilyID, javaStyle);
        this.y = new ArrayList();
        this.C = javaStyle;
    }

    public boolean textCanBeWritten(String text) {
        int n2 = this.p.size();
        int n3 = 255 - this.o.size() - this.B - 32 - n2;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 < '\u0080' && (c2 < ' ' || this.n[c2] == c2) || this.p.indexOf(c2) != -1 || this.o.contains(c2)) continue;
            if (n3-- <= 0) {
                return false;
            }
            this.p.addElement(c2);
        }
        return true;
    }

    public byte[] encodeText(String text) {
        int n2 = text.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = text.charAt(i2);
            char c3 = this.a(c2);
            byArray[i2] = (byte)c3;
        }
        this.p.clear();
        return byArray;
    }

    private char a(char c2) {
        char c3;
        if (c2 < '\u0080') {
            if (c2 < ' ' || this.n[c2] == c2) {
                return c2;
            }
            if (this.n[c2] == '\u0000') {
                this.n[c2] = c2;
                ++this.B;
                if (c2 > this.r) {
                    this.r = c2;
                }
                if (this.q == -1 || c2 < this.q) {
                    this.q = c2;
                }
                return c2;
            }
        }
        if ((c3 = this.o.get(c2)) == '\uffff') {
            char c4 = '\u0000';
            if (c2 < '\u0080') {
                c4 = this.a();
                if (c4 != '\u0000') {
                    this.n[c4] = c2;
                    c3 = c4;
                }
                if (c4 > this.r) {
                    this.r = c4;
                }
                if (this.q == -1 || c4 < this.q) {
                    this.q = c4;
                }
            }
            if (c4 == '\u0000') {
                c4 = this.b();
                if (c4 != '\u0000') {
                    this.n[c4] = c2;
                    c3 = c4;
                    if (c4 > this.t) {
                        this.t = c4;
                    }
                    if (this.s == -1 || c4 < this.s) {
                        this.s = c4;
                    }
                } else if (c2 >= '\u0080' && (c4 = this.a()) != '\u0000') {
                    this.n[c4] = c2;
                    c3 = c4;
                    if (c4 > this.r) {
                        this.r = c4;
                    }
                    if (this.q == -1 || c4 < this.q) {
                        this.q = c4;
                    }
                }
            }
            if (c4 == '\u0000') {
                if (LogManager.getApplicationLogger().isWarning()) {
                    LogManager.getApplicationLogger().warn("character 0x" + Integer.toHexString(c2) + " has not been found");
                }
                return '\uffff';
            }
            this.o.put(c2, c4);
        }
        return c3;
    }

    private char a() {
        for (int i2 = 32; i2 < 128; ++i2) {
            if (this.n[i2] != '\u0000') continue;
            return (char)i2;
        }
        return '\u0000';
    }

    private char b() {
        for (int i2 = 128; i2 < 255; ++i2) {
            if (this.n[i2] != '\u0000') continue;
            return (char)i2;
        }
        return '\u0000';
    }

    private void c() {
        if (this.z == null) {
            this.z = new MemoryStream();
        } else {
            this.z.setLength(0);
        }
    }

    @Override
    public MemoryStream getDifferences() {
        this.d();
        this.c();
        int n2 = 0;
        boolean bl = false;
        this.a(bl, n2);
        bl = true;
        this.a(bl, n2);
        return this.z;
    }

    private int a(boolean bl, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n3 = bl ? this.t : this.r;
        for (int i2 = bl ? 128 : 0; i2 <= n3; ++i2) {
            char c2 = this.n[i2];
            if (c2 == '\u0000' || c2 == i2) continue;
            ++n4;
            if (n2 != i2 - 1) {
                this.z.write(32);
                this.z.writeIntAsString(i2);
            }
            n2 = i2;
            String string = this.b(c2);
            if (string == null || "sigma1".equals(string)) {
                Type1CEFont.writeUnicodeName(this.z, c2);
                continue;
            }
            this.z.write(32);
            this.z.write(47);
            this.z.write(FontUtils.getBytes(string));
        }
        return n4;
    }

    public MemoryStream getWidthsStream() {
        this.d();
        this.c();
        for (int i2 = this.u; i2 <= this.v; ++i2) {
            char c2 = this.n[i2];
            int n2 = c2 == '\u0000' ? 0 : this.getCharWidth(c2);
            this.z.write(32);
            this.z.writeIntAsString(n2);
        }
        return this.z;
    }

    public int getCharWidth(int ch) {
        return this.x.getWidth(ch);
    }

    private String b(char c2) {
        return AdobeCharNames.getCharName(c2);
    }

    public AdobeCEFontLayout getLayout(int fontSizeTwips) {
        AdobeCEFontLayout adobeCEFontLayout;
        for (int i2 = 0; i2 < this.y.size(); ++i2) {
            adobeCEFontLayout = this.y.get(i2);
            if (adobeCEFontLayout.getSizeTwips() != fontSizeTwips) continue;
            return adobeCEFontLayout;
        }
        adobeCEFontLayout = new AdobeCEFontLayout(this, fontSizeTwips);
        this.y.add(adobeCEFontLayout);
        return adobeCEFontLayout;
    }

    public String getName() {
        return this.w;
    }

    public int getStyle() {
        return this.C;
    }

    public CEFontData getCEFontData() {
        return this.x;
    }

    public MemoryStream getMappingStream() {
        this.d();
        MemoryStream memoryStream = new MemoryStream();
        int n2 = 0;
        for (int i2 = this.u; i2 <= this.v; ++i2) {
            char c2 = this.n[i2];
            if (c2 == '\u0000') continue;
            Type1CEFont.a(memoryStream, i2);
            memoryStream.write(32);
            Type1CEFont.a(memoryStream, c2);
            memoryStream.write(10);
            ++n2;
        }
        MemoryStream memoryStream2 = new MemoryStream();
        memoryStream2.write(f);
        memoryStream2.write(g);
        memoryStream2.write(h);
        memoryStream2.write(i);
        Type1CEFont.a(memoryStream2, this.u);
        memoryStream2.write(32);
        Type1CEFont.a(memoryStream2, this.v);
        memoryStream2.write(j);
        memoryStream2.writeIntAsString(n2);
        memoryStream2.write(k);
        memoryStream.writeTo(memoryStream2);
        memoryStream2.write(l);
        memoryStream2.write(m);
        return memoryStream2;
    }

    private static void a(MemoryStream memoryStream, int n2) {
        if (n2 < 0) {
            throw new RuntimeException("illegal argument " + n2);
        }
        memoryStream.write(60);
        if (n2 < 16 || n2 >= 256 && n2 < 4096) {
            memoryStream.write(48);
        }
        memoryStream.write(FontUtils.getBytes(Integer.toHexString(n2)));
        memoryStream.write(62);
    }

    public int getMinChar() {
        this.d();
        return this.u;
    }

    public int getMaxChar() {
        this.d();
        return this.v;
    }

    private void d() {
        if (this.A) {
            return;
        }
        this.A = true;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.q != -1) {
            this.u = this.q;
            bl = true;
            if (this.r != -1) {
                this.v = this.r;
                bl2 = true;
            }
        } else if (this.r != -1) {
            bl = true;
        }
        if (this.s != -1) {
            bl3 = true;
            if (!bl) {
                this.u = this.s;
            }
            if (this.t != -1) {
                this.v = this.t;
                bl4 = true;
            }
        } else if (this.t != -1) {
            bl3 = true;
        }
        if (!bl && !bl3) {
            LogManager.getApplicationLogger().warn("no characters found in font " + this.w);
            this.u = 0;
            this.v = 0;
            return;
        }
        if (!(bl && !bl2 || bl3 && !bl4)) {
            return;
        }
        String string = "invalid byte mapping in font " + this.w;
        if (bl && !bl2) {
            string = string + " in low";
            string = bl3 && !bl4 ? string + " and high interval" : string + " interval";
        } else {
            string = string + " in high interval";
        }
        LogManager.getApplicationLogger().error(string);
        this.u = 0;
        this.v = 0;
    }

    public static void writeUnicodeName(MemoryStream stream, char ch) {
        if (ch < '\u0010') {
            stream.write(d);
        } else if (ch < '\u0100') {
            stream.write(c);
        } else if (ch < '\u1000') {
            stream.write(b);
        } else if (ch < '\u10000') {
            stream.write(a);
        } else {
            stream.write(e);
        }
        stream.write(FontUtils.getBytes(Integer.toHexString(ch).toUpperCase()));
    }
}

