/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.cache;

import com.inet.font.FontFamily;
import com.inet.font.cache.FontNameProcessor;
import com.inet.font.cache.FontPathMapping;
import com.inet.font.truetype.FontFactoriesCache;
import com.inet.logging.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FontFamilyListHandler {
    private static List<FontFamily> a;
    private static int b;

    public static void refresh() {
        a = new ArrayList<FontFamily>();
    }

    public static void addFontFamily(FontFamily newFontFamily) {
        ++b;
        for (int i2 = 0; i2 < a.size(); ++i2) {
            FontFamily fontFamily = a.get(i2);
            if (!fontFamily.equals(newFontFamily)) continue;
            if (newFontFamily.isPlain()) {
                if (fontFamily.isPlain()) {
                    newFontFamily.setNext(fontFamily.getNext());
                } else {
                    newFontFamily.setNext(fontFamily);
                }
                a.set(i2, newFontFamily);
            } else if (fontFamily.isPlain()) {
                fontFamily.addOrReplace(newFontFamily);
            } else if (newFontFamily.getStyle() == fontFamily.getStyle()) {
                newFontFamily.setNext(fontFamily.getNext());
                a.set(i2, newFontFamily);
            } else {
                fontFamily.addOrReplace(newFontFamily);
            }
            return;
        }
        a.add(newFontFamily);
    }

    public static void resolveFontFamilyReferences() {
        if (b == 0) {
            return;
        }
        ArrayList<FontFamily> arrayList = null;
        for (FontFamily fontFamily3 : a) {
            if (fontFamily3.isPlain()) {
                if (!fontFamily3.isEmbedded()) {
                    if (!LogManager.getApplicationLogger().isDebug()) continue;
                    LogManager.getApplicationLogger().debug("Not embedded font family object found: " + fontFamily3.getName());
                    continue;
                }
                fontFamily3.setNext(null);
                continue;
            }
            FontFamily fontFamily4 = fontFamily3.getNext();
            if (fontFamily4 != null) {
                fontFamily3.switchToFaceName();
                arrayList = new ArrayList<FontFamily>();
                do {
                    fontFamily4.switchToFaceName();
                    arrayList.add(fontFamily4);
                } while ((fontFamily4 = fontFamily4.getNext()) != null);
                continue;
            }
            String string = FontNameProcessor.getCompositeName(fontFamily3.getName(), fontFamily3.getStyle());
            String string2 = FontNameProcessor.getCompositeName(fontFamily3.getName(), 0);
            FontPathMapping.a(string, string2);
            FontFactoriesCache.extendFontFactoriesMapping(string, string2);
        }
        if (arrayList != null) {
            a.addAll(arrayList);
        }
        Object object = a.iterator();
        while (object.hasNext()) {
            FontFamily fontFamily3;
            fontFamily3 = object.next();
            fontFamily3.setNext(null);
        }
        a = object = a.stream().filter(fontFamily -> !fontFamily.getIsProblematic()).sorted((fontFamily, fontFamily2) -> fontFamily.getName().compareTo(fontFamily2.getName())).collect(Collectors.toList());
        b = 0;
    }

    public static List<FontFamily> getFontFamilyList() {
        return new ArrayList<FontFamily>(a);
    }

    public static List<String> getSansSerifFontNameList() {
        return FontFamilyListHandler.a("SANSSERIF");
    }

    public static List<String> getSerifFontNameList() {
        return FontFamilyListHandler.a("SERIF");
    }

    public static List<String> getMonospacedFontNameList() {
        return FontFamilyListHandler.a("MONOSPACED");
    }

    private static List<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FontFamily fontFamily : a) {
            if (fontFamily.getFontType() != string) continue;
            arrayList.add(fontFamily.getName());
        }
        return arrayList;
    }
}

