/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font;

import com.inet.font.FontPool;
import com.inet.font.FontProvider;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.concurrent.ForkJoinPool;

public class FontUtils {
    public static final int FONT_RANK_HIGH = 1;
    public static final int FONT_RANK_NORMAL = 2;
    public static final int FONT_RANK_SPECIAL = 5;
    public static final int FONT_RANK_LOW = 7;
    public static final int FONT_RANK_UNKNOWN = 10;
    private static FontSettings a;

    public static String getFontMapping(String fontName) {
        String string = FontUtils.findFontFamilyType(fontName);
        if (string == null) {
            string = "SANSSERIF";
        }
        return string;
    }

    public static String findFontFamilyType(String fontName) {
        if ((fontName = fontName.toLowerCase()).indexOf("sansserif") != -1 || fontName.indexOf("sans serif") != -1) {
            return "SANSSERIF";
        }
        if (fontName.indexOf("serif") != -1) {
            return "SERIF";
        }
        if (fontName.indexOf("monospaced") != -1) {
            return "MONOSPACED";
        }
        if (fontName.indexOf("browallia") != -1) {
            return "SANSSERIF";
        }
        if (fontName.indexOf("cordia") != -1) {
            return "MONOSPACED";
        }
        if (fontName.indexOf("angsana") != -1) {
            return "SERIF";
        }
        if (fontName.indexOf("gulim") != -1) {
            return "SANSSERIF";
        }
        if (fontName.indexOf("batang") != -1) {
            return "SERIF";
        }
        if (fontName.indexOf("gothic") != -1) {
            return "SANSSERIF";
        }
        if (fontName.indexOf("mincho") != -1) {
            return "SERIF";
        }
        if (fontName.equals("david")) {
            return "SERIF";
        }
        if (fontName.indexOf("simsun") != -1) {
            return "SERIF";
        }
        if (fontName.indexOf("mingliu") != -1) {
            return "SERIF";
        }
        if (fontName.indexOf("arial") != -1) {
            return "SANSSERIF";
        }
        if (fontName.indexOf("times") != -1) {
            return "SERIF";
        }
        if (fontName.indexOf("courier") != -1) {
            return "MONOSPACED";
        }
        if (fontName.equals("helvetica")) {
            return "SANSSERIF";
        }
        if (fontName.equals("verdana")) {
            return "SANSSERIF";
        }
        if (fontName.equals("dialog")) {
            return "SANSSERIF";
        }
        if (fontName.equals("dialoginput")) {
            return "MONOSPACED";
        }
        if (fontName.indexOf("comic") != -1) {
            return "SANSSERIF";
        }
        return "SANSSERIF";
    }

    public static final Font getFloatingFont(String name, int style, int sizeTwips) {
        style &= 3;
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.SIZE, Float.valueOf((float)sizeTwips / 15.0f));
        hashtable.put(TextAttribute.FAMILY, name);
        if ((style & 1) > 0) {
            hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) > 0) {
            hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(hashtable);
        return font;
    }

    public static int getFontRank(String fontName) {
        if (fontName.equalsIgnoreCase("Arial")) {
            return 1;
        }
        if (fontName.equalsIgnoreCase("Calibri")) {
            return 2;
        }
        if (fontName.equalsIgnoreCase("Times New Roman")) {
            return 1;
        }
        if (fontName.equalsIgnoreCase("Courier New")) {
            return 1;
        }
        if (fontName.startsWith("Arial Unicode")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Browallia")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Cordia")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Angsana New")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Gulim")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Batang")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("MS Gothic")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Mincho")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Simsun")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Mingliu")) {
            return 5;
        }
        if (fontName.equalsIgnoreCase("Verdana")) {
            return 5;
        }
        return 10;
    }

    public static boolean isNotProportional(String fontName) {
        if ((fontName = fontName.toLowerCase()).equals("courier new")) {
            return true;
        }
        if (fontName.equals("ms gothic")) {
            return true;
        }
        if (fontName.equals("ms mincho")) {
            return true;
        }
        if (fontName.equals("simsun")) {
            return true;
        }
        return fontName.equals("mingliu");
    }

    public static byte[] getBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    public static FontSettings getSettings() {
        if (a == null) {
            a = new FontSettings(){

                @Override
                public String getFontPath() {
                    return "";
                }

                @Override
                public boolean isUseNativeFonts() {
                    return true;
                }
            };
        }
        return a;
    }

    public static void setSettings(FontSettings settings) {
        a = settings;
    }

    public static boolean isEudcChar(char ch) {
        if (ch >= '\ue000' && ch <= '\uf8ff') {
            return true;
        }
        if (ch >= '\uf0000' && ch <= '\u10ffff') {
            return true;
        }
        return ch >= '\u8140' && ch < '\u8dff';
    }

    public static boolean isProblematicFont(Font font) {
        font = font.deriveFont(18.0f);
        String string = "Test";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (font.canDisplay(string.charAt(i2))) continue;
            return false;
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        int n2 = graphics2D.getFontMetrics().stringWidth(string);
        return n2 <= 0;
    }

    public static int getFontFamilyTypeID(String fontName) {
        String string;
        switch (string = FontUtils.findFontFamilyType(fontName)) {
            case "SERIF": {
                return 0;
            }
            default: {
                return 1;
            }
            case "MONOSPACED": 
        }
        return 2;
    }

    public static abstract class FontSettings {
        public void fontPathChanged(Object source) {
            if (FontUtils.getSettings() == this) {
                FontPool.a(source);
                this.a();
            }
        }

        public void useNativeFontsChanged(Object source) {
            if (FontUtils.getSettings() == this) {
                this.a();
            }
        }

        private void a() {
            ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
                FontProvider fontProvider = FontProvider.getInstance();
                fontProvider.stateChanged(null);
                fontProvider.getAvailableFonts();
                return null;
            }));
        }

        public abstract String getFontPath();

        public abstract boolean isUseNativeFonts();
    }
}

