/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font;

import com.inet.annotations.InternalApi;
import com.inet.font.AbstractFontProvider;
import com.inet.font.FontFamily;
import com.inet.font.FontPool;
import com.inet.font.FontUtils;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@InternalApi
public class FontProvider
extends AbstractFontProvider
implements ChangeListener {
    private static FontProvider a;
    private String b = "SansSerif";
    private GraphicsEnvironment c;
    private List<FontFamily> d = new ArrayList<FontFamily>();
    private List<FontFamily> e;

    FontProvider(GraphicsEnvironment environment) {
        this.c = environment;
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        if (this.e != null) {
            this.e = null;
            this.fireChangeEvent();
        }
    }

    public static FontProvider getInstance() {
        return a;
    }

    static void a(FontProvider fontProvider) {
        if (a != null) {
            FontPool.removeChangeListener(a);
        }
        a = fontProvider;
        if (fontProvider != null) {
            FontPool.addChangeListener(fontProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FontFamily> getAvailableFonts() {
        if (this.e == null) {
            FontProvider fontProvider = this;
            synchronized (fontProvider) {
                if (this.e == null) {
                    this.e = this.createFontList();
                }
            }
        }
        return this.e;
    }

    protected List<FontFamily> createFontList() {
        List<FontFamily> list = FontPool.getFontInstalled().stream().filter(fontFamily -> !fontFamily.getIsProblematic()).collect(Collectors.toList());
        this.d = new ArrayList(list);
        if (this.isNativeFontsEnabled()) {
            Font[] fontArray = this.c.getAllFonts();
            for (Font font : fontArray) {
                if (font == null) continue;
                int n2 = FontProvider.a(list, font.getFamily(Locale.ENGLISH));
                if (n2 == -1) {
                    list.add(new FontFamily(font.getFamily(), font.getFamily(Locale.ENGLISH)));
                    continue;
                }
                list.get(n2).setInstalledInSystem();
            }
            for (FontFamily fontFamily2 : list) {
                if (fontFamily2.isInstalledInSystem()) continue;
                this.a(fontFamily2);
            }
        } else {
            list.addAll(JAVA_FONTS);
        }
        Collections.sort(list, new a());
        return list;
    }

    protected boolean isNativeFontsEnabled() {
        return FontUtils.getSettings().isUseNativeFonts();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private void a(FontFamily fontFamily) {
        Logger logger = LogManager.getApplicationLogger();
        String string = fontFamily.getFontPath();
        try {
            if (string != null) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Font font = Font.createFont(0, new File(string));
                if (logger.isDebug()) {
                    logger.debug("Register font " + font.getFamily(Locale.ENGLISH) + " in runtime from " + string);
                }
                graphicsEnvironment.registerFont(font);
            }
        }
        catch (Throwable throwable) {
            logger.debug(string);
            logger.error(throwable);
        }
    }

    private static int a(List<FontFamily> list, String string) {
        FontFamily fontFamily;
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            fontFamily = list.get(n2);
            if (!fontFamily.getName().equalsIgnoreCase(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            fontFamily = list.get(n2);
            if (!fontFamily.getLocalizedName().equalsIgnoreCase(string)) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public String getDefaultFont() {
        return this.b;
    }

    @Override
    public boolean isEmbeddedFont(FontFamily fontFamily) {
        return this.d.contains(fontFamily);
    }

    static {
        FontProvider.a(new FontProvider(GraphicsEnvironment.getLocalGraphicsEnvironment()));
    }

    private static class a
    implements Comparator<FontFamily> {
        private a() {
        }

        public int a(FontFamily fontFamily, FontFamily fontFamily2) {
            return fontFamily.getLocalizedName().compareToIgnoreCase(fontFamily2.getLocalizedName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((FontFamily)object, (FontFamily)object2);
        }
    }
}

