/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeGUID;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class FieldTypeFactory {
    protected boolean skipSearchtag = false;
    @Nullable
    protected Integer searchPrio;
    @Nullable
    protected SearchDataType searchDataType;
    @Nullable
    protected SearchTokenizer tokenizer;
    @Nullable
    protected Boolean supportsNull;
    @Nullable
    protected BooleanSupplier showInTextSearchStrategy;
    @Nullable
    protected BooleanSupplier isInTextSearchEnabledStrategy;

    public abstract <VALUE> FieldType<VALUE> create(Field<VALUE> var1, String var2, Supplier<String> var3);

    public static FieldTypeFactory auto() {
        return new FieldTypeFactory(){

            @Override
            public <VALUE> FieldType<VALUE> create(Field<VALUE> field, String key, Supplier<String> labelProvider) {
                if (this.skipSearchtag) {
                    if (field.getValueType() == String.class) {
                        return FieldTypeString.withoutSearchtag(key);
                    }
                    if (field.getValueType() == Integer.class) {
                        return FieldTypeInteger.withoutSearchtag(key);
                    }
                    if (field.getValueType() == Long.class) {
                        return FieldTypeDate.withoutSearchtag(key, true);
                    }
                    if (field.getValueType() == Boolean.class) {
                        return FieldTypeBoolean.withoutSearchtag(key);
                    }
                    if (field.getValueType() == Double.class) {
                        return FieldTypeDouble.withoutSearchtag(key);
                    }
                    if (field.getValueType() == GUID.class) {
                        return FieldTypeGUID.withoutSearchtag(key);
                    }
                    return new FieldType<Object>(key, labelProvider){

                        @Override
                        @Nullable
                        public String getDisplayValue(@Nullable Object value) {
                            return StringFunctions.stringValueOf(value);
                        }

                        @Override
                        public SearchTag createSearchTag(Supplier<String> labelProvider, FieldTypeFactory fieldTypeFactory) {
                            return null;
                        }

                        @Override
                        public Set<FieldOperator> getSupportedOperators() {
                            return Set.of();
                        }
                    };
                }
                FieldType fieldType = null;
                if (field.getValueType() == String.class) {
                    fieldType = new FieldTypeString(key, labelProvider);
                }
                if (field.getValueType() == Integer.class) {
                    fieldType = new FieldTypeInteger(key, labelProvider);
                }
                if (field.getValueType() == Long.class) {
                    fieldType = new FieldTypeDate(key, labelProvider, true);
                }
                if (field.getValueType() == Boolean.class) {
                    fieldType = new FieldTypeBoolean(key, labelProvider);
                }
                if (field.getValueType() == Double.class) {
                    fieldType = new FieldTypeDouble(key, labelProvider);
                }
                if (field.getValueType() == GUID.class) {
                    fieldType = new FieldTypeGUID(key, labelProvider);
                }
                if (fieldType == null) {
                    throw new UnsupportedOperationException("Cannot create auto fieldType for type " + String.valueOf(field.getValueType()) + " in " + key + ". Use custom and override createFieldType");
                }
                return fieldType;
            }
        };
    }

    public static FieldTypeFactory custom() {
        return FieldTypeFactory.custom(null);
    }

    public static FieldTypeFactory custom(final Object dependency) {
        return new FieldTypeFactory(){

            @Override
            public <VALUE> FieldType<VALUE> create(Field<VALUE> field, String key, Supplier<String> labelProvider) {
                if (dependency == null) {
                    return field.createFieldType();
                }
                return field.createFieldType(dependency);
            }
        };
    }

    public FieldTypeFactory withSearchPrio(int prio) {
        this.searchPrio = prio;
        return this;
    }

    public FieldTypeFactory withoutSearchTag() {
        this.skipSearchtag = true;
        return this;
    }

    public FieldTypeFactory withSearchDataType(SearchDataType type) {
        this.searchDataType = type;
        return this;
    }

    public FieldTypeFactory withTokenizer(SearchTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public FieldTypeFactory withNullSupported(boolean nullSupported) {
        this.supportsNull = nullSupported;
        return this;
    }

    public FieldTypeFactory withShowInTextSearch(boolean showInTextSearch) {
        this.showInTextSearchStrategy = () -> showInTextSearch;
        return this;
    }

    public FieldTypeFactory withShowInTextSearch(BooleanSupplier methodImpl) {
        this.showInTextSearchStrategy = methodImpl;
        return this;
    }

    public FieldTypeFactory withIsInTextSearchEnabled(BooleanSupplier methodImpl) {
        this.isInTextSearchEnabledStrategy = methodImpl;
        return this;
    }

    public boolean hasIsInTextSearchEnabledStrategy() {
        return this.isInTextSearchEnabledStrategy != null;
    }

    public SearchTag applyConfiguredChangesToSearchTag(final SearchTag defaultSearchtag) {
        if (this.searchPrio != null || this.searchDataType != null || this.tokenizer != null || this.supportsNull != null || this.showInTextSearchStrategy != null || this.isInTextSearchEnabledStrategy != null) {
            return new SearchTag(defaultSearchtag.getTag(), this.searchDataType == null ? defaultSearchtag.getDataType() : this.searchDataType, this.supportsNull == null ? defaultSearchtag.supportsNullValues() : this.supportsNull.booleanValue(), this.tokenizer == null ? defaultSearchtag.getTokenizer() : this.tokenizer, this.searchPrio == null ? defaultSearchtag.getPriority() : this.searchPrio.intValue(), () -> defaultSearchtag.getDisplayName(), false){

                @Override
                public boolean isSuggestedTag() {
                    if (FieldTypeFactory.this.showInTextSearchStrategy == null) {
                        return defaultSearchtag.isSuggestedTag() && this.isTextSearchEnabled();
                    }
                    return FieldTypeFactory.this.showInTextSearchStrategy.getAsBoolean() && this.isTextSearchEnabled();
                }

                @Override
                public boolean isTextSearchEnabled() {
                    if (FieldTypeFactory.this.isInTextSearchEnabledStrategy == null) {
                        return defaultSearchtag.isTextSearchEnabled();
                    }
                    return FieldTypeFactory.this.isInTextSearchEnabledStrategy.getAsBoolean();
                }

                @Override
                @Nonnull
                public Map<? extends Comparable<?>, String> getMapData() {
                    return defaultSearchtag.getMapData();
                }

                @Override
                @Nonnull
                public String getDisplayValue(Object value) {
                    return defaultSearchtag.getDisplayValue(value);
                }

                @Override
                public int getPriority() {
                    if (FieldTypeFactory.this.searchPrio != null) {
                        return FieldTypeFactory.this.searchPrio;
                    }
                    return defaultSearchtag.getPriority();
                }

                @Override
                public boolean isPhraseContainsIn(@Nonnull String normalizePhrase, @Nullable Object val) {
                    return defaultSearchtag.isPhraseContainsIn(normalizePhrase, val);
                }

                @Override
                public boolean showAlsoNonMapValues() {
                    return defaultSearchtag.showAlsoNonMapValues();
                }

                @Override
                public boolean useDisplaynamesForComparisonSign() {
                    return defaultSearchtag.useDisplaynamesForComparisonSign();
                }
            };
        }
        return defaultSearchtag;
    }
}

