/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.provider;

import com.inet.config.ConfigKey;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConditionGenerator {
    @Nonnull
    public ConditionBuilderEmpty createCondition() {
        return new ConditionBuilderEmpty();
    }

    @Nonnull
    public ConfigCondition alwaysFalse() {
        return ConfigCondition.FALSE;
    }

    @Nonnull
    public ConfigCondition alwaysTrue() {
        return ConfigCondition.TRUE;
    }

    public ConfigConditionAction conditionActionFor(@Nonnull ConfigCondition c2, @Nonnull ConfigKey propKey, @Nonnull ConfigConditionAction.Action a2, String value) {
        return this.conditionActionFor(c2, propKey.getKey(), a2, value);
    }

    public ConfigConditionAction conditionActionFor(@Nonnull ConfigCondition c2, @Nonnull String propKey, @Nonnull ConfigConditionAction.Action a2, String value) {
        if (c2 == null || propKey == null || a2 == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        return new ConfigConditionAction(a2, propKey, c2, value);
    }

    public ConfigConditionAction enableActionFor(@Nonnull ConfigCondition c2, @Nonnull ConfigKey propKey) {
        return this.conditionActionFor(c2, propKey, ConfigConditionAction.Action.Enable, null);
    }

    public ConfigConditionAction enableActionFor(@Nonnull ConfigCondition c2, @Nonnull String propKey) {
        return this.conditionActionFor(c2, propKey, ConfigConditionAction.Action.Enable, null);
    }

    public ConfigConditionAction visibleActionFor(@Nonnull ConfigCondition c2, @Nonnull ConfigKey propKey) {
        return this.conditionActionFor(c2, propKey, ConfigConditionAction.Action.Visible, null);
    }

    public ConfigConditionAction visibleActionFor(@Nonnull ConfigCondition c2, @Nonnull String propKey) {
        return this.conditionActionFor(c2, propKey, ConfigConditionAction.Action.Visible, null);
    }

    public ConfigConditionAction setValueActionFor(@Nonnull ConfigCondition c2, @Nonnull ConfigKey propKey, String value) {
        return this.conditionActionFor(c2, propKey, ConfigConditionAction.Action.SetValue, value);
    }

    public ConfigConditionAction setValueActionFor(@Nonnull ConfigCondition c2, @Nonnull String propKey, String value) {
        return this.conditionActionFor(c2, propKey, ConfigConditionAction.Action.SetValue, value);
    }

    public static class ConditionBuilderEmpty {
        @Nonnull
        public ConditionBuilderLeft property(String key) {
            if (key == null) {
                throw new IllegalArgumentException("null not allowed");
            }
            return new ConditionBuilderLeft(key);
        }

        @Nonnull
        public ConditionBuilderLeft property(ConfigKey key) {
            if (key == null) {
                throw new IllegalArgumentException("null not allowed");
            }
            return this.property(key.getKey());
        }

        @Nonnull
        public ConfigCondition and(ConfigCondition ... args) {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("must contain at least one element");
            }
            if (args.length == 1) {
                return args[0];
            }
            return new ConfigCondition(ConfigCondition.Operation.And, args);
        }

        @Nonnull
        public ConfigCondition not(@Nonnull ConfigCondition c2) {
            if (c2 == null) {
                throw new IllegalArgumentException("null not allowed");
            }
            return new ConfigCondition(ConfigCondition.Operation.Not, c2);
        }

        @Nonnull
        public ConfigCondition or(ConfigCondition ... args) {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("must contain at least one element");
            }
            if (args.length == 1) {
                return args[0];
            }
            return new ConfigCondition(ConfigCondition.Operation.Or, args);
        }
    }

    public static class ConditionBuilderNeedsRight {
        private ConfigCondition.Operation a;
        private String b;

        private ConditionBuilderNeedsRight(String key, ConfigCondition.Operation op) {
            this.b = key;
            this.a = op;
        }

        @Nonnull
        public ConfigCondition value(@Nullable Object value) {
            if (!(value instanceof String)) {
                value = String.valueOf(value);
            }
            return new ConfigCondition(this.a, this.b, value);
        }
    }

    public static class ConditionBuilderLeft {
        private String a;

        private ConditionBuilderLeft(String key) {
            this.a = key;
        }

        @Nonnull
        public ConditionBuilderNeedsRight equals() {
            return new ConditionBuilderNeedsRight(this.a, ConfigCondition.Operation.Equals);
        }

        @Nonnull
        public ConditionBuilderNeedsRight contains() {
            return new ConditionBuilderNeedsRight(this.a, ConfigCondition.Operation.Contains);
        }

        @Nonnull
        public ConditionBuilderNeedsRight isIn() {
            return new ConditionBuilderNeedsRight(this.a, ConfigCondition.Operation.IsIn);
        }

        @Nonnull
        public ConditionBuilderNeedsRight gt() {
            return new ConditionBuilderNeedsRight(this.a, ConfigCondition.Operation.GT);
        }

        @Nonnull
        public ConditionBuilderNeedsRight lt() {
            return new ConditionBuilderNeedsRight(this.a, ConfigCondition.Operation.LT);
        }
    }
}

