/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.model;

import com.inet.annotations.JsonData;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonData
public class ConfigCondition {
    @Nonnull
    public static final ConfigCondition TRUE = new ConfigCondition(Operation.True, new Object[0]);
    @Nonnull
    public static final ConfigCondition FALSE = new ConfigCondition(Operation.False, new Object[0]);
    private Operation op;
    private Object[] params;

    public ConfigCondition(Operation operation, Object ... params) {
        this.op = operation;
        this.params = params;
    }

    public ConfigCondition(Operation operation, List params) {
        this.op = operation;
        this.params = params.toArray();
    }

    public Operation getOp() {
        return this.op;
    }

    public Object[] getParams() {
        return this.params;
    }

    public ConfigCondition and(ConfigCondition c2) {
        Objects.requireNonNull(c2);
        return new ConfigCondition(Operation.And, this, c2);
    }

    public ConfigCondition or(ConfigCondition c2) {
        Objects.requireNonNull(c2);
        return new ConfigCondition(Operation.Or, this, c2);
    }

    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation Equals = new Operation();
        public static final /* enum */ Operation Contains = new Operation();
        public static final /* enum */ Operation GT = new Operation();
        public static final /* enum */ Operation LT = new Operation();
        public static final /* enum */ Operation Or = new Operation();
        public static final /* enum */ Operation And = new Operation();
        public static final /* enum */ Operation Not = new Operation();
        public static final /* enum */ Operation True = new Operation();
        public static final /* enum */ Operation False = new Operation();
        public static final /* enum */ Operation IsIn = new Operation();
        private static final /* synthetic */ Operation[] a;

        public static Operation[] values() {
            return (Operation[])a.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        private static /* synthetic */ Operation[] a() {
            return new Operation[]{Equals, Contains, GT, LT, Or, And, Not, True, False, IsIn};
        }

        static {
            a = Operation.a();
        }
    }
}

