/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationChangeEvent;
import com.inet.config.ConfigurationChangeListener;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.config.ConfigurationModificationEvent;
import com.inet.config.ConfigurationUtils;
import com.inet.config.PreferencesProvider;
import com.inet.config.TempConfiguration;
import com.inet.config.a;
import com.inet.config.b;
import com.inet.config.c;
import com.inet.config.migrator.GPTToAIPluginIdMigrator;
import com.inet.config.migrator.SchedulerConfigurationMigrator;
import com.inet.error.ErrorCode;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.SystemEventLog;
import com.inet.persistence.Persistence;
import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public abstract class ConfigurationManagerImplBase
extends ConfigurationManager {
    public static final int MAX_LENGTH_OF_TRIMMED_CONFIGURATION_NAME = 500;
    private Map<String, Configuration> a = new ConcurrentHashMap<String, Configuration>();
    protected Configuration currentConfig;
    private final List<ConfigurationChangeListener> b = new CopyOnWriteArrayList<ConfigurationChangeListener>();
    private boolean c;
    private final PreferencesProvider d;
    private List<ConfigurationMigrator> e = new CopyOnWriteArrayList<ConfigurationMigrator>();
    private Map<Configuration, Configuration> f = Collections.synchronizedMap(new WeakHashMap());
    private final String g;

    public ConfigurationManagerImplBase(PreferencesProvider prefProvider, String prefPath) {
        this.d = prefProvider;
        this.g = prefPath;
        this.addConfigurationMigrator(new SchedulerConfigurationMigrator());
        this.addConfigurationMigrator(new GPTToAIPluginIdMigrator());
    }

    private static boolean a(int n2) {
        return (n2 & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(int srcScope, String srcName, int destScope, String destName) throws SecurityException {
        Configuration configuration = this.get(srcScope, srcName);
        if (configuration == null) {
            throw new IllegalArgumentException("trying to copy non-existent configuration");
        }
        Configuration configuration2 = this.get(destScope, destName);
        if (configuration2 != null) {
            throw new IllegalArgumentException("trying to copy to already existing configuration");
        }
        Configuration configuration3 = null;
        this.c = true;
        try {
            configuration3 = this.create(destScope, destName);
            configuration3.putAll(configuration.getProperties());
        }
        finally {
            this.c = false;
        }
        this.fireConfigurationChangeEvent(configuration3, 5);
    }

    @Override
    @Nonnull
    public Configuration create(int scope, String name) throws SecurityException {
        if (!ConfigurationManagerImplBase.isLegalName(name)) {
            throw new IllegalArgumentException("illegal name: " + name);
        }
        Configuration configuration = this.get(scope, name);
        if (configuration != null) {
            throw new IllegalArgumentException("configuration already exists for scope " + scope + " and name " + name);
        }
        a a2 = this.createConfiguration(scope, name);
        ForkJoinPool.commonPool().execute(() -> SystemEventLog.ConfigurationCreated.log(ConfigurationUtils.a(scope, name)));
        this.afterCreate(a2);
        this.a(a2);
        if (scope == 4) {
            this.a.put(name, a2);
        } else {
            this.put(scope, name, a2);
        }
        this.fireConfigurationChangeEvent(a2, 1);
        return a2;
    }

    protected void afterCreate(Configuration configuration) {
    }

    public static boolean isLegalName(String name) {
        return name != null && name.trim().length() > 0 && name.trim().length() <= 500 && name.indexOf(47) == -1;
    }

    @Override
    public void delete(Configuration config) throws SecurityException {
        this.delete(config.getScope(), config.getName());
    }

    @Override
    public void delete(int scope, String name) throws SecurityException {
        this.put(scope, name, null);
    }

    @Override
    public void exportToStream(int srcScope, String srcName, OutputStream out) throws SecurityException, IOException {
        Configuration configuration = this.get(srcScope, srcName);
        configuration.getProperties().store(out, null);
    }

    @Override
    @Nullable
    public Configuration get(int scope, String name) throws SecurityException {
        if (this.currentConfig != null && this.currentConfig.getScope() == scope && this.currentConfig.getName().equals(name)) {
            return this.currentConfig;
        }
        return this.getFromBackingStore(scope, name);
    }

    protected Configuration getFromBackingStore(int scope, String name) throws SecurityException {
        if (scope == 4) {
            return this.a.get(name);
        }
        try {
            Preferences preferences = this.getRootForScope(scope);
            try {
                if (preferences.nodeExists(name)) {
                    a a2 = this.createConfiguration(scope, name);
                    return a2;
                }
                return null;
            }
            catch (BackingStoreException backingStoreException) {
                LogManager.getConfigLogger().error(backingStoreException);
                return null;
            }
        }
        catch (SecurityException securityException) {
            if (this.d.isReadable(scope)) {
                return null;
            }
            throw securityException;
        }
    }

    protected Preferences getRootForScope(int scope) {
        return this.d.getRootForScope(scope);
    }

    @Override
    public Configuration[] getAll(int scope) {
        Preferences preferences;
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        if (scope <= 0 || scope > 7) {
            throw new IllegalArgumentException("illegal scope: " + scope);
        }
        try {
            if (ConfigurationManagerImplBase.a(scope)) {
                preferences = this.getRootForScope(2);
                for (String string : preferences.childrenNames()) {
                    arrayList.add(this.get(2, string));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            LogManager.getConfigLogger().error(backingStoreException);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (ConfigurationManagerImplBase.c(scope)) {
                preferences = this.getRootForScope(1);
                for (String string : preferences.childrenNames()) {
                    arrayList.add(this.get(1, string));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            LogManager.getConfigLogger().error(backingStoreException);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (ConfigurationManagerImplBase.b(scope)) {
            arrayList.addAll(this.a.values());
        }
        return arrayList.toArray(new Configuration[arrayList.size()]);
    }

    @Override
    public InetAddress[] getAvailableIPAddresses() {
        try {
            Object object;
            Object object2;
            Object object3;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
            ArrayList<InetAddress> arrayList3 = new ArrayList<InetAddress>();
            while (enumeration.hasMoreElements()) {
                object3 = enumeration.nextElement();
                object2 = ((NetworkInterface)object3).getInetAddresses();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (((InetAddress)object).isLoopbackAddress()) continue;
                    boolean bl = false;
                    if (object instanceof Inet6Address) {
                        if (((Inet6Address)object).isLinkLocalAddress()) continue;
                        try {
                            object = InetAddress.getByAddress(((InetAddress)object).getAddress());
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue;
                        }
                        bl = true;
                    }
                    if (((NetworkInterface)object3).getDisplayName() != null && ((NetworkInterface)object3).getDisplayName().startsWith("Hyper-V Virtual Ethernet Adapter")) {
                        arrayList2.add((InetAddress)object);
                        continue;
                    }
                    if (!bl) {
                        arrayList.add((InetAddress)object);
                        continue;
                    }
                    arrayList3.add((InetAddress)object);
                }
            }
            arrayList.addAll(arrayList3);
            if (arrayList.isEmpty()) {
                arrayList.addAll(arrayList2);
            }
            if (arrayList.isEmpty()) {
                object3 = LogManager.getConfigLogger();
                object3.error("No IP address found for this system.");
                enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    object3.error("\t" + String.valueOf(object2));
                    object = ((NetworkInterface)object2).getInetAddresses();
                    while (object.hasMoreElements()) {
                        InetAddress inetAddress = (InetAddress)object.nextElement();
                        object3.error("\t\t" + String.valueOf(inetAddress));
                    }
                }
            }
            return arrayList.toArray(new InetAddress[arrayList.size()]);
        }
        catch (SocketException socketException) {
            LogManager.getConfigLogger().error(socketException);
            return new InetAddress[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrent(Configuration config) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (config == null) {
                this.currentConfig = null;
                LogManager.getConfigLogger().debug("setCurrent(null) was called");
                config = this.b();
            }
            this.currentConfig = config;
        }
        this.setCurrentNotify(config);
    }

    public void setCurrentNotify(Configuration config) {
        int n2 = config.getScope();
        String string = config.getName();
        LogManager.getConfigLogger().status("Setting current configuration to: " + ConfigurationManagerImplBase.getScopeName(n2) + "/" + string);
        this.a(config);
        this.fireConfigurationChangeEvent(config, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Configuration getCurrent() {
        Configuration configuration;
        block12: {
            configuration = this.currentConfig;
            try {
                if (configuration != null) break block12;
                boolean bl = false;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    configuration = this.currentConfig;
                    if (configuration == null) {
                        if (!Persistence.isFilePersistence()) {
                            for (int i2 = 0; i2 < 100 && ServerPluginManager.getInstance().getCorePluginId() == null; ++i2) {
                                Thread.sleep(100L);
                            }
                        }
                        LogManager.getConfigLogger().debug("currentConfig was null");
                        configuration = this.b();
                        String string = configuration.get("timestamp");
                        if (string != null) {
                            ((a)configuration).timestamp = Long.parseLong(string);
                        }
                        this.currentConfig = configuration;
                        bl = true;
                    }
                }
                if (bl) {
                    this.setCurrentNotify(configuration);
                }
            }
            catch (Throwable throwable) {
                try {
                    LogManager.getConfigLogger().error(throwable);
                }
                catch (Throwable throwable2) {
                    throwable.printStackTrace(System.err);
                }
                if (configuration != null) break block12;
                ErrorCode.throwAny(throwable);
            }
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Configuration b() {
        Configuration configuration = this.c();
        if (configuration != null) {
            return configuration;
        }
        int n2 = ConfigurationUtils.getDefaultConfigScope(NAME_DEFAULT);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Configuration configuration2 = this.get(n2, NAME_DEFAULT);
            if (configuration2 != null) {
                return configuration2;
            }
            configuration2 = this.get(4, "<temporary default>");
            if (configuration2 != null) {
                return configuration2;
            }
            Logger logger = LogManager.getConfigLogger();
            logger.setLogLevel(3);
            if (this.d.isWriteable(n2)) {
                logger.warn("No '" + NAME_DEFAULT + "' configuration could be found! Creating it now.");
                configuration2 = this.create(n2, NAME_DEFAULT);
            } else {
                logger.warn("No '" + NAME_DEFAULT + "' configuration could be found! Creating a default, temporary(!) configuration called <temporary default>...");
                configuration2 = this.create(4, "<temporary default>");
            }
            return configuration2;
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="No client input is used")
    private Configuration c() {
        Object object;
        Object object2;
        Logger logger;
        String string;
        block23: {
            String string2;
            try {
                string2 = System.getProperty("clearreports.config");
                string = System.getProperty("clearreports.configfile");
            }
            catch (SecurityException securityException) {
                string2 = null;
                string = null;
            }
            logger = LogManager.getConfigLogger();
            if (string2 != null) {
                int n2 = 0;
                object2 = string2.toUpperCase();
                if (((String)object2).startsWith("SYSTEM")) {
                    n2 = 1;
                } else if (((String)object2).startsWith("USER")) {
                    n2 = 2;
                } else if (((String)object2).startsWith("TEMP")) {
                    n2 = 4;
                }
                if (n2 != 0) {
                    int n3 = string2.indexOf(47);
                    if (n3 != -1) {
                        object = string2.substring(n3 + 1).trim();
                        logger.status("setting configuration from system property: " + string2);
                        try {
                            if (ConfigurationManager.isReadable(n2)) {
                                Configuration configuration = this.get(n2, (String)object);
                                if (configuration != null) {
                                    return configuration;
                                }
                                logger.warn("No config could be found at '" + string2 + "'!!!");
                                if (ConfigurationManager.isWriteable(n2)) {
                                    logger.info("Create the configuration '" + string2 + "'!!!");
                                    return this.create(n2, (String)object);
                                }
                                logger.warn("The scope '" + ConfigurationManagerImplBase.getScopeName(n2) + "' is not writable!!!");
                                break block23;
                            }
                            logger.error("The scope '" + ConfigurationManagerImplBase.getScopeName(n2) + "' not readable!!!");
                        }
                        catch (SecurityException securityException) {
                            logger.error("encountered SecurityException while trying to access " + string2 + "!");
                            logger.error(securityException);
                        }
                    } else {
                        logger.error("no slash found in '" + string2 + "' - ClearReports.config should have a form such as 'USER/myconfig'");
                    }
                } else {
                    logger.error("scope could not be parsed from '" + string2 + "' - ClearReports.config should start with 'SYSTEM' or 'USER', e.g. 'USER/myconfig'");
                }
            }
        }
        if (string != null) {
            URL uRL = IOFunctions.getURLFromString(string);
            if (uRL != null) {
                try {
                    logger.status("manually importing " + string + " and using as configuration...");
                    object2 = uRL.openStream();
                    String string3 = "<imported config>";
                    this.importFromStream(4, "<imported config>", (InputStream)object2);
                    object = (a)this.get(4, "<imported config>");
                    return object;
                }
                catch (IOException iOException) {
                    LogManager.getConfigLogger().error(iOException);
                }
                catch (SecurityException securityException) {
                    LogManager.getConfigLogger().error(securityException);
                }
            } else {
                LogManager.getConfigLogger().error("could not find properties file at location given: " + string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importFromStream(int destScope, String destName, InputStream in) throws SecurityException, IOException {
        Properties properties = new Properties();
        properties.load(in);
        for (String string : properties.stringPropertyNames()) {
            if (!string.contains("/")) continue;
            properties.remove(string);
        }
        this.c = true;
        Object object = null;
        try {
            object = this.createConfiguration(destScope, destName);
            object.putAll(properties);
            this.a((Configuration)object);
            this.put(destScope, destName, (Configuration)object);
        }
        finally {
            this.c = false;
        }
        this.fireConfigurationChangeEvent((Configuration)object, 4);
    }

    @Override
    public void put(int scope, String name, Configuration source) throws SecurityException {
        Object object;
        Object object2;
        if (source != null) {
            source.put("timestamp", String.valueOf(((a)source).timestamp));
        }
        if (scope == 4) {
            if (source == null) {
                object2 = this.a.remove(name);
                this.f.remove(object2);
            } else {
                if (!(source instanceof TempConfiguration) || !name.equals(source.getName())) {
                    object = new TempConfiguration(name);
                    ((TempConfiguration)object).putAll(source.getProperties());
                    source = object;
                }
                this.a.put(name, (Configuration)source);
                object2 = source;
            }
        } else {
            object2 = this.get(scope, name);
            try {
                object = this.getRootForScope(scope);
                if (source != null) {
                    Properties properties = source.getProperties();
                    if (((Preferences)object).nodeExists(name)) {
                        ((Preferences)object).node(name).clear();
                    }
                    Preferences preferences = ((Preferences)object).node(name);
                    this.replacePreferences(preferences, properties);
                } else {
                    if (((Preferences)object).nodeExists(name)) {
                        ((Preferences)object).node(name).removeNode();
                        SystemEventLog.ConfigurationDeleted.log(ConfigurationUtils.a(scope, name));
                    }
                    this.f.remove(object2);
                }
                ((Preferences)object).flush();
            }
            catch (BackingStoreException backingStoreException) {
                LogManager.getConfigLogger().error(backingStoreException);
            }
        }
        if (this.currentConfig != null && this.currentConfig.getName().equals(name) && this.currentConfig.getScope() == scope) {
            if (source != null) {
                this.currentConfig = this.b();
                object = this.currentConfig.get("timestamp");
                if (object != null) {
                    long l2;
                    ((a)this.currentConfig).timestamp = l2 = Long.parseLong((String)object);
                }
            } else {
                this.setCurrent(null);
            }
        }
        if (source == null && object2 != null) {
            this.fireConfigurationChangeEvent((Configuration)object2, 3);
        }
    }

    @Override
    public void rename(int srcScope, String srcName, int destScope, String destName) throws SecurityException {
        this.copy(srcScope, srcName, destScope, destName);
        this.delete(srcScope, srcName);
    }

    @Override
    public Configuration setTemporaryProperties(Properties props) {
        a a2 = this.createConfiguration(4, "<temp copy>");
        this.a.put("<temp copy>", a2);
        a2.putAll(props);
        this.setCurrent(a2);
        return a2;
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    public Configuration setTemporaryPropertiesFromURL(URL propsURL) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = propsURL.openStream();){
            properties.load(inputStream);
        }
        return this.setTemporaryProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected a createConfiguration(int scope, String name) {
        a a2;
        if (scope == 4) {
            a2 = new TempConfiguration(name);
        } else {
            Preferences preferences = this.getRootForScope(scope);
            Object object = this.getClass();
            synchronized (object) {
                preferences = preferences.node(name);
            }
            object = this.createPreferencesAccessor(preferences);
            a2 = new a((b)object, scope, name);
        }
        return a2;
    }

    private void a(Configuration configuration) {
        if (!this.d.isWriteable(configuration.getScope())) {
            return;
        }
        if (configuration.isEmpty()) {
            return;
        }
        for (ConfigurationMigrator configurationMigrator : this.e) {
            configurationMigrator.migrate(configuration);
        }
        this.f.put(configuration, configuration);
    }

    protected b createPreferencesAccessor(Preferences prefs) {
        return new c(prefs);
    }

    protected void replacePreferences(Preferences configNode, Properties properties) throws BackingStoreException {
        configNode.clear();
        b b2 = this.createPreferencesAccessor(configNode);
        for (Object object : properties.keySet()) {
            String string = (String)object;
            b2.b(string, properties.getProperty(string));
        }
        configNode.flush();
    }

    private static boolean b(int n2) {
        return (n2 & 4) != 0;
    }

    private static boolean c(int n2) {
        return (n2 & 1) != 0;
    }

    @Override
    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null is not allowed as a listener");
        }
        if (this.b.contains(listener)) {
            throw new IllegalArgumentException("listener has already been added");
        }
        this.b.add(listener);
    }

    @Override
    public void removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null can not be removed");
        }
        this.b.remove(listener);
    }

    protected void fireConfigurationChangeEvent(Configuration configuration, int eventType) {
        if (this.c) {
            return;
        }
        boolean bl = this.b(configuration);
        ConfigurationChangeEvent configurationChangeEvent = new ConfigurationChangeEvent(configuration, bl, eventType);
        this.a(configurationChangeEvent);
    }

    void a(ConfigurationChangeEvent configurationChangeEvent) {
        ConfigurationChangeListener[] configurationChangeListenerArray;
        RuntimeException runtimeException = null;
        for (ConfigurationChangeListener configurationChangeListener : configurationChangeListenerArray = this.b.toArray(new ConfigurationChangeListener[0])) {
            try {
                configurationChangeListener.configurationChanged(configurationChangeEvent);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) {
                    runtimeException = runtimeException2;
                } else {
                    runtimeException.addSuppressed(runtimeException2);
                }
                LogManager.getConfigLogger().error(runtimeException2);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    void a(Configuration configuration, List<String> list, boolean bl) {
        if (this.c) {
            return;
        }
        boolean bl2 = this.b(configuration);
        ConfigurationModificationEvent configurationModificationEvent = new ConfigurationModificationEvent(configuration, bl2, list);
        this.a(configurationModificationEvent);
        if (bl && bl2 && configuration.getScope() != 4) {
            List<String> list2 = list.size() == 1 ? "\"" + list.get(0) + "\"" : list;
            SystemEventLog.ConfigurationChanged.log(list2);
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    Thread.sleep(100L);
                    configuration.flush();
                }
                catch (Exception exception) {
                    LogManager.getConfigLogger().error(exception);
                }
            });
        }
    }

    private boolean b(Configuration configuration) {
        boolean bl;
        boolean bl2 = bl = this.currentConfig != null && this.currentConfig.getScope() == configuration.getScope() && this.currentConfig.getName().equals(configuration.getName());
        if (configuration.getScope() == 4) {
            bl &= configuration == this.currentConfig;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigurationMigrator(ConfigurationMigrator migrator) {
        if (migrator == null) {
            throw new IllegalArgumentException("null is not allowed as a migrator");
        }
        this.e.add(migrator);
        Configuration[] configurationArray = this.f;
        synchronized (this.f) {
            Configuration[] configurationArray2 = this.f.keySet().toArray(new Configuration[this.f.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Configuration configuration : configurationArray2) {
                if (configuration == null) continue;
                migrator.migrate(configuration);
            }
            return;
        }
    }

    @Override
    public void removeConfigurationMigrator(ConfigurationMigrator migrator) {
        this.e.remove(migrator);
    }

    @Override
    public void stopImpl() {
    }
}

