/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader.translations;

import com.inet.cache.MemoryStoreMap;
import com.inet.classloader.LoaderUtils;
import com.inet.classloader.translations.BundleKey;
import com.inet.classloader.translations.ResourceManager;
import com.inet.classloader.translations.ResourceTools;
import com.inet.classloader.translations.TranslationKey;
import com.inet.error.ErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class TranslationSearchIndex {
    private static final String LABEL = "label";
    private static final String PLUGIN = "plugin";
    private static final String BUNDLE = "bundle";
    private static final String LANGUAGE = "language";
    private static final String KEY = "key";
    private static final MemoryStoreMap<Object, Object> a = new MemoryStoreMap(900, true);
    private final IndexSearchEngine<TranslationKey> b;
    @Nonnull
    private final c c;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TranslationSearchIndex getInstance() {
        TranslationSearchIndex translationSearchIndex = (TranslationSearchIndex)a.get(TranslationSearchIndex.class);
        if (translationSearchIndex != null) return translationSearchIndex;
        Class<TranslationSearchIndex> clazz = TranslationSearchIndex.class;
        synchronized (TranslationSearchIndex.class) {
            translationSearchIndex = (TranslationSearchIndex)a.get(TranslationSearchIndex.class);
            if (translationSearchIndex != null) return translationSearchIndex;
            translationSearchIndex = new TranslationSearchIndex();
            a.put(TranslationSearchIndex.class, translationSearchIndex);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return translationSearchIndex;
        }
    }

    private TranslationSearchIndex() {
        ResourceManager.a.debug("Create Label Index");
        this.b = new IndexSearchEngine<TranslationKey>(null, null, false, TranslationKey.class, false);
        this.c = new c();
        try {
            this.b.addTag(new SearchTag(LABEL, new com.inet.classloader.translations.a(), 100, () -> LABEL));
            this.b.addTag(new b());
            this.b.addTag(new SearchTag(BUNDLE, 0, () -> BUNDLE));
            this.b.addTag(new a());
            this.b.addTag(new SearchTag(KEY, 50, () -> KEY));
            this.b.setData(this.c, 4);
            ResourceManager.a.debug("Label Index finish");
        }
        catch (IOException iOException) {
            ErrorCode.throwAny(iOException);
        }
    }

    @Nonnull
    public List<SuggestedValue> getSuggestedTags(String phrase) {
        return this.b.getSuggestedValues(phrase, null);
    }

    @Nonnull
    public Set<TranslationKey> search(String searchPhrase) {
        TextSearchCommandBuilder textSearchCommandBuilder = new TextSearchCommandBuilder(this.b, searchPhrase);
        SearchCommand searchCommand = textSearchCommandBuilder.build();
        return this.b.simpleSearch(searchCommand);
    }

    @Nonnull
    c a() {
        return this.c;
    }

    static void b() {
        a.remove(TranslationSearchIndex.class);
    }

    static void a(@Nonnull Map<TranslationKey, String> map) {
        for (TranslationKey translationKey : map.keySet()) {
            a.remove(TranslationSearchIndex.a(translationKey));
        }
    }

    static void a(String string, String string2) {
        String string3 = TranslationSearchIndex.c(string, string2);
        a.remove(string3);
    }

    @Nonnull
    private static String c(String string, String string2) {
        return "Languages|" + string + "|" + string2;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Required language resources are read from the given plugin only. It is checked, that the plugin is actually available")
    static Set<String> b(String string, String string2) {
        String string3 = TranslationSearchIndex.c(string, string2);
        HashSet<String> hashSet = (HashSet<String>)a.get(string3);
        if (hashSet == null) {
            ServerPlugin serverPlugin;
            hashSet = new HashSet<String>();
            String string4 = string2.replace(".", "/");
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            ServerPluginDescription serverPluginDescription = serverPluginManager.getPluginDescription(string);
            ServerPlugin serverPlugin2 = serverPlugin = serverPluginDescription != null ? serverPluginDescription.getServerPlugin() : null;
            if (serverPlugin != null) {
                Object object;
                try {
                    object = serverPlugin.getClass().getProtectionDomain().getCodeSource().getLocation().openStream();
                    try {
                        TranslationSearchIndex.a(hashSet, (InputStream)object, string4);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                catch (Exception exception) {
                    ResourceManager.a.debug("AvaialableLanguage for: " + string);
                    ResourceManager.a.error(exception);
                }
                object = ResourceTools.getResourceZip(string);
                if (((File)object).isFile()) {
                    try (FileInputStream fileInputStream = new FileInputStream((File)object);){
                        TranslationSearchIndex.a(hashSet, fileInputStream, string4);
                    }
                    catch (Exception exception) {
                        ResourceManager.a.error(exception);
                    }
                }
            } else {
                ResourceManager.a.warn("Ignore not loaded plugin: " + string + " with bundle " + string2);
            }
            a.put(string3, hashSet);
        }
        return hashSet;
    }

    private static void a(Set<String> set, InputStream inputStream, String string) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (!string2.startsWith(string) || !string2.endsWith(".properties")) continue;
            set.add(ResourceTools.extractLocale(string2));
        }
    }

    static String a(BundleKey bundleKey) {
        return bundleKey.pluginId + "|" + bundleKey.bundleName + "|" + bundleKey.language;
    }

    static class c
    extends AbstractSearchDataCache<TranslationKey> {
        c() {
        }

        public Map<String, Object> a(TranslationKey translationKey) {
            String string = TranslationSearchIndex.a(translationKey);
            Properties properties = (Properties)a.get(string);
            if (properties == null) {
                properties = new Properties();
                try {
                    ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
                    ClassLoader classLoader = serverPluginManager.getPluginDescription(translationKey.pluginId).getClassLoader();
                    URL uRL = classLoader.getResource(translationKey.getResourceFilename());
                    try (InputStream inputStream = uRL.openStream();){
                        properties.load(inputStream);
                    }
                }
                catch (Exception exception) {
                    ResourceManager.a.error(exception);
                }
                a.put(string, properties);
            }
            return this.a(translationKey, properties.get(translationKey.key));
        }

        private Map<String, Object> a(TranslationKey translationKey, Object object) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TranslationSearchIndex.LABEL, object);
            hashMap.put(TranslationSearchIndex.PLUGIN, translationKey.pluginId);
            hashMap.put(TranslationSearchIndex.BUNDLE, translationKey.bundleName);
            hashMap.put(TranslationSearchIndex.LANGUAGE, translationKey.language);
            hashMap.put(TranslationSearchIndex.KEY, translationKey.key);
            return hashMap;
        }

        @Override
        public Iterator<TranslationKey> iterator() {
            ArrayList<TranslationKey> arrayList = new ArrayList<TranslationKey>();
            Locale locale = Locale.ROOT;
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            for (Map.Entry<String, Set<String>> entry : LoaderUtils.getLoadedBundles().entrySet()) {
                String string = entry.getKey();
                ServerPluginDescription serverPluginDescription = serverPluginManager.getPluginDescription(string);
                if (serverPluginDescription == null) {
                    ResourceManager.a.warn("Ignore not loaded plugin: " + string + " with bundles " + String.valueOf(entry));
                    continue;
                }
                ClassLoader classLoader = serverPluginDescription.getClassLoader();
                for (String string2 : entry.getValue()) {
                    try {
                        ResourceBundle resourceBundle = LoaderUtils.getBundle(string2, locale, classLoader);
                        Set<String> set = TranslationSearchIndex.b(string, string2);
                        Enumeration<String> enumeration = resourceBundle.getKeys();
                        while (enumeration.hasMoreElements()) {
                            String string3 = enumeration.nextElement();
                            for (String string4 : set) {
                                arrayList.add(new TranslationKey(string, string2, string4, string3));
                            }
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        ResourceManager.a.error(missingResourceException);
                    }
                }
            }
            return arrayList.iterator();
        }

        void a(TranslationKey translationKey, String string, String string2) {
            Map<String, Object> map = this.a(translationKey, string);
            Map<String, Object> map2 = this.a(translationKey, string2);
            for (SearchDataCacheChangeListener<TranslationKey> searchDataCacheChangeListener : this.getListeners()) {
                if (StringFunctions.isEmpty(string)) {
                    searchDataCacheChangeListener.entryAdded(translationKey, map2);
                    continue;
                }
                if (StringFunctions.isEmpty(string2)) {
                    searchDataCacheChangeListener.entryRemoved(translationKey, map);
                    continue;
                }
                searchDataCacheChangeListener.entryChanged(translationKey, map, map2);
            }
        }

        @Override
        public /* synthetic */ Map getCacheEntry(Object object) {
            return this.a((TranslationKey)object);
        }
    }

    private static class b
    extends SearchTag {
        public b() {
            super(TranslationSearchIndex.PLUGIN, SearchDataType.StringMap, false, TextSearchTokenizer.DEFAULT, 0, () -> TranslationSearchIndex.PLUGIN, true);
        }

        @Override
        public Map<? extends Comparable<?>, String> getMapData() {
            Locale locale = ClientLocale.getThreadLocale();
            String string = "PluginMap|" + String.valueOf(locale);
            HashMap<String, String> hashMap = (HashMap<String, String>)a.get(string);
            if (hashMap == null) {
                String[] stringArray;
                hashMap = new HashMap<String, String>();
                for (String string2 : stringArray = ServerPluginManager.getInstance().getLoadedPlugins()) {
                    ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().getPluginDescription(string2);
                    if (serverPluginDescription == null) continue;
                    String string3 = serverPluginDescription.getDisplayName("id", locale);
                    hashMap.put(string2, string3);
                }
                a.put(string, hashMap);
            }
            return hashMap;
        }
    }

    private static class a
    extends SearchTag {
        public a() {
            super(TranslationSearchIndex.LANGUAGE, SearchDataType.StringMap, false, TextSearchTokenizer.DEFAULT, 0, () -> TranslationSearchIndex.LANGUAGE, true);
        }

        @Override
        public Map<? extends Comparable<?>, String> getMapData() {
            Locale locale = ClientLocale.getThreadLocale();
            String string = "LanguageMap|" + String.valueOf(locale);
            HashMap<String, String> hashMap = (HashMap<String, String>)a.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                for (Map.Entry<String, Set<String>> entry : LoaderUtils.getLoadedBundles().entrySet()) {
                    String string2 = entry.getKey();
                    for (String string3 : entry.getValue()) {
                        Set<String> set = TranslationSearchIndex.b(string2, string3);
                        for (String string4 : set) {
                            if (hashMap.containsKey(string4)) continue;
                            Locale locale2 = LocaleUtils.valueOf(string4);
                            String string5 = locale2.getDisplayName(locale);
                            hashMap.put(string4, string5);
                        }
                    }
                }
                a.put(string, hashMap);
            }
            return hashMap;
        }
    }
}

