/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user.persistence;

import com.inet.error.PersistenceException;
import com.inet.id.GUID;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FileSystemPersistenceDirectoryStructure;
import com.inet.usersandgroups.api.FileSystemPersistenceHelper;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.user.persistence.UserPersistenceUnit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class FileSystemUserPersistence
implements UserPersistence {
    private final FileSystemPersistenceDirectoryStructure a;
    private final PersistenceEntry b;

    public FileSystemUserPersistence(@Nonnull Persistence persistence) {
        this(persistence.resolve("usersandgroups/users"));
    }

    public FileSystemUserPersistence(@Nonnull PersistenceEntry usersDir) {
        this.b = usersDir;
        this.a = new FileSystemPersistenceDirectoryStructure(usersDir);
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserAccount saveNew(GUID accountID, UserAccountType accountType, long lastModified, long lastAccess, boolean active, MutableUserData userData) {
        try {
            if (!FileSystemPersistenceHelper.isMaintenanceMode()) {
                byte[] byArray = FileSystemUserPersistence.a(accountType, lastModified, lastAccess, active, userData, Collections.emptyList(), Collections.emptySet());
                PersistenceEntry persistenceEntry = this.a.getJsonDataFile(accountID);
                try (ThreadUtils.Semaphore semaphore = FileSystemUserPersistence.b(persistenceEntry);){
                    ThreadUtils.Semaphore semaphore2 = semaphore;
                    synchronized (semaphore2) {
                        persistenceEntry.setBytes(byArray);
                    }
                }
            }
            return UserAccount.create(accountID, accountType, lastModified, lastAccess, userData, Collections.emptyList(), Collections.emptySet(), active);
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    private static byte[] a(UserAccountType userAccountType, long l2, long l3, boolean bl, MutableUserData mutableUserData, List<LoginSettings> list, Set<String> set) {
        try {
            Set<UserField<Object>> set2 = mutableUserData.getIncludedFields();
            HashMap<String, String> hashMap = new HashMap<String, String>(set2.size());
            for (UserField<Object> userField : set2) {
                Object object = mutableUserData.get(userField);
                if (object == null && userField.getDefaultValue() == null) continue;
                String string = object == null ? null : new Json().toJson(object);
                hashMap.put(userField.getKey(), string);
            }
            UserPersistenceUnit userPersistenceUnit = new UserPersistenceUnit(userAccountType, l2, l3, bl, hashMap, list, set);
            return FileSystemPersistenceHelper.toEncodedJsonized(userPersistenceUnit);
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public UserAccount updateData(GUID accountID, long lastModified, MutableUserData userData) {
        return this.a(accountID, (UserPersistenceUnit userPersistenceUnit) -> {
            HashMap<String, String> hashMap = userPersistenceUnit.getFields();
            for (UserField<Object> userField : userData.getIncludedFields()) {
                Object object = userData.get(userField);
                if (object == null && userField.getDefaultValue() == null) {
                    hashMap.remove(userField.getKey());
                    continue;
                }
                String string = object == null ? null : new Json().toJson(object);
                hashMap.put(userField.getKey(), string);
            }
            return new UserPersistenceUnit(userPersistenceUnit.getAccountType(), lastModified, userPersistenceUnit.getLastAccess(), userPersistenceUnit.isActive(), hashMap, userPersistenceUnit.getLoginSettings(), userPersistenceUnit.getPermissions());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(GUID accountID, List<UserField<?>> fields) {
        if (FileSystemPersistenceHelper.isMaintenanceMode()) {
            return;
        }
        PersistenceEntry persistenceEntry = this.a.getJsonDataFile(accountID);
        try (ThreadUtils.Semaphore semaphore = FileSystemUserPersistence.b(persistenceEntry);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                HashMap<String, String> hashMap;
                UserPersistenceUnit userPersistenceUnit;
                block15: {
                    userPersistenceUnit = this.a(persistenceEntry);
                    hashMap = userPersistenceUnit.getFields();
                    int n2 = hashMap.size();
                    for (UserField<?> object2 : fields) {
                        hashMap.remove(object2.getKey());
                    }
                    if (n2 != hashMap.size()) break block15;
                    return;
                }
                UserPersistenceUnit userPersistenceUnit2 = new UserPersistenceUnit(userPersistenceUnit.getAccountType(), userPersistenceUnit.getLastModified(), userPersistenceUnit.getLastAccess(), userPersistenceUnit.isActive(), hashMap, userPersistenceUnit.getLoginSettings(), userPersistenceUnit.getPermissions());
                byte[] byArray = FileSystemPersistenceHelper.toEncodedJsonized(userPersistenceUnit2);
                persistenceEntry.setBytes(byArray);
            }
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public UserAccount updateLoginSettings(GUID accountID, long lastModified, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove) {
        return this.a(accountID, (UserPersistenceUnit userPersistenceUnit) -> {
            List<LoginSettings> list3 = UserPersistenceUnit.updateLoginSettings(userPersistenceUnit.getLoginSettings(), settingsToAdd, settingsToRemove);
            return new UserPersistenceUnit(userPersistenceUnit.getAccountType(), lastModified, userPersistenceUnit.getLastAccess(), userPersistenceUnit.isActive(), userPersistenceUnit.getFields(), list3, userPersistenceUnit.getPermissions());
        });
    }

    @Override
    public UserAccount updatePermissions(GUID accountID, long lastModified, Set<String> permissionsToAdd, Set<String> permissionsToRemove) {
        return this.a(accountID, (UserPersistenceUnit userPersistenceUnit) -> {
            HashSet<String> hashSet = new HashSet<String>(userPersistenceUnit.getPermissions());
            hashSet.addAll(permissionsToAdd);
            hashSet.removeAll(permissionsToRemove);
            return new UserPersistenceUnit(userPersistenceUnit.getAccountType(), lastModified, userPersistenceUnit.getLastAccess(), userPersistenceUnit.isActive(), userPersistenceUnit.getFields(), userPersistenceUnit.getLoginSettings(), hashSet);
        });
    }

    @Override
    public UserAccount setAccountActive(GUID userID, long lastModified, boolean active) {
        return this.a(userID, (UserPersistenceUnit userPersistenceUnit) -> new UserPersistenceUnit(userPersistenceUnit.getAccountType(), lastModified, userPersistenceUnit.getLastAccess(), active, userPersistenceUnit.getFields(), userPersistenceUnit.getLoginSettings(), userPersistenceUnit.getPermissions()));
    }

    @Override
    public UserAccount setLastModified(GUID userID, long lastModified) {
        return this.a(userID, (UserPersistenceUnit userPersistenceUnit) -> new UserPersistenceUnit(userPersistenceUnit.getAccountType(), lastModified, userPersistenceUnit.getLastAccess(), userPersistenceUnit.isActive(), userPersistenceUnit.getFields(), userPersistenceUnit.getLoginSettings(), userPersistenceUnit.getPermissions()));
    }

    @Override
    public UserAccount setLastAccess(GUID userID, long lastAccess) {
        return this.a(userID, (UserPersistenceUnit userPersistenceUnit) -> new UserPersistenceUnit(userPersistenceUnit.getAccountType(), userPersistenceUnit.getLastModified(), lastAccess, userPersistenceUnit.isActive(), userPersistenceUnit.getFields(), userPersistenceUnit.getLoginSettings(), userPersistenceUnit.getPermissions()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserAccount a(GUID gUID, Function<UserPersistenceUnit, UserPersistenceUnit> function) {
        PersistenceEntry persistenceEntry = this.a.getJsonDataFile(gUID);
        try (ThreadUtils.Semaphore semaphore = FileSystemUserPersistence.b(persistenceEntry);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                Object object;
                UserPersistenceUnit userPersistenceUnit = this.a(persistenceEntry);
                UserPersistenceUnit userPersistenceUnit2 = function.apply(userPersistenceUnit);
                if (!FileSystemPersistenceHelper.isMaintenanceMode()) {
                    object = FileSystemPersistenceHelper.toEncodedJsonized(userPersistenceUnit2);
                    persistenceEntry.setBytes((byte[])object);
                }
                object = this.a(gUID, UserManager.getAllFields(), userPersistenceUnit2);
                return object;
            }
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    private UserPersistenceUnit a(PersistenceEntry persistenceEntry) throws IOException {
        UserPersistenceUnit userPersistenceUnit;
        EncodedReader encodedReader = new EncodedReader(persistenceEntry.getInputStream());
        try {
            userPersistenceUnit = new Json().fromJson((Reader)encodedReader, UserPersistenceUnit.class, new HashMap<Object, Map<String, String>>());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)encodedReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonException | IOException exception) {
                UsersAndGroups.LOGGER.error("Could not read persisted user data: " + String.valueOf(persistenceEntry));
                UsersAndGroups.LOGGER.error(exception);
                return UserPersistenceUnit.createReplacementForCorruptedData();
            }
        }
        ((Reader)encodedReader).close();
        return userPersistenceUnit;
    }

    @Override
    public void delete(GUID accountID) {
        this.a.getNodeDirectory(accountID).deleteTree();
    }

    @Override
    public void deleteAll() {
        try {
            this.b.deleteTree();
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserAccount load(GUID accountID) {
        PersistenceEntry persistenceEntry = this.a.getJsonDataFile(accountID);
        if (!persistenceEntry.exists()) {
            return null;
        }
        try (ThreadUtils.Semaphore semaphore = FileSystemUserPersistence.b(persistenceEntry);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                UserPersistenceUnit userPersistenceUnit = this.a(persistenceEntry);
                UserAccount userAccount = this.a(accountID, UserManager.getAllFields(), userPersistenceUnit);
                return userAccount;
            }
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public List<UserAccount> load(List<GUID> accountIDs, int limit) {
        ArrayList<UserAccount> arrayList = new ArrayList<UserAccount>();
        for (GUID gUID : accountIDs) {
            if (arrayList.size() == limit) {
                return arrayList;
            }
            UserAccount userAccount = this.load(gUID);
            if (userAccount == null) continue;
            arrayList.add(userAccount);
        }
        return arrayList;
    }

    @Override
    public Iterator<GUID> getUserAccountIdIterator(String key) {
        if (key != null) {
            key = (String)key + ".binary";
        }
        return this.a.getNodeIdIterator((String)key);
    }

    @Override
    public InputStream loadBinaryData(GUID accountID, String key) {
        PersistenceEntry persistenceEntry = this.a(accountID, key);
        if (!persistenceEntry.exists()) {
            return null;
        }
        try {
            return persistenceEntry.getInputStream();
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public void saveBinaryData(GUID accountID, String key, InputStream in, int length) {
        PersistenceEntry persistenceEntry = this.a(accountID, key);
        try {
            if (!FileSystemPersistenceHelper.isMaintenanceMode()) {
                persistenceEntry.setInputStream(in);
            }
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public void deleteBinaryData(GUID accountID, String key) {
        PersistenceEntry persistenceEntry = this.a(accountID, key);
        try {
            if (!FileSystemPersistenceHelper.isMaintenanceMode()) {
                persistenceEntry.deleteValue();
            }
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public boolean hasUserDataFor(GUID accountID) {
        return this.a.getJsonDataFile(accountID).exists();
    }

    private PersistenceEntry a(GUID gUID, String string) {
        return this.a.getNodeDirectory(gUID).resolve(string.toLowerCase() + ".binary");
    }

    private UserAccount a(GUID gUID, List<UserField<Object>> list, UserPersistenceUnit userPersistenceUnit) {
        UserField<Object> userField2;
        HashMap<String, String> hashMap = userPersistenceUnit.getFields();
        HashMap<UserField<Object>, Object> hashMap2 = new HashMap<UserField<Object>, Object>();
        for (UserField<Object> userField2 : list) {
            String string = userField2.getKey();
            if (!hashMap.containsKey(string)) continue;
            String string2 = hashMap.get(string);
            try {
                Object v = string2 == null || string2.equals("null") ? null : (Object)new Json().fromJson(string2, userField2.getGenericType());
                hashMap2.put(userField2, v);
            }
            catch (JsonException jsonException) {
                String string3 = String.format("Could not deserialize value of field \"%s\" defined for user account with ID \"%s\". Default value will be used instead.", string, gUID);
                UsersAndGroups.LOGGER.warn(string3);
                UsersAndGroups.LOGGER.warn(jsonException);
            }
        }
        MutableUserData mutableUserData = MutableUserData.createAndFillWithValidValues(gUID, list, hashMap2);
        userField2 = new HashSet();
        for (String string2 : userPersistenceUnit.getPermissions()) {
            userField2.add(Permission.valueOfExistingOrCreate(string2));
        }
        return UserAccount.create(gUID, userPersistenceUnit.getAccountType(), userPersistenceUnit.getLastModified(), userPersistenceUnit.getLastAccess(), mutableUserData, userPersistenceUnit.getLoginSettings(), (Set<Permission>)((Object)userField2), userPersistenceUnit.isActive());
    }

    @Override
    public long getAccountFileSize(GUID accountId) {
        PersistenceEntry persistenceEntry = this.a.getNodeDirectory(accountId);
        if (!persistenceEntry.exists()) {
            return 0L;
        }
        int n2 = 0;
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.search("*")) {
            n2 = (int)((long)n2 + persistenceEntry2.size());
        }
        return n2;
    }

    @Override
    public Iterator<Map.Entry<String, InputStream>> getBinaryDataIterator(GUID accountID) {
        return this.a.getBinaryDataIterator(accountID);
    }

    @Nonnull
    private static ThreadUtils.Semaphore b(PersistenceEntry persistenceEntry) {
        return ThreadUtils.getSemaphore(persistenceEntry);
    }
}

