/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;

@JsonData
public class LoginSettings {
    private String loginSource;
    private String loginID;
    private String additionalData;
    private String displayName;

    private LoginSettings() {
    }

    public LoginSettings(String loginSource, String loginID, String additionalData) {
        this(loginSource, loginID, additionalData, null);
    }

    public LoginSettings(String loginSource, String loginID, String additionalData, String displayName) {
        LoginSettings.throwIfInvalidLoginSource(loginSource);
        LoginSettings.throwIfInvalidLoginID(loginID);
        this.loginSource = loginSource;
        this.loginID = loginID;
        this.additionalData = additionalData;
        this.displayName = displayName;
    }

    public String getLoginSource() {
        return this.loginSource;
    }

    public String getLoginID() {
        return this.loginID;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public String getDisplayName() {
        return StringFunctions.isEmpty(this.displayName) ? this.loginID : this.displayName;
    }

    public static void throwIfInvalidLoginSource(String loginSource) {
        if (loginSource == null) {
            throw new IllegalArgumentException("login source must not be null");
        }
        if (loginSource.trim().isEmpty()) {
            throw new IllegalArgumentException("login source must not be empty after trim");
        }
    }

    public static void throwIfInvalidLoginID(String loginID) {
        if (loginID == null) {
            throw new IllegalArgumentException("login ID must not be null");
        }
        if (loginID.trim().isEmpty()) {
            throw new IllegalArgumentException("login ID must not be empty after trim");
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.additionalData == null ? 0 : this.additionalData.hashCode());
        n3 = 31 * n3 + (this.loginID == null ? 0 : this.loginID.toLowerCase().hashCode());
        n3 = 31 * n3 + (this.loginSource == null ? 0 : this.loginSource.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoginSettings loginSettings = (LoginSettings)obj;
        if (this.additionalData == null ? loginSettings.additionalData != null : !this.additionalData.equals(loginSettings.additionalData)) {
            return false;
        }
        if (this.loginID == null ? loginSettings.loginID != null : !this.loginID.equalsIgnoreCase(loginSettings.loginID)) {
            return false;
        }
        return !(this.loginSource == null ? loginSettings.loginSource != null : !this.loginSource.equals(loginSettings.loginSource));
    }
}

