/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.LoginRoles;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.stayloggedin.StayLoggedInHandler;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigurationManager;
import com.inet.error.BaseErrorCode;
import com.inet.error.ServiceUnavailableException;
import com.inet.field.Field;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.ConfigViewConfig;
import com.inet.plugin.image.UserAvatar;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.EventDispatcher;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.UsersAndGroupsEventLog;
import com.inet.usersandgroups.UsersAndGroupsEventLogWrapper;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.AuthGroupManager;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.NewUserAccountAvatarInitializer;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserAvatarAutomaticUpdater;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.UserSearchFilter;
import com.inet.usersandgroups.api.user.persistence.UserNodeSynchronizer;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.api.user.persistence.UserPersistenceWithCache;
import com.inet.usersandgroups.api.user.search.UserSearchDataCache;
import com.inet.usersandgroups.api.user.search.UserSearchEngine;
import com.inet.usersandgroups.user.UserDataDifferenceChecker;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class BaseUserManager
extends UserManager
implements LoginListener {
    public static final List<String> RESERVED_FIELD_KEYS = Collections.unmodifiableList(Arrays.asList("useraccountid", "active", "loginsettings", "loginid", "authgroupname", "permissions", "useraccounttype", "lastaccess", "useraccountdisplayname"));
    public static final BinaryDataKey ROLES_KEY = new BinaryDataKey("roles", false);
    private final UserPersistenceWithCache a;
    private final UserPersistence b;
    private final EventDispatcher<UserEventListener> c = new EventDispatcher();
    private final MemoryStoreMap<GUID, Set<String>> d = new MemoryStoreMap(900, true);
    private UserSearchDataCache e;
    private UserSearchEngine f;
    private UserAccount g;
    private UsersAndGroupsEventLogWrapper h = (usersAndGroupsEventLog, gUID, string, objectArray) -> usersAndGroupsEventLog.log(gUID, string, objectArray);
    private CountDownLatch i = new CountDownLatch(1);
    private NewUserAccountAvatarInitializer j = null;
    private UserAvatarAutomaticUpdater k = null;

    public BaseUserManager(UserPersistence persistence, UserSearchEngine searchEngine) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        this.a = new UserPersistenceWithCache(persistence);
        this.b = persistence;
        this.f = searchEngine;
    }

    public void disableLoggingEvents() {
        this.h = (usersAndGroupsEventLog, gUID, string, objectArray) -> {};
    }

    public void init() throws IOException {
        List<UserField> list = DynamicExtensionManager.getInstance().get(UserField.class);
        UsersAndGroups.throwIfRegisteredFieldsHaveNonUniqueKeys(list, UserField.class);
        UsersAndGroups.throwIfKeysOfRegisteredFieldsCollideWithReservedKeys(RESERVED_FIELD_KEYS, list, UserField.class);
        if (this.e != null) {
            throw new IllegalStateException("user manager is already initialized");
        }
        this.a.init();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        this.j = serverPluginManager.getOptionalInstance(NewUserAccountAvatarInitializer.class);
        this.k = serverPluginManager.getOptionalInstance(UserAvatarAutomaticUpdater.class);
        this.e = this.createSearchDataCache(this.b);
        MutableUserData mutableUserData = new MutableUserData();
        BaseUserManager.getAllFields().forEach(userField -> mutableUserData.put(userField, userField.getValueForPrivilegedUser()));
        ConfigViewConfig configViewConfig = new ConfigViewConfig();
        configViewConfig.setAdvanced(true);
        mutableUserData.put(UsersAndGroups.FIELD_FIRSTNAME, "PrivilegedAccount");
        mutableUserData.put(UsersAndGroups.USERFIELD_CONFIG_VIEWCONFIG, new Json().toJson(configViewConfig));
        this.g = UserAccount.createForActiveUser(PRIVILEGED_ACCOUNT_ID, UserAccountType.Administrator, 0L, 0L, mutableUserData, Collections.emptyList(), Collections.emptySet());
        new Thread("User Search Engine Init"){

            @Override
            public void run() {
                AccessController.doPrivileged(() -> {
                    boolean bl;
                    try {
                        BaseUserManager.this.f.init(BaseUserManager.this.a, BaseUserManager.this.e);
                    }
                    catch (Throwable throwable) {
                        LogManager.getApplicationLogger().fatal(throwable);
                    }
                    finally {
                        BaseUserManager.this.i.countDown();
                    }
                    SearchCommand searchCommand = new SearchCommand("useraccountid", SearchCondition.SearchTermOperator.Equals, UserManager.MASTER_ACCOUNT_ID.toString());
                    boolean bl2 = bl = !BaseUserManager.this.f.getSearchEngine().simpleSearch(searchCommand).isEmpty();
                    if (bl) {
                        BaseUserManager.this.e.indexAllPermissionsForMasterUser();
                    }
                    UserNodeSynchronizer userNodeSynchronizer = new UserNodeSynchronizer(BaseUserManager.this.a);
                    BaseUserManager.this.c.registerListener(userNodeSynchronizer);
                    Persistence.getInstance().registerListener(userNodeSynchronizer);
                    return null;
                });
            }
        }.start();
    }

    protected UserSearchDataCache createSearchDataCache(UserPersistence persistence) {
        return new UserSearchDataCache(persistence);
    }

    private UserSearchEngine a() {
        if (this.i.getCount() > 0L) {
            if (ThreadUtils.isGuiThread()) {
                throw new ServiceUnavailableException();
            }
            try {
                this.i.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.f;
    }

    @Override
    public UserAccount createUserAccount(UserAccountType accountType, MutableUserData userData) {
        if (accountType == null) {
            throw new IllegalArgumentException("account type must not be null");
        }
        if (userData == null) {
            throw new IllegalArgumentException("user data must not be null");
        }
        userData = userData.copyWithSpecifiedFieldsOnly(BaseUserManager.getAllFields(), true);
        GUID gUID = UserAccountType.Administrator.equals((Object)accountType) ? (ConfigurationManager.isRecoveryMode() ? RECOVERY_ACCOUNT_ID : MASTER_ACCOUNT_ID) : GUID.generateNew();
        long l2 = 0L;
        UserAccount userAccount = this.a.saveNew(gUID, accountType, System.currentTimeMillis(), l2, true, userData);
        this.e.userCreated(userAccount);
        this.h.log(UsersAndGroupsEventLog.UserCreated, userAccount.getID(), userAccount.getDisplayName(), new Object[0]);
        if (this.j != null) {
            this.j.userAccountCreated(userAccount);
        }
        this.c.dispatchEvent(userEventListener -> {
            try {
                userEventListener.userAccountCreated(userAccount);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        return userAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserData(GUID accountID, MutableUserData userData) {
        UserAccount userAccount;
        UserDataDifferenceChecker.UserDataCheckResult userDataCheckResult;
        UserAccount userAccount2;
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        if (userData == null) {
            throw new IllegalArgumentException("user data must not be null");
        }
        List<UserField<Object>> list = BaseUserManager.getAllFields();
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore object = semaphore;
            synchronized (object) {
                boolean bl;
                block19: {
                    userAccount2 = this.getUserAccount(accountID);
                    BaseUserManager.a(userAccount2, accountID);
                    this.c.dispatchEventAndWait(userEventListener -> userEventListener.userAccountBeforeUpdate(userAccount2));
                    userData = userData.copyWithSpecifiedFieldsOnly(list, false);
                    userDataCheckResult = UserDataDifferenceChecker.check(userAccount2, userData);
                    if (userDataCheckResult != UserDataDifferenceChecker.UserDataCheckResult.NO_DIFFERENCES) break block19;
                    return;
                }
                boolean bl2 = bl = userAccount2.getValue(UserAvatar.FIELD_AVATAR_PROVIDER) != null;
                if (bl) {
                    boolean bl3;
                    boolean bl4 = bl3 = userData.containsField(UserAvatar.FIELD_AVATAR_PROVIDER) && userData.get(UserAvatar.FIELD_AVATAR_PROVIDER) == null;
                    if (!bl3) {
                        boolean bl5;
                        boolean bl6 = bl5 = userData.containsField(UsersAndGroups.FIELD_EMAIL) && EmailAddressHelper.get().getFirstEmailAddress(userData.get(UsersAndGroups.FIELD_EMAIL)) == null;
                        if (bl5) {
                            userData.put(UserAvatar.FIELD_AVATAR_PROVIDER, null);
                            userData.put(UserAvatar.FIELD_AVATAR_METADATA, null);
                        }
                    }
                }
                userAccount = this.a.updateData(accountID, System.currentTimeMillis(), userData);
                if (userDataCheckResult == UserDataDifferenceChecker.UserDataCheckResult.DIFFERENT_INDEXED_DATA) {
                    this.e.userUpdated(userAccount2, userAccount);
                }
            }
        }
        this.c.dispatchEvent(userEventListener -> {
            try {
                userEventListener.userAccountUpdated(userAccount2, userAccount);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        for (UserField userField : list) {
            if (!userData.containsField(userField)) continue;
            userDataCheckResult = userAccount2.getValue(userField);
            Object VALUE = userData.get(userField);
            if (!userField.isValueChangeLoggable() || Objects.equals((Object)userDataCheckResult, VALUE)) continue;
            if (userField.getKey().equals(UsersAndGroups.FIELD_USER_LOCKED.getKey())) {
                if (VALUE != null) {
                    this.h.log(UsersAndGroupsEventLog.UserBlockingNoticeSet, accountID, userAccount.getDisplayName(), VALUE);
                    continue;
                }
                this.h.log(UsersAndGroupsEventLog.UserBlockingNoticeRemoved, accountID, userAccount.getDisplayName(), new Object[0]);
                continue;
            }
            this.h.log(UsersAndGroupsEventLog.UserDataChanged, accountID, userAccount.getDisplayName(), userField.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <VALUE> void updateUserData(GUID accountID, UserField<VALUE> field, Function<VALUE, VALUE> func) {
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                UserAccount userAccount = this.getUserAccount(accountID);
                VALUE VALUE = userAccount.getValue(field);
                VALUE VALUE2 = func.apply(VALUE);
                MutableUserData mutableUserData = new MutableUserData();
                mutableUserData.put(field, VALUE2);
                this.updateUserData(accountID, mutableUserData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLoginSettings(GUID accountID, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove, boolean toEventLog) {
        UserAccount userAccount;
        UserAccount userAccount2;
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        UsersAndGroups.throwIfNullOrContainsNull(settingsToAdd, "list \"settingsToAdd\"");
        UsersAndGroups.throwIfNullOrContainsNull(settingsToRemove, "list \"settingsToRemove\"");
        if (settingsToAdd.isEmpty() && settingsToRemove.isEmpty()) {
            return;
        }
        try (Iterator<LoginSettings> iterator = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore object = iterator;
            synchronized (object) {
                userAccount2 = this.getUserAccount(accountID);
                BaseUserManager.a(userAccount2, accountID);
                this.a(accountID, settingsToAdd);
                userAccount = this.a.updateLoginSettings(accountID, System.currentTimeMillis(), settingsToAdd, settingsToRemove);
                this.e.userUpdated(userAccount2, userAccount);
            }
        }
        this.c.dispatchEvent(userEventListener -> {
            try {
                userEventListener.userAccountUpdated(userAccount2, userAccount);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        if (toEventLog) {
            for (LoginSettings loginSettings : settingsToAdd) {
                this.h.log(UsersAndGroupsEventLog.UserLoginAdded, accountID, userAccount.getDisplayName(), loginSettings.getLoginSource() + "|" + loginSettings.getLoginID());
            }
            for (LoginSettings loginSettings : settingsToRemove) {
                this.h.log(UsersAndGroupsEventLog.UserLoginRemoved, accountID, userAccount.getDisplayName(), loginSettings.getLoginSource() + "|" + loginSettings.getLoginID());
            }
        }
    }

    private void a(GUID gUID, List<LoginSettings> list) {
        List<LoginSettings> list2 = this.b(gUID, list);
        if (list2.isEmpty()) {
            return;
        }
        LoginSettings loginSettings = list2.get(0);
        String string = loginSettings.getLoginSource();
        try {
            for (AuthenticationDescription authenticationDescription : LoginManager.getAllAuthenticationDescriptions()) {
                if (!Objects.equals(authenticationDescription.getSettings().get("provider"), string)) continue;
                string = authenticationDescription.getDisplayName();
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string2 = UsersAndGroups.MSG.getMsg("error.alreadyAssignedLoginSettings", string, loginSettings.getDisplayName());
        throw new IllegalArgumentException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserPermissions(GUID accountID, Set<Permission> permissionsToAdd, Set<Permission> permissionsToRemove) {
        UserAccount userAccount;
        UserAccount userAccount2;
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        UsersAndGroups.throwIfNullOrContainsNull(permissionsToAdd, "set \"permissionsToAdd\"");
        UsersAndGroups.throwIfNullOrContainsNull(permissionsToRemove, "set \"permissionsToRemove\"");
        Predicate<Permission> predicate = permission -> {
            try {
                Permission.valueOf(permission.getKey());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        };
        permissionsToAdd = permissionsToAdd.stream().filter(predicate).collect(Collectors.toSet());
        Set<String> set = permissionsToAdd.stream().map(Permission::getKey).collect(Collectors.toSet());
        Set<String> set2 = permissionsToRemove.stream().map(Permission::getKey).collect(Collectors.toSet());
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                block13: {
                    userAccount2 = this.getUserAccount(accountID);
                    BaseUserManager.a(userAccount2, accountID);
                    HashSet<Permission> hashSet = new HashSet<Permission>(userAccount2.getPermissions());
                    hashSet.addAll(permissionsToAdd);
                    hashSet.removeAll(permissionsToRemove);
                    if (!hashSet.equals(userAccount2.getPermissions())) break block13;
                    return;
                }
                userAccount = this.a.updatePermissions(accountID, System.currentTimeMillis(), set, set2);
                this.e.userUpdated(userAccount2, userAccount);
            }
        }
        if (set.size() > 0) {
            this.h.log(UsersAndGroupsEventLog.UserPermissionsAdded, accountID, userAccount2.getDisplayName(), set);
        }
        if (set2.size() > 0) {
            this.h.log(UsersAndGroupsEventLog.UserPermissionsRemoved, accountID, userAccount2.getDisplayName(), set2);
        }
        this.c.dispatchEvent(userEventListener -> {
            try {
                userEventListener.userAccountUpdated(userAccount2, userAccount);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
    }

    public static Set<String> loadAuthGroupNames(UserPersistence persistence, GUID accountID) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : BaseUserManager.a(persistence, accountID).values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Set<String>> a(UserPersistence userPersistence, GUID gUID) {
        try (InputStream inputStream = userPersistence.loadBinaryData(gUID, ROLES_KEY.getKey());){
            if (inputStream == null) {
                HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
                return hashMap;
            }
            Map map = (Map)new Json().fromJson((Reader)new UTF8StreamReader(inputStream), (Type)new JsonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, new JsonParameterizedType((Type)((Object)Set.class), new Type[]{String.class})}));
            return map;
        }
        catch (JsonException | IOException exception) {
            UsersAndGroups.LOGGER.error(exception);
            return new HashMap<String, Set<String>>();
        }
    }

    @Override
    public void deleteValuesOfRemovedCustomFields(List<UserField<?>> removedFields) {
        this.deleteValuesOfRemovedCustomFields(removedFields, () -> this.getIteratorOverUserAccountIDs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValuesOfRemovedCustomFields(List<UserField<?>> removedFields, Supplier<Iterator<GUID>> iteratorOverUserAccountIDsSupplier) {
        if (removedFields == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        if (iteratorOverUserAccountIDsSupplier == null) {
            throw new IllegalArgumentException("supplier must not be null");
        }
        List list = removedFields.stream().filter(userField -> !userField.isCustomField()).map(Field::getKey).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("list must contain only custom fields; keys of provided non-custom fields: " + String.valueOf(list));
        }
        Iterator<GUID> iterator = iteratorOverUserAccountIDsSupplier.get();
        while (iterator.hasNext()) {
            GUID gUID = iterator.next();
            ThreadUtils.Semaphore semaphore = BaseUserManager.a(gUID);
            try {
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    this.a.removeData(gUID, removedFields);
                }
            }
            finally {
                if (semaphore == null) continue;
                semaphore.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUserAccount(GUID accountID) {
        Set<String> set;
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        UserAccount userAccount = this.getUserAccount(accountID);
        if (userAccount == null) {
            return;
        }
        String string = userAccount.getValue(UsersAndGroups.FIELD_USER_LOCKED);
        if (string != null) {
            throw new IllegalArgumentException("Cannot delete because user is LOCKED: " + StringFunctions.encodeHTML(string));
        }
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.userAccountBeforeDeleted(userAccount));
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                set = BaseUserManager.loadAuthGroupNames(this.a, accountID);
                this.d.remove(accountID);
                this.a.delete(accountID);
                this.e.userDeleted(userAccount, set);
            }
        }
        AuthGroupManager.getInstance().a(set, Collections.emptySet());
        this.h.log(UsersAndGroupsEventLog.UserDeleted, accountID, userAccount.getDisplayName(), new Object[0]);
        this.c.dispatchEvent(userEventListener -> {
            try {
                userEventListener.userAccountDeleted(userAccount);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
    }

    @Override
    public void setUserAccountActive(GUID accountID) {
        this.a(accountID, true);
    }

    @Override
    public void setUserAccountInactive(GUID accountID) {
        if (MASTER_ACCOUNT_ID.equals(accountID)) {
            throw new IllegalArgumentException("Master Account can not be deactivated.");
        }
        this.a(accountID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GUID gUID, boolean bl) {
        UserAccount userAccount;
        this.a((Object)gUID, "accountID");
        BaseUserManager.c(gUID);
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(gUID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                UserAccount userAccount2;
                block14: {
                    userAccount2 = this.getUserAccount(gUID);
                    BaseUserManager.a(userAccount2, gUID);
                    if (userAccount2.isActive() != bl) break block14;
                    return;
                }
                if (bl) {
                    this.a(gUID, userAccount2.getLoginSettings());
                }
                userAccount = this.a.setAccountActive(gUID, System.currentTimeMillis(), bl);
                this.e.userUpdated(userAccount2, userAccount);
            }
        }
        if (bl) {
            this.h.log(UsersAndGroupsEventLog.UserReactivated, gUID, userAccount.getDisplayName(), new Object[0]);
        } else {
            this.h.log(UsersAndGroupsEventLog.UserDeactivated, gUID, userAccount.getDisplayName(), new Object[0]);
            StayLoggedInHandler.deleteSessions(gUID, StayLoggedInHandler.getSessions(gUID, this), this);
        }
        this.c.dispatchEvent(userEventListener -> {
            try {
                if (bl) {
                    userEventListener.userAccountReactivated(userAccount);
                } else {
                    userEventListener.userAccountDeactivated(userAccount);
                }
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryData(GUID accountID, BinaryDataKey key) {
        InputStream inputStream;
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                inputStream = this.a.loadBinaryData(accountID, key.getKey());
            }
        }
        if (Objects.equals(UserAvatar.BINARYKEY_USERAVATAR, key) && !ConfigurationManager.isRecoveryMode()) {
            ForkJoinPool.commonPool().execute(() -> {
                if (this.k != null) {
                    this.k.updateAvatarIfNeeded(accountID);
                }
            });
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBinaryData(GUID accountID, BinaryDataKey key, InputStream in, int length) {
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (in == null) {
            throw new IllegalArgumentException("input stream must not be null");
        }
        UserAccount userAccount = this.getUserAccount(accountID);
        BaseUserManager.a(userAccount, accountID);
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.beforeStoreBinaryData(userAccount, key));
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                if (!this.a.hasUserDataFor(accountID)) {
                    BaseUserManager.a(null, accountID);
                }
                this.a.saveBinaryData(accountID, key.getKey(), in, -1);
                if (key.shouldUpdateLastModified()) {
                    this.a.setLastModified(accountID, System.currentTimeMillis());
                }
            }
        }
        if (key.shouldUpdateEventLog()) {
            this.h.log(UsersAndGroupsEventLog.UserDataChanged, accountID, userAccount.getDisplayName(), key.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBinaryData(GUID accountID, BinaryDataKey key) {
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        UserAccount userAccount = this.getUserAccount(accountID);
        if (userAccount == null) {
            return;
        }
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.beforeDeleteBinaryData(userAccount, key));
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                this.a.deleteBinaryData(accountID, key.getKey());
                if (key.shouldUpdateLastModified()) {
                    this.a.setLastModified(accountID, System.currentTimeMillis());
                }
            }
        }
        if (key.shouldUpdateEventLog()) {
            this.h.log(UsersAndGroupsEventLog.UserDataChanged, accountID, userAccount.getDisplayName(), key.getKey());
        }
    }

    @Override
    @Nullable
    public UserAccount getUserAccount(@Nonnull GUID accountID) {
        if (PRIVILEGED_ACCOUNT_ID.equals(accountID)) {
            return this.g;
        }
        this.a((Object)accountID, "accountID");
        return this.a.load(accountID);
    }

    @Override
    public List<UserAccount> getUserAccounts(List<GUID> accountIDs) {
        UsersAndGroups.throwIfNullOrContainsNull(accountIDs, "list \"accountIDs\"");
        return this.a.load(accountIDs, Integer.MAX_VALUE);
    }

    @Override
    public Iterator<GUID> getIteratorOverUserAccountIDs(BinaryDataKey key) {
        String string = key == null ? null : key.getKey();
        return this.a.getUserAccountIdIterator(string);
    }

    @Override
    public void registerListener(UserEventListener listener) {
        this.c.registerListener(listener);
    }

    @Override
    public void unregisterListener(UserEventListener listener) {
        this.c.unregisterListener(listener);
    }

    public UserField<Object> getField(String fieldKey) {
        for (UserField<Object> userField : BaseUserManager.getAllFields()) {
            if (!userField.getKey().equalsIgnoreCase(fieldKey)) continue;
            return userField;
        }
        return null;
    }

    @Override
    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID) {
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.beforeUserSearch(phrase, additionalExpressions, boostingExpressions, maxResults, searchID));
        if (phrase == null) {
            throw new IllegalArgumentException("phrase must not be null");
        }
        if (additionalExpressions == null) {
            throw new IllegalArgumentException("list of additional expressions must not be null");
        }
        if (boostingExpressions == null) {
            throw new IllegalArgumentException("list of boosting expressions must not be null");
        }
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        return this.a().search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID);
    }

    @Override
    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID, @Nonnull Set<SearchTag> searchTags, @Nullable List<TokenMatcher<GUID>> tokenMatcher) {
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.beforeUserSearch(phrase, additionalExpressions, boostingExpressions, maxResults, searchID));
        if (phrase == null) {
            throw new IllegalArgumentException("phrase must not be null");
        }
        if (additionalExpressions == null) {
            throw new IllegalArgumentException("list of additional expressions must not be null");
        }
        if (boostingExpressions == null) {
            throw new IllegalArgumentException("list of boosting expressions must not be null");
        }
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        return this.a().search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID, searchTags, tokenMatcher);
    }

    @Override
    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.a().getSearchEngine();
    }

    public SearchResult<GUID> findActiveUserAccountID(String loginSource, String loginID) {
        return this.a().findActiveUserAccount(loginSource, loginID);
    }

    @Override
    public UserAccount findActiveUserAccount(String loginSource, String loginID) {
        Object object;
        Object object2;
        if ("master".equals(loginSource) && "Master".equals(loginID)) {
            return this.getUserAccount(MASTER_ACCOUNT_ID);
        }
        SearchResult<GUID> searchResult = this.a().findActiveUserAccount(loginSource, loginID);
        UserAccount userAccount2 = null;
        ArrayList<GUID> arrayList = new ArrayList<GUID>();
        boolean bl = searchResult.isPartialResult();
        boolean bl2 = false;
        String string = SearchTagLoginSettings.settingsAsToken(loginSource, loginID);
        Predicate<UserAccount> predicate = userAccount -> userAccount.getLoginSettingsFor(loginSource).stream().anyMatch(loginSettings -> {
            String string2 = SearchTagLoginSettings.settingsAsToken(loginSettings.getLoginSource(), loginSettings.getLoginID());
            return string2.equals(string);
        });
        for (SearchResultEntry<GUID> searchResultEntry : searchResult.getEntries()) {
            object2 = this.getUserAccount(searchResultEntry.getId());
            if (object2 != null && ((UserAccount)object2).isActive() && predicate.test((UserAccount)object2)) {
                if (userAccount2 == null) {
                    userAccount2 = object2;
                } else {
                    bl2 = true;
                }
                arrayList.add(((UserAccount)object2).getID());
                continue;
            }
            bl = true;
        }
        if (bl2) {
            SearchResultEntry<GUID> searchResultEntry;
            object = "found more than one active user account with assigned login settings: loginSource=\"%s\" loginID=\"%s\" userAccountIDs=\"%s\"";
            searchResultEntry = String.format((String)object, loginSource, loginID, ((Object)arrayList).toString());
            UsersAndGroups.LOGGER.error(searchResultEntry);
            object2 = new Notification("Duplicate Logins Error", (String)((Object)searchResultEntry));
            ((Notification)object2).setCritical(true);
            ((Notification)object2).setTargetUrl("usersandgroups/");
            ForkJoinPool.commonPool().execute(() -> BaseUserManager.a((Notification)object2));
        }
        if (bl) {
            if (!this.getSearchEngine().isReindexRunning()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("process of reindexing the search engine is going to be started because at least one user account has been false matched ");
                ((StringBuilder)object).append("during search for active account with assigned login settings: ");
                ((StringBuilder)object).append("loginSource=\"").append(loginSource).append("\" loginID=\"").append(loginID).append("\" ");
                UsersAndGroups.LOGGER.error(((StringBuilder)object).toString());
                this.getSearchEngine().reIndexAsync();
                UserGroupManager.getInstance().getSearchEngine().reIndexAsync();
            }
            object = UsersAndGroups.MSG.getMsg("error.corruptUserSearchIndex", this.getSearchEngine().getRunningIndexCount());
            throw new ServiceUnavailableException((String)object);
        }
        return userAccount2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userLoggedIn(@Nonnull UserAccount userAccount, @Nonnull LoginProcessor login) {
        Set<String> set;
        Object object;
        Set<UserGroupInfo> set2;
        HashSet<String> hashSet = null;
        if (login.supportsRoles()) {
            hashSet = new HashSet<String>();
            if (login instanceof LoginRoles) {
                set2 = ((LoginRoles)((Object)login)).getRoles();
                for (String object22 : set2) {
                    if (!UserGroupKey.isValidGroupName(object22)) continue;
                    hashSet.add(object22);
                }
            } else {
                set2 = UserGroupManager.getInstance().getGroups(UsersAndGroups.GROUPTYPE_AUTH);
                for (UserGroupInfo userGroupInfo : set2) {
                    object = userGroupInfo.getName();
                    if (!login.isWebUserInRole((String)object)) continue;
                    hashSet.add((String)object);
                }
            }
        }
        set2 = userAccount.getID();
        this.setCurrentUserAccountID((GUID)((Object)set2));
        Iterator<UserGroupInfo> iterator = login.getLoginSource().toLowerCase();
        object = BaseUserManager.a(set2);
        try {
            ThreadUtils.Semaphore semaphore = object;
            synchronized (semaphore) {
                block18: {
                    long l2 = System.currentTimeMillis();
                    long l3 = this.getUserAccount((GUID)((Object)set2)).getLastAccess();
                    this.a.setLastAccess((GUID)((Object)set2), l2);
                    this.e.userAccountLastAccessUpdated((GUID)((Object)set2), l3, l2);
                    if (hashSet != null) break block18;
                    return;
                }
                Map<String, Set<String>> map = BaseUserManager.a(this.a, set2);
                set = map.getOrDefault(iterator, Collections.emptySet());
                if (hashSet.equals(set)) {
                    return;
                }
                map.put((String)((Object)iterator), (Set<String>)hashSet);
                String string = new Json().toJson(map);
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                this.d.remove(set2);
                this.a.saveBinaryData((GUID)((Object)set2), ROLES_KEY.getKey(), new FastByteArrayInputStream(byArray), -1);
                this.e.userAuthGroupNamesUpdated((GUID)((Object)set2), set, (Set<String>)hashSet);
            }
        }
        finally {
            if (object != null) {
                ((ThreadUtils.Semaphore)object).close();
            }
        }
        AuthGroupManager.getInstance().a(set, hashSet);
        this.h.log(UsersAndGroupsEventLog.UserDataChanged, (GUID)((Object)set2), userAccount.getDisplayName(), ROLES_KEY.getKey(), hashSet, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUserAuthGroupNames(GUID accountID) {
        Set<String> set = this.getAuthGroupsForUser(accountID);
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                this.d.remove(accountID);
                this.e.userAuthGroupNamesUpdated(accountID, set, Collections.emptySet());
            }
        }
        AuthGroupManager.getInstance().a(set, Collections.emptySet());
    }

    @Override
    @Nonnull
    public LoginProcessor getNonSessionLoginProcessor(GUID accountID, String loginID, String loginSource) {
        block3: {
            UserAccount userAccount;
            this.a((Object)accountID, "accountID");
            BaseUserManager.c(accountID);
            if ((loginID == null || loginSource == null) && (userAccount = this.getUserAccount(accountID)) != null) {
                List<LoginSettings> list = userAccount.getLoginSettings();
                for (LoginSettings loginSettings : list) {
                    if (loginSource != null && !loginSource.equals(loginSettings.getLoginSource())) continue;
                    loginID = loginSettings.getLoginID();
                    loginSource = loginSettings.getLoginSource();
                    break block3;
                }
                Iterator<LoginSettings> iterator = list.iterator();
                if (iterator.hasNext()) {
                    LoginSettings loginSettings;
                    loginSettings = iterator.next();
                    loginID = loginSettings.getLoginID();
                    loginSource = loginSettings.getLoginSource();
                }
            }
        }
        return new NonSessionLoginProcessor(accountID, loginID, loginSource);
    }

    @Override
    public Set<GUID> getAuthGroupMemberIDs(String authGroupName) {
        if (authGroupName == null) {
            throw new IllegalArgumentException("group name must not be null");
        }
        if (authGroupName.trim().isEmpty()) {
            throw new IllegalArgumentException("group name must not be empty after trim");
        }
        return this.a().findAuthGroupMembers(authGroupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthGroupsForUser(GUID accountID) {
        this.a((Object)accountID, "accountID");
        if (PRIVILEGED_ACCOUNT_ID.equals(accountID) || MASTER_ACCOUNT_ID.equals(accountID)) {
            return Collections.emptySet();
        }
        Set<String> set = (Set<String>)this.d.get(accountID);
        if (set != null) {
            return set;
        }
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                block13: {
                    set = (Set)this.d.get(accountID);
                    if (set == null) break block13;
                    Set<String> set2 = set;
                    return set2;
                }
                set = Collections.unmodifiableSet(BaseUserManager.loadAuthGroupNames(this.a, accountID));
                this.d.put(accountID, set);
                Set<String> set3 = set;
                return set3;
            }
        }
    }

    @Override
    public List<LoginSettings> findConflictingLoginSettings(GUID accountID) {
        UserAccount userAccount = this.getUserAccount(accountID);
        BaseUserManager.a(userAccount, accountID);
        return this.b(accountID, userAccount.getLoginSettings());
    }

    private List<LoginSettings> b(GUID gUID, List<LoginSettings> list) {
        ArrayList<LoginSettings> arrayList = new ArrayList<LoginSettings>();
        UserSearchEngine userSearchEngine = this.a();
        for (LoginSettings loginSettings : list) {
            SearchResult<GUID> searchResult = userSearchEngine.findActiveUserAccount(loginSettings.getLoginSource(), loginSettings.getLoginID());
            boolean bl = !searchResult.getEntries().stream().allMatch(searchResultEntry -> Objects.equals(searchResultEntry.getId(), gUID));
            if (!bl) continue;
            arrayList.add(loginSettings);
        }
        return arrayList;
    }

    private void a(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " must not be null");
        }
    }

    private static void c(GUID gUID) {
        if (PRIVILEGED_ACCOUNT_ID.equals(gUID)) {
            throw new IllegalArgumentException("operation is not allowed in case of ID which is reserved for privileged background processing");
        }
    }

    private static void a(@Nullable UserAccount userAccount, @Nonnull GUID gUID) {
        if (userAccount == null) {
            throw new IllegalArgumentException(UsersAndGroups.MSG.getMsg("error.accountDoesNotExist", gUID));
        }
    }

    @Nonnull
    static ThreadUtils.Semaphore a(GUID gUID) {
        return ThreadUtils.getSemaphore(gUID);
    }

    @Override
    public void hardReset() throws IOException {
        this.a.hardReset();
        this.d.clear();
        this.getSearchEngine().reIndexAsync();
    }

    @Override
    public long getAccountFileSize(GUID accountId) {
        return this.a.getAccountFileSize(accountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<String, InputStream>> getBinaryDataIterator(GUID accountID) {
        this.a((Object)accountID, "accountID");
        BaseUserManager.c(accountID);
        try (ThreadUtils.Semaphore semaphore = BaseUserManager.a(accountID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                Iterator<Map.Entry<String, InputStream>> iterator = this.a.getBinaryDataIterator(accountID);
                return iterator;
            }
        }
    }

    @Override
    public SearchResult<GUID> searchAsUser(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID) {
        if (phrase == null) {
            throw new IllegalArgumentException("phrase must not be null");
        }
        if (additionalExpressions == null) {
            throw new IllegalArgumentException("list of additional expressions must not be null");
        }
        if (boostingExpressions == null) {
            throw new IllegalArgumentException("list of boosting expressions must not be null");
        }
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        if (!SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            return new SearchResult<GUID>(List.of(), false);
        }
        if (this.getCurrentUserAccountID() == null) {
            throw new AccessDeniedException(BaseErrorCode.UserNotLoggedIn, new Object[0]);
        }
        HashSet<SearchTag> hashSet = new HashSet<SearchTag>(this.getSearchEngine().getTags());
        hashSet.removeIf(searchTag -> !searchTag.isTextSearchEnabled());
        ArrayList arrayList = new ArrayList();
        List<TokenMatcher<GUID>> list = this.getSearchEngine().getTokenMatcher();
        if (list != null) {
            arrayList.addAll(list);
        }
        arrayList.removeIf(tokenMatcher -> !tokenMatcher.isTextSearchEnabled());
        TextSearchCommandBuilder textSearchCommandBuilder = new TextSearchCommandBuilder(hashSet, arrayList, phrase);
        SearchCommand searchCommand = textSearchCommandBuilder.build();
        searchCommand.setID(searchID);
        searchCommand.setResultLimit(maxResults);
        searchCommand.getSearchExpression().addAll(additionalExpressions);
        for (SearchExpression searchExpression : boostingExpressions) {
            searchCommand.addBoostingExpression(searchExpression);
        }
        DynamicExtensionManager.getInstance().get(UserSearchFilter.class).forEach(userSearchFilter -> userSearchFilter.customizeUserSearch(searchCommand));
        if (searchCommand.getSearchExpression().isEmpty()) {
            searchCommand.getSearchExpression().add(new SearchCondition("useraccountdisplayname", SearchCondition.SearchTermOperator.StartsWith, ""));
        }
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.beforeUserSearch("", searchCommand.getSearchExpression(), searchCommand.getBoostingExpressions(), searchCommand.getResultLimit(), searchCommand.getID()));
        UserSearchEngine userSearchEngine = this.a();
        return userSearchEngine.search(searchCommand);
    }

    @Override
    public SearchResult<GUID> searchAsUser(SearchCommand command) {
        Collection<TokenMatcher<GUID>> collection;
        if (!SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            return new SearchResult<GUID>(List.of(), false);
        }
        if (this.getCurrentUserAccountID() == null) {
            throw new AccessDeniedException(BaseErrorCode.UserNotLoggedIn, new Object[0]);
        }
        HashSet<SearchTag> hashSet = new HashSet<SearchTag>();
        if (command.getTags() == null) {
            hashSet.addAll(this.getSearchEngine().getTags());
        } else {
            hashSet.addAll(command.getTags());
        }
        command.setTags(hashSet);
        ArrayList arrayList = new ArrayList();
        if (command.getTokenMatcher() == null) {
            collection = this.getSearchEngine().getTokenMatcher();
            if (collection != null) {
                arrayList.addAll(collection);
            }
        } else {
            arrayList.addAll(command.getTokenMatcher());
        }
        command.setTokenMatcher(arrayList);
        hashSet.removeIf(searchTag -> !searchTag.isTextSearchEnabled());
        arrayList.removeIf(tokenMatcher -> !tokenMatcher.isTextSearchEnabled());
        collection = new HashSet();
        hashSet.forEach(searchTag -> collection.add((TokenMatcher<GUID>)((Object)searchTag.getTag())));
        arrayList.forEach(tokenMatcher -> collection.add((TokenMatcher<GUID>)((Object)tokenMatcher.getTag())));
        if (this.a(command.getSearchExpression(), (Set<String>)collection)) {
            UsersAndGroups.LOGGER.debug("SearchForUser with non supported tag ");
            return new SearchResult<GUID>(List.of(), false);
        }
        DynamicExtensionManager.getInstance().get(UserSearchFilter.class).forEach(userSearchFilter -> userSearchFilter.customizeUserSearch(command));
        if (command.getSearchExpression().isEmpty()) {
            command.getSearchExpression().add(new SearchCondition("useraccountdisplayname", SearchCondition.SearchTermOperator.StartsWith, ""));
        }
        this.c.dispatchEventAndWait(userEventListener -> userEventListener.beforeUserSearch("", command.getSearchExpression(), command.getBoostingExpressions(), command.getResultLimit(), command.getID()));
        UserSearchEngine userSearchEngine = this.a();
        return userSearchEngine.search(command);
    }

    private boolean a(List<SearchExpression> list, Set<String> set) {
        for (SearchExpression searchExpression : list) {
            boolean bl;
            if (searchExpression instanceof SubtractSearchExpression) {
                searchExpression = ((SubtractSearchExpression)searchExpression).getRight();
            }
            SearchExpression searchExpression2 = searchExpression;
            if (searchExpression instanceof SearchCondition && !set.contains(((SearchCondition)searchExpression2).getLeftOperand())) {
                return true;
            }
            if (!(searchExpression instanceof List) || !(bl = this.a((List)((Object)searchExpression), set))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(Notification notification) {
        NotificationManager.getInstance().sendNotificationToAllAdministrators(notification);
    }

    public static class NonSessionLoginProcessor
    extends LoginProcessor {
        private GUID a;
        private String b;
        private String c;

        NonSessionLoginProcessor(GUID accountID, String loginID, String loginSource) {
            super(null);
            this.a = accountID;
            this.b = loginID;
            this.c = loginSource;
        }

        @Override
        public GUID getUserAccountID() {
            return this.a;
        }

        @Override
        public boolean supportsRoles() {
            return false;
        }

        @Override
        public boolean isWebUserInRole(String role) {
            return false;
        }

        @Override
        @Nonnull
        public String getLoginSource() {
            return this.c;
        }

        @Override
        public String getLoginID() {
            return this.b;
        }
    }
}

