/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.takeout;

import com.inet.annotations.InternalApi;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

@InternalApi
public class TimeTakeoutDataRenderer
implements TakeoutDataRenderer {
    @Override
    public String getExtensionName() {
        return "fieldtype_time";
    }

    @Override
    public String render(FieldValue fieldValue) {
        if (StringFunctions.isEmpty(fieldValue.getValue())) {
            return null;
        }
        try {
            long l2 = Long.parseLong(fieldValue.getValue());
            ZoneId zoneId = ClientTimezone.getTimeZone().toZoneId();
            LocalTime localTime = LocalTime.ofInstant(Instant.ofEpochMilli(l2), zoneId);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(ClientLocale.getThreadLocale()).withZone(zoneId);
            return dateTimeFormatter.format(localTime);
        }
        catch (Exception exception) {
            return fieldValue.getValue();
        }
    }
}

