/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups.search;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.search.DisplayNameCustomizer;
import com.inet.search.ResultLineFactory;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultEntryAdjuster;
import com.inet.search.resultlinefactory.DefaultResultLineFactory;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.groups.search.UserGroupDisplayNameCustomizer;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchDataCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserGroupSearchEngine {
    public static final int DEFAULT_FIELD_PRIORITY = 100;
    private IndexSearchEngine<GUID> a;
    private UserGroupSearchDataCache b;
    private final ResultLineFactory c;
    private final DisplayNameCustomizer d;
    private SearchIndexVeto e;

    public UserGroupSearchEngine(boolean useOriginalInRecoveryMode) {
        this.a = this.createSearchEngine(useOriginalInRecoveryMode);
        this.c = new DefaultResultLineFactory();
        this.d = new UserGroupDisplayNameCustomizer();
    }

    public void setSearchIndexVeto(@Nullable SearchIndexVeto searchIndexVeto) {
        this.e = searchIndexVeto;
    }

    protected IndexSearchEngine<GUID> createSearchEngine(boolean useOriginalInRecoveryMode) {
        return new IndexSearchEngine<GUID>("usergroupsearch", this.createReindexKey(), useOriginalInRecoveryMode, GUID.class);
    }

    protected String createReindexKey() {
        return null;
    }

    public void init(UserGroupSearchDataCache cache) throws IOException {
        if (cache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (this.b != null) {
            throw new IllegalStateException("search data cache is already set");
        }
        try {
            this.b = cache;
            for (SearchTag searchTag : cache.a()) {
                this.a.addTag(searchTag);
            }
            this.a.setPrimaryTag(this.a.getTag("groupname"));
            if (this.e != null) {
                this.e.setStatusToStartingInitOfIndex(this.a);
            }
            this.a.setData(cache);
            if (this.e != null) {
                this.e.setStatusToFinishedInitOfIndex();
            }
        }
        catch (IOException iOException) {
            if (this.e != null) {
                this.e.setStatusToFailedInitOfIndex();
            }
            throw iOException;
        }
    }

    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.a;
    }

    public boolean hasTag(String key) {
        return this.a.getTag(key) != null;
    }

    public SearchResult<GUID> search(@Nonnull String searchPhrase, @Nonnull List<SearchExpression> additionalExpressions, @Nonnull List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID) {
        return this.search(searchPhrase, additionalExpressions, boostingExpressions, maxResults, searchID, this.a.getTags(), this.a.getTokenMatcher());
    }

    public SearchResult<GUID> search(@Nonnull String searchPhrase, @Nonnull List<SearchExpression> additionalExpressions, @Nonnull List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID, @Nonnull Set<SearchTag> searchTags, @Nullable List<TokenMatcher<GUID>> tokenMatcher) {
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        TextSearchCommandBuilder textSearchCommandBuilder = new TextSearchCommandBuilder(searchTags, tokenMatcher, searchPhrase);
        SearchCommand searchCommand = textSearchCommandBuilder.build();
        searchCommand.setID(searchID);
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.addAll(searchCommand.getSearchExpression());
        searchCommand.getSearchExpression().addAll(additionalExpressions);
        for (SearchExpression object2 : boostingExpressions) {
            searchCommand.addBoostingExpression(object2);
        }
        SearchResult<GUID> searchResult = this.a.search(searchCommand);
        List list = searchResult.getEntries();
        List<GUID> list2 = list.stream().map(SearchResultEntry::getId).collect(Collectors.toList());
        Map<GUID, Map<String, Object>> map = this.b.getCacheEntries(list2, maxResults);
        SearchResultEntryAdjuster searchResultEntryAdjuster = new SearchResultEntryAdjuster(this.c, this.d, this.a, andSearchExpression);
        ArrayList arrayList = new ArrayList();
        for (SearchResultEntry searchResultEntry : list) {
            Map<String, Object> map2 = map.get(searchResultEntry.getId());
            if (map2 == null) continue;
            searchResultEntryAdjuster.processEntry(searchResultEntry, map2);
            arrayList.add(searchResultEntry);
        }
        Collections.sort(arrayList);
        boolean bl = searchResult.isPartialResult() || list.size() > arrayList.size();
        return new SearchResult<GUID>(arrayList, bl);
    }
}

