/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups.persistence;

import com.inet.annotations.JsonData;
import com.inet.error.PersistenceException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.usersandgroups.api.FileSystemPersistenceHelper;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonData
public class UserGroupPersistenceUnit {
    public static final String PROPERTY_PARENTID = "parentID";
    public static final String PROPERTY_GROUPNAME = "groupName";
    public static final String PROPERTY_GROUPTYPE = "groupType";
    public static final String PROPERTY_LASTMODIFIED = "lastModified";
    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_MEMBERS = "members";
    public static final String PROPERTY_PERMISSIONS = "permissions";
    private HashMap<String, String> properties;
    private HashMap<String, String> fields;

    private UserGroupPersistenceUnit() {
    }

    public static byte[] toJsonizedPersistenceUnit(@Nullable GUID parentID, String groupName, String groupType, long lastModified, boolean active, UserGroupMembership membership, MutableUserGroupData groupData, Set<String> permissions) {
        try {
            UserGroupField<Object> userGroupField2;
            Set<UserGroupField<Object>> set = groupData.getIncludedFields();
            HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
            for (UserGroupField<Object> userGroupField2 : set) {
                Object object = groupData.get(userGroupField2);
                if (object == null) continue;
                String string = new Json().toJson(object);
                hashMap.put(userGroupField2.getKey(), string);
            }
            HashMap<GUID, Set<String>> hashMap2 = UserGroupPersistenceUnit.convertToMembersMap(membership);
            userGroupField2 = new UserGroupPersistenceUnit(parentID, groupName, groupType, lastModified, active, hashMap2, hashMap, permissions);
            return FileSystemPersistenceHelper.toEncodedJsonized(userGroupField2);
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    private static HashMap<GUID, Set<String>> convertToMembersMap(UserGroupMembership membership) {
        HashMap<GUID, Set<String>> hashMap = new HashMap<GUID, Set<String>>();
        for (GUID gUID : membership.getMemberIDs()) {
            Set set = membership.getMembershipTypes(gUID).stream().map(MembershipType::getKey).collect(Collectors.toSet());
            hashMap.put(gUID, set);
        }
        return hashMap;
    }

    public UserGroupPersistenceUnit(@Nullable GUID parentID, String groupName, String groupType, long lastModified, boolean active, HashMap<GUID, Set<String>> members, HashMap<String, String> fields, Set<String> permissions) {
        this.properties = new HashMap();
        if (parentID != null) {
            this.properties.put(PROPERTY_PARENTID, parentID.toString());
        }
        this.properties.put(PROPERTY_GROUPNAME, groupName);
        this.properties.put(PROPERTY_GROUPTYPE, groupType);
        this.properties.put(PROPERTY_LASTMODIFIED, String.valueOf(lastModified));
        this.properties.put(PROPERTY_ACTIVE, String.valueOf(active));
        this.properties.put(PROPERTY_MEMBERS, new Json().toJson(members));
        this.properties.put(PROPERTY_PERMISSIONS, new Json().toJson(permissions));
        this.fields = fields;
    }

    public static UserGroupPersistenceUnit createReplacementForCorruptedData() {
        UserGroupPersistenceUnit userGroupPersistenceUnit = new UserGroupPersistenceUnit();
        userGroupPersistenceUnit.properties = new HashMap();
        userGroupPersistenceUnit.properties.put(PROPERTY_ACTIVE, String.valueOf(false));
        return userGroupPersistenceUnit;
    }

    public GUID getParentID() {
        String string = this.getProperty(PROPERTY_PARENTID);
        try {
            return new GUID(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getGroupName() {
        return this.getProperty(PROPERTY_GROUPNAME);
    }

    public String getGroupType() {
        return this.getProperty(PROPERTY_GROUPTYPE);
    }

    public long getLastModified() {
        try {
            String string = this.getProperty(PROPERTY_LASTMODIFIED);
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return System.currentTimeMillis();
        }
    }

    public boolean isActive() {
        String string = this.getProperty(PROPERTY_ACTIVE);
        if (string == null) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public HashMap<GUID, Set<String>> getMembers() {
        try {
            String string = this.getProperty(PROPERTY_MEMBERS);
            return (HashMap)new Json().fromJson(string, (Type)new JsonParameterizedType((Type)((Object)Map.class), new Type[]{GUID.class, new JsonParameterizedType((Type)((Object)Set.class), new Type[]{String.class})}));
        }
        catch (JsonException jsonException) {
            return new HashMap<GUID, Set<String>>();
        }
    }

    public HashMap<String, String> getFields() {
        return this.fields == null ? new HashMap<String, String>() : this.fields;
    }

    public Set<String> getPermissions() {
        try {
            String string = this.getProperty(PROPERTY_PERMISSIONS);
            return (Set)new Json().fromJson(string, (Type)new JsonParameterizedType((Type)((Object)Set.class), new Type[]{String.class}));
        }
        catch (JsonException jsonException) {
            return new HashSet<String>();
        }
    }

    private String getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }
}

