/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.usersandgroups.api.groups.GroupType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserGroupKey {
    public static final int NAME_LENGTH_LIMIT = 100;
    @Nonnull
    private final String a;
    private final GroupType b;

    public static boolean isValidGroupName(String groupName) {
        try {
            UserGroupKey.throwIfGroupNameIsInvalid(groupName);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void throwIfGroupNameIsInvalid(String groupName) {
        if (groupName == null || groupName.trim().isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty after trim");
        }
        if (groupName.length() > 100) {
            throw new IllegalArgumentException("Length of the name must not exceed 100 characters: " + groupName);
        }
    }

    @Nonnull
    public static UserGroupKey of(@Nonnull String name, GroupType type) {
        return new UserGroupKey(name, type);
    }

    private UserGroupKey(@Nonnull String name, GroupType type) {
        UserGroupKey.throwIfGroupNameIsInvalid(name);
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.a = name;
        this.b = type;
    }

    @Nonnull
    public String getName() {
        return this.a;
    }

    public GroupType getType() {
        return this.b;
    }

    @Nonnull
    public String toString() {
        return "UserGroupKey [name=" + this.a + ", type=" + String.valueOf(this.b) + "]";
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.toLowerCase().hashCode());
        n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
        return n3;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserGroupKey userGroupKey = (UserGroupKey)obj;
        if (this.a == null ? userGroupKey.a != null : !this.a.equalsIgnoreCase(userGroupKey.a)) {
            return false;
        }
        return !(this.b == null ? userGroupKey.b != null : !this.b.equals(userGroupKey.b));
    }
}

