/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;

@InternalApi
public abstract class UserGroupField<VALUE>
extends Field<VALUE> {
    public UserGroupField(String key) {
        this(key, null, FieldTypeFactory.auto().withoutSearchTag());
    }

    public UserGroupField(String key, VALUE defaultValue, FieldTypeFactory factory) {
        super(key, defaultValue, factory.withIsInTextSearchEnabled(() -> {
            GroupFieldDefinition groupFieldDefinition = UsersAndGroups.getUserGroupFieldDefinitionByKey(key);
            if (groupFieldDefinition == null) {
                return false;
            }
            return groupFieldDefinition.isAvailable(null);
        }));
    }

    @Override
    public String getLabel() {
        return "<no UG label> in " + String.valueOf(this.getClass());
    }

    public boolean isValueChangeLoggable() {
        return true;
    }
}

