/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.annotations.InternalApi;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import javax.annotation.Nonnull;

@InternalApi
public class BasicFieldValidation {
    public static void throwIfNull(Object value) {
        if (value == null) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.null", new Object[0]));
        }
    }

    public static void throwIfNull(Object value, String label) {
        if (value == null) {
            throw new FieldValidationException((String)(label == null ? "" : label + ": ") + UsersAndGroups.MSG.getMsg("fieldvalidation.null", new Object[0]));
        }
    }

    public static void throwIfFieldValueDoesNotExist(Object value, Object id, String fieldName) {
        if (value == null) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.valueNotExists", id, fieldName));
        }
    }

    public static void throwIfLengthExceedsLimit(@Nonnull String value, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("max length must not be negative");
        }
        int n2 = value.length();
        if (n2 > maxLength) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.toolong", maxLength, n2));
        }
    }

    public static void throwIfNegative(double value) {
        if (value < 0.0) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.negative", new Object[0]));
        }
    }

    public static void throwIfNegative(long value) {
        if (value < 0L) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.negative", new Object[0]));
        }
    }

    public static void throwIfNegative(int value) {
        if (value < 0) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.negative", new Object[0]));
        }
    }

    public static void throwIfExceedsLimit(double value, double limit) {
        if (limit < 0.0) {
            throw new IllegalArgumentException("limit must not be negative");
        }
        if (value > limit) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.toolarge", limit, value));
        }
    }

    public static void throwIfZero(int value) {
        if (value == 0) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.zero", new Object[0]));
        }
    }
}

