/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread;

import com.inet.annotations.InternalApi;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.logging.LogManager;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

@InternalApi
public class EventDispatcher<LISTENER> {
    private final a<LISTENER> a;

    public EventDispatcher() {
        this(true, true);
    }

    public EventDispatcher(boolean runPrivileged) {
        this(runPrivileged, true);
    }

    public EventDispatcher(boolean runPrivileged, boolean spoolOnShutdown) {
        this(runPrivileged, spoolOnShutdown, ForkJoinPool.commonPool());
    }

    public EventDispatcher(boolean runPrivileged, boolean spoolOnShutdown, ForkJoinPool pool) {
        this(runPrivileged, spoolOnShutdown, pool, -1L);
    }

    public EventDispatcher(boolean runPrivileged, boolean spoolOnShutdown, ForkJoinPool pool, long timeout) {
        this.a = new a(runPrivileged, pool, timeout);
        if (spoolOnShutdown) {
            ShutdownManager.add(this.a);
        }
    }

    public void registerListener(LISTENER listener) {
        this.a.a(listener);
    }

    public void unregisterListener(LISTENER listener) {
        this.a.b(listener);
    }

    public List<LISTENER> getListeners() {
        return new ArrayList(Arrays.asList(this.a.c));
    }

    public void dispatchEvent(Consumer<LISTENER> event) {
        this.a.a(event);
    }

    public void dispatchEventAndWait(Consumer<LISTENER> event) {
        this.a.b(event);
    }

    public void dispatchEvent(Runnable event) {
        this.a.a(event);
    }

    protected void finalize() throws Throwable {
        ShutdownManager.remove(this.a);
    }

    private static class a<LISTENER>
    implements ShutdownFinalizer {
        private final AtomicBoolean a = new AtomicBoolean(false);
        private final Queue<Runnable> b = new ArrayDeque<Runnable>();
        private LISTENER[] c = new Object[0];
        private final boolean d;
        private final ForkJoinPool e;
        private long f;

        a(boolean bl, ForkJoinPool forkJoinPool, long l2) {
            this.d = bl;
            this.e = forkJoinPool;
            this.f = l2;
        }

        @Override
        public void onShutdown() {
            this.a();
            for (int i2 = 0; this.a.get() && i2 < 1000; ++i2) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void a(LISTENER LISTENER) {
            Objects.requireNonNull(LISTENER, "listener must not be null");
            Queue<Runnable> queue = this.b;
            synchronized (queue) {
                int n2 = this.c.length;
                LISTENER[] LISTENERArray = Arrays.copyOf(this.c, n2 + 1);
                LISTENERArray[n2] = LISTENER;
                this.c = LISTENERArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void b(LISTENER LISTENER) {
            Queue<Runnable> queue = this.b;
            synchronized (queue) {
                LISTENER[] LISTENERArray = this.c;
                for (int i2 = 0; i2 < LISTENERArray.length; ++i2) {
                    if (LISTENERArray[i2] != LISTENER) continue;
                    Object[] objectArray = new Object[LISTENERArray.length - 1];
                    System.arraycopy(LISTENERArray, 0, objectArray, 0, i2);
                    System.arraycopy(LISTENERArray, i2 + 1, objectArray, i2, objectArray.length - i2);
                    this.c = objectArray;
                    return;
                }
            }
        }

        void a(Consumer<LISTENER> consumer) {
            this.a(() -> this.b(consumer));
        }

        void b(Consumer<LISTENER> consumer) {
            LISTENER[] LISTENERArray;
            for (LISTENER LISTENER : LISTENERArray = this.c) {
                consumer.accept(LISTENER);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void a(Runnable runnable) {
            Queue<Runnable> queue = this.b;
            synchronized (queue) {
                this.b.add(runnable);
                this.a();
            }
        }

        private void a() {
            if (this.a.compareAndSet(false, true)) {
                this.b();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void b() {
            Runnable runnable;
            Queue<Runnable> queue = this.b;
            synchronized (queue) {
                runnable = this.b.poll();
                if (runnable == null) {
                    this.a.set(false);
                    return;
                }
            }
            this.e.execute(() -> {
                AccessController.doPrivileged(() -> {
                    block14: {
                        TimerTask timerTask = null;
                        try {
                            if (this.f > 0L) {
                                timerTask = new DefaultTimerTask(){
                                    private Thread c = Thread.currentThread();

                                    @Override
                                    public void runImpl() throws Throwable {
                                        this.c.interrupt();
                                        LogManager.getApplicationLogger().info("Timeout in Event: " + String.valueOf(runnable));
                                    }
                                };
                                DefaultTimer.getInstance().schedule((DefaultTimerTask)timerTask, this.f);
                            }
                            if (this.d) {
                                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                                    runnable.run();
                                    break block14;
                                }
                            }
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            LogManager.getApplicationLogger().error("Exception in Event: ", throwable);
                        }
                        finally {
                            if (timerTask != null) {
                                timerTask.cancel();
                            }
                        }
                    }
                    return null;
                });
                this.b();
            });
        }
    }
}

