/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.annotations.InternalApi;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@InternalApi
public class WeakValueMap<K, V>
extends AbstractMap<K, V> {
    private final ReferenceQueue<b<K, V>> a = new ReferenceQueue();
    private final Map<K, b<K, V>> b;
    private Set<Map.Entry<K, V>> c;

    public WeakValueMap(Map map) {
        this.b = map;
        if (map.size() > 0) {
            throw new IllegalArgumentException("Initial map must be empty");
        }
    }

    public WeakValueMap(Supplier<Map> map) {
        this(map.get());
    }

    public WeakValueMap() {
        this(new ConcurrentHashMap());
    }

    private void a() {
        b b2;
        while ((b2 = (b)this.a.poll()) != null) {
            if (b2 != this.b.get(b2.a)) continue;
            this.b.remove(b2.a);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.c == null ? (this.c = new a<K, V>(this.b.entrySet())) : this.c;
    }

    @Override
    public V get(Object key) {
        WeakReference weakReference = this.b.get(key);
        if (weakReference != null) {
            return (V)weakReference.get();
        }
        return null;
    }

    public Map.Entry<K, V> getEntry(K key) {
        b<K, V> b2 = this.b.get(key);
        if (b2 != null) {
            final K k2 = b2.a();
            final Object t = b2.get();
            if (t != null) {
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return k2;
                    }

                    @Override
                    public V getValue() {
                        return t;
                    }

                    @Override
                    public V setValue(V value) {
                        return WeakValueMap.this.put(k2, value);
                    }
                };
            }
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.a();
        WeakReference weakReference = this.b.put(key, value == null ? null : new b<K, V>(key, value, this.a));
        return weakReference != null ? (V)weakReference.get() : null;
    }

    @Override
    public V remove(Object key) {
        WeakReference weakReference = this.b.remove(key);
        if (weakReference != null) {
            return (V)weakReference.get();
        }
        return null;
    }

    @Override
    public int size() {
        return this.b.size();
    }

    @Override
    @Nonnull
    public V computeIfAbsent(K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
        return (V)this.b.computeIfAbsent(key, object -> new b(object, mappingFunction.apply((K)object), this.a)).get();
    }

    private static class b<K, V>
    extends WeakReference<V> {
        private K a;

        private b(K k2, V v, ReferenceQueue referenceQueue) {
            super(v, referenceQueue);
            this.a = k2;
        }

        private K a() {
            return this.a;
        }
    }

    private class a<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private Set<Map.Entry<K, b<K, V>>> b;

        a(Set<Map.Entry<K, b<K, V>>> set) {
            this.b = set;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<K, b<K, V>>> b;
                {
                    this.b = a.this.b.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.b.hasNext();
                }

                public Map.Entry<K, V> a() {
                    final Map.Entry entry = this.b.next();
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            WeakReference weakReference = (WeakReference)entry.getValue();
                            if (weakReference != null) {
                                return weakReference.get();
                            }
                            return null;
                        }

                        @Override
                        public V setValue(V value) {
                            Object v = this.getValue();
                            entry.setValue(value == null ? null : new b(entry.getKey(), value, WeakValueMap.this.a));
                            return v;
                        }
                    };
                }

                @Override
                public void remove() {
                    this.b.remove();
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.a();
                }
            };
        }

        @Override
        public int size() {
            return this.b.size();
        }

        @Override
        public boolean remove(Object o2) {
            return this.b.remove(o2);
        }

        @Override
        public void clear() {
            this.b.clear();
        }
    }
}

