/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.bidi;

import com.inet.annotations.InternalApi;
import com.inet.shared.bidi.UnicodeMirroredCharsTable;
import java.text.Bidi;
import java.util.HashSet;
import javax.annotation.Nonnull;

@InternalApi
public class BidiString {
    private static final boolean useDigitsAsStarkType = false;

    public static boolean isArabicOptionalCharacter(char ch) {
        return ch >= '\u064b' && ch <= '\u0652' || ch >= '\ufc5e' && ch <= '\ufc62' || ch == '\ue818' || ch == '\u200c' || ch == '\u200d';
    }

    public static String removeOptionalCharacters(String text) {
        String string = text;
        if (BidiString.hasArabicCharacters(text)) {
            HashSet<Character> hashSet = new HashSet<Character>();
            for (int i2 = 0; i2 < text.length(); ++i2) {
                if (!BidiString.isArabicOptionalCharacter(text.charAt(i2))) continue;
                hashSet.add(Character.valueOf(text.charAt(i2)));
            }
            for (Character c2 : hashSet) {
                string = string.replaceAll("[" + c2 + "]", "");
            }
        }
        return string;
    }

    public static long getNumberOfRightChar(String text) {
        long l2 = 0L;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            if (!BidiString.isRightToLeftChar(text.charAt(i2))) continue;
            ++l2;
        }
        return l2;
    }

    public static long getNumberOfLeftChar(String text) {
        long l2 = 0L;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            if (BidiString.isRightToLeftChar(text.charAt(i2)) || BidiString.isNeutralType(text.charAt(i2))) continue;
            ++l2;
        }
        return l2;
    }

    public static long getNumberOfNeutralChar(String text) {
        long l2 = 0L;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            if (!BidiString.isNeutralType(text.charAt(i2))) continue;
            ++l2;
        }
        return l2;
    }

    public static boolean hasArabicCharacters(String text) {
        for (int i2 = 0; i2 < text.length(); ++i2) {
            if (!BidiString.a(text.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static boolean a(char c2) {
        return c2 >= '\u0600' && c2 <= '\u06ff' || c2 >= '\ufb50' && c2 <= '\ufdff' || c2 >= '\ufe70' && c2 <= '\ufeff' || c2 == '\ue818';
    }

    public static boolean hasHindiCharacters(String row_text) {
        for (int i2 = 0; i2 < row_text.length(); ++i2) {
            if (!BidiString.b(row_text.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static boolean b(char c2) {
        return c2 >= '\u0900' && c2 <= '\u097f';
    }

    public static boolean hasRightToLeftChars(String row_text) {
        for (int i2 = 0; i2 < row_text.length(); ++i2) {
            if (!BidiString.isRightToLeftChar(row_text.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isRightToLeftChar(char ch) {
        return ch >= '\u0590' && ch <= '\u06ff' || ch >= '\ufb50' && ch <= '\ufdff' || ch >= '\ufe70' && ch <= '\ufefc';
    }

    public static boolean isNeutralType(char ch) {
        return Character.isWhitespace(ch) || Character.isDigit(ch) || Character.isISOControl(ch) || BidiString.c(ch);
    }

    private static boolean c(char c2) {
        boolean bl = false;
        switch (c2) {
            case '!': 
            case '\"': 
            case '\'': 
            case ',': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '?': 
            case '\\': {
                bl = true;
            }
        }
        return bl;
    }

    public static String reorder(String content) {
        return BidiString.reorder(content, -2, false);
    }

    public static String reorderReverse(String content) {
        return BidiString.reorder(content, -2, true);
    }

    public static String reorder(String content, int direction, boolean reverse) {
        Object object;
        if (content == null || content.length() <= 1) {
            return content;
        }
        if (direction == -2 && !BidiString.hasRightToLeftChars(content)) {
            return content;
        }
        Bidi bidi = new Bidi(content, direction);
        int n2 = bidi.getRunCount();
        StringBuilder stringBuilder = new StringBuilder(content.length());
        if (n2 > 1) {
            int n3;
            object = new a[n2];
            byte[] byArray = new byte[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = bidi.getRunLevel(n3);
                object[n3] = new a(content, bidi.getRunStart(n3), bidi.getRunLimit(n3), n4 % 2 == 1);
                byArray[n3] = (byte)n4;
            }
            Bidi.reorderVisually(byArray, 0, object, 0, n2);
            for (n3 = 0; n3 < n2; ++n3) {
                ((a)object[n3]).a(stringBuilder, reverse);
            }
        } else {
            new a(content, 0, content.length(), bidi.getRunLevel(0) % 2 == 1).a(stringBuilder, reverse);
        }
        object = stringBuilder.toString();
        return object;
    }

    private static class a {
        private String a;
        private int b;
        private int c;
        private boolean d;

        public a(@Nonnull String string, int n2, int n3, boolean bl) {
            this.a = string;
            this.c = n2;
            this.b = n3;
            this.d = bl;
        }

        public void a(@Nonnull StringBuilder stringBuilder, boolean bl) {
            if (this.d) {
                if (!bl) {
                    int n2 = stringBuilder.length();
                    com.inet.shared.bidi.a.a(this.a, this.c, this.b, stringBuilder);
                    int n3 = n2;
                    for (int i2 = stringBuilder.length() - 1; n3 < i2; ++n3, --i2) {
                        char c2 = UnicodeMirroredCharsTable.getMirroredChar(stringBuilder.charAt(n3));
                        stringBuilder.setCharAt(n3, UnicodeMirroredCharsTable.getMirroredChar(stringBuilder.charAt(i2)));
                        stringBuilder.setCharAt(i2, c2);
                    }
                } else {
                    for (int i3 = this.b - 1; i3 >= this.c; --i3) {
                        char c3 = UnicodeMirroredCharsTable.getMirroredChar(this.a.charAt(i3));
                        stringBuilder.append(c3);
                    }
                }
            } else {
                stringBuilder.append(this.a, this.c, this.b);
            }
        }
    }
}

