/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.TagIndex;
import com.inet.search.index.k;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class FileSearchIndexPersistence<ID>
implements SearchIndexPersistence<ID> {
    private static final String FILENAME = "index.data";
    private static final String NEED_REINDEX = ".needReindex";
    private IndexSearchEngine<ID> a;
    private File b;

    public FileSearchIndexPersistence(File indexDir) {
        this.b = indexDir;
    }

    @Override
    public void setEngine(IndexSearchEngine<ID> engine) {
        this.a = engine;
    }

    @Override
    public TagIndex<ID> createTag(@Nonnull SearchTag searchTag) throws IOException {
        return new k<ID>(this.a, this.b, searchTag);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public void deleteTag(String tag) {
        IOFunctions.deleteDir(new File(this.b, tag));
    }

    @Override
    public boolean needReindex() {
        return this.b != null && new File(this.b, NEED_REINDEX).exists();
    }

    @Override
    public void markForReindex() throws IOException {
        if (this.b != null) {
            new File(this.b, NEED_REINDEX).createNewFile();
        }
    }

    @Override
    public Map<String, String> loadIndexAttributes() {
        Map map;
        if (this.b == null) {
            return null;
        }
        File file = new File(this.b, FILENAME);
        FastBufferedInputStream fastBufferedInputStream = new FastBufferedInputStream(new FileInputStream(file));
        try {
            map = new Json().fromJson(fastBufferedInputStream, HashMap.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fastBufferedInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return new HashMap<String, String>();
            }
        }
        ((InputStream)fastBufferedInputStream).close();
        return map;
    }

    @Override
    public void saveIndexAttributes(@Nonnull Map<String, String> props) throws IOException {
        this.b.mkdirs();
        File file = new File(this.b, FILENAME);
        try (FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream(new FileOutputStream(file));){
            new Json().toJson(props, fastBufferedOutputStream);
        }
    }

    @Override
    public String getName() {
        if (this.b != null) {
            return this.b.getName();
        }
        return null;
    }

    @Override
    public void saveOutstanding() {
        if (this.b != null) {
            k.b();
        }
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    public SearchIndexPersistence<ID> copy() throws IOException {
        File file;
        if (this.b != null) {
            this.b.mkdirs();
            file = new File(String.valueOf(this.b) + "_copy");
            new File(this.b, NEED_REINDEX).createNewFile();
            IOFunctions.deleteDir(file);
        } else {
            file = null;
        }
        return new FileSearchIndexPersistence<ID>(file);
    }

    @Override
    public void replaceWith(SearchIndexPersistence<ID> copy, Map<SearchTag, TagIndex<ID>> searchTags) throws IOException {
        if (this.b != null) {
            FileSearchIndexPersistence fileSearchIndexPersistence = (FileSearchIndexPersistence)copy;
            k.b();
            for (TagIndex<ID> tagIndex : searchTags.values()) {
                if (tagIndex.getDataType() == SearchDataType.Api) continue;
                ((k)tagIndex).a(this.b);
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                this.delete();
                try {
                    Files.move(fileSearchIndexPersistence.b.toPath(), this.b.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                    k.b();
                    try {
                        IOFunctions.deleteDir(this.b.toPath());
                    }
                    catch (IOException iOException) {
                        IndexSearchEngine.LOGGER.error(iOException);
                        System.gc();
                        System.runFinalization();
                    }
                    continue;
                }
            }
        }
    }

    @Override
    public void delete() {
        if (this.b != null) {
            IOFunctions.deleteDir(this.b);
        }
    }
}

