/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search;

import com.inet.annotations.InternalApi;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.TextSearchTokenizerWithoutNormalize;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class FuzzySearch<ID> {
    @Nonnull
    private final IndexSearchEngine<ID> a;
    @Nonnull
    private SearchCommand b;
    @Nonnull
    private final String[] c;

    public FuzzySearch(@Nonnull IndexSearchEngine<ID> engine, String ... tags) {
        this(engine, new SearchCommand(new SearchExpression[0]), tags);
    }

    public FuzzySearch(@Nonnull IndexSearchEngine<ID> engine, @Nonnull SearchCommand baseCommand, String ... tags) {
        this.a = engine;
        this.b = baseCommand;
        this.c = tags;
    }

    @Nonnull
    public List<ID> search(@Nonnull String phrase) {
        ArrayList<b> arrayList = this.a(phrase);
        ArrayList<a<ID>> arrayList2 = this.a(arrayList);
        return arrayList2.stream().map(a2 -> a2.b).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private ArrayList<b> a(@Nonnull String string) {
        ArrayList<b> arrayList = new ArrayList<b>();
        Set<String> set = TextSearchTokenizerWithoutNormalize.DEFAULT.tokens(string, 1);
        block4: for (String string2 : set) {
            switch (string2.length()) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 3: 
                case 4: {
                    String string3 = "\"" + string2 + "\"";
                    break;
                }
            }
            for (String string4 : this.c) {
                void object;
                SearchCommand searchCommand = new TextSearchCommandBuilder(this.a, string4 + ":" + (String)object).buildWithGenericLocale();
                searchCommand.getSearchExpression().addAll(0, this.b.getSearchExpression());
                Set<ID> set2 = this.a.simpleSearch(searchCommand);
                if (set2.size() <= 0) continue;
                arrayList.add(new b((String)object, set2.size(), searchCommand));
            }
        }
        arrayList.sort(null);
        return arrayList;
    }

    ArrayList<a<ID>> a(ArrayList<b> arrayList) {
        HashMap<ID, a<ID>> hashMap = new HashMap<ID, a<ID>>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            b b2 = arrayList.get(i2);
            Set<ID> set = this.a.simpleSearch(b2.c);
            float f2 = (float)b2.a.length() / (float)set.size() / (float)set.size();
            for (ID ID : set) {
                a<ID> a2 = (a<ID>)hashMap.get(ID);
                if (a2 == null) {
                    a2 = new a<ID>(ID);
                    hashMap.put(ID, a2);
                }
                a2.a(f2);
            }
            if (i2 > 10 && hashMap.size() > 1000) break;
        }
        ArrayList<a<ID>> arrayList2 = new ArrayList<a<ID>>(hashMap.values());
        arrayList2.sort(Comparator.reverseOrder());
        return arrayList2;
    }

    private static class b
    implements Comparable<b> {
        private final String a;
        private final int b;
        private final SearchCommand c;

        b(String string, int n2, SearchCommand searchCommand) {
            this.a = string;
            this.b = n2;
            this.c = searchCommand;
        }

        public int a(@Nonnull b b2) {
            return Integer.compare(this.b, b2.b);
        }

        @Override
        public /* synthetic */ int compareTo(@Nonnull Object object) {
            return this.a((b)object);
        }
    }

    private static class a<ID>
    implements Comparable<a<ID>> {
        private float a;
        private ID b;

        a(ID ID) {
            this.b = ID;
        }

        void a(float f2) {
            this.a += f2;
        }

        public int a(@Nonnull a<ID> a2) {
            return Float.compare(this.a, a2.a);
        }

        @Override
        public /* synthetic */ int compareTo(@Nonnull Object object) {
            return this.a((a)object);
        }
    }
}

