/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.image;

import com.inet.annotations.InternalApi;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;

@InternalApi
public class PreviewGenerator {
    @Nullable
    public static ImagePreview generatePreviewImage(@Nonnull Supplier<InputStream> dataProvider, @Nonnull String type, int targetSize) throws IOException {
        return PreviewGenerator.generatePreviewImage(dataProvider, type, targetSize, false);
    }

    @Nullable
    public static ImagePreview generatePreviewImage(@Nonnull Supplier<InputStream> dataProvider, @Nonnull String type, int targetSize, boolean writeAlways) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n2;
        InputStream inputStream;
        int n3;
        int n4;
        int n5;
        BufferedImage bufferedImage;
        block56: {
            bufferedImage = null;
            n5 = -1;
            n4 = -1;
            n3 = -1;
            inputStream = dataProvider.get();
            try {
                Object object4;
                if (inputStream == null) break block56;
                try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);){
                    List<String> list;
                    IIOMetadata iIOMetadata;
                    ImageReader imageReader;
                    object4 = ImageIO.getImageReaders(imageInputStream);
                    if (!object4.hasNext() || (imageReader = (ImageReader)object4.next()) == null) break block56;
                    imageReader.setInput(imageInputStream);
                    n2 = imageReader.getNumImages(true);
                    if (n2 > 0) {
                        n4 = imageReader.getWidth(0);
                        n3 = imageReader.getHeight(0);
                        bufferedImage = imageReader.read(0);
                    }
                    if ((iIOMetadata = imageReader.getImageMetadata(0)) == null || !iIOMetadata.isStandardMetadataFormatSupported() || !(list = Arrays.asList(iIOMetadata.getMetadataFormatNames())).contains("javax_imageio_jpeg_image_1.0")) break block56;
                    object3 = iIOMetadata.getAsTree("javax_imageio_jpeg_image_1.0");
                    object2 = object3.getChildNodes();
                    for (int i2 = 0; i2 < object2.getLength(); ++i2) {
                        if ("markerSequence".equals(object2.item(i2).getNodeName())) {
                            object = object2.item(i2).getChildNodes();
                            for (int i3 = 0; i3 < object.getLength(); ++i3) {
                                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)object.item(i3);
                                byte[] byArray = (byte[])iIOMetadataNode.getUserObject();
                                if (byArray == null) continue;
                                byte[] byArray2 = new byte[4];
                                ByteBuffer.wrap(byArray).get(byArray2);
                                if ("Exif".equals(new String(byArray2))) {
                                    n5 = PreviewGenerator.a(byArray);
                                }
                                if (n5 != -1) break;
                            }
                        }
                        if (n5 == -1) continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        object4 = new DataInputStream(dataProvider.get());
                        try {
                            n5 = PreviewGenerator.a((DataInputStream)object4);
                        }
                        finally {
                            ((FilterInputStream)object4).close();
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (bufferedImage == null && n4 < 0 && n3 < 0) {
            try {
                inputStream = dataProvider.get();
                try {
                    bufferedImage = ImageIO.read(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bufferedImage != null) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        }
        if (n4 > 0 && n3 > 0) {
            int n6;
            if (n5 != -1) {
                switch (n5) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n7 = n4;
                        n4 = n3;
                        n3 = n7;
                        break;
                    }
                }
            }
            boolean bl = n4 > (n6 = targetSize * 4) || n3 > n6;
            float f2 = n4 > n3 ? (float)(n4 / targetSize) : (float)(n3 / targetSize);
            float f3 = (float)n4 / (float)n3;
            if (n4 > targetSize) {
                n4 = targetSize;
                n3 = (int)Math.floor((float)targetSize / f3);
            }
            if (n3 > targetSize) {
                n3 = targetSize;
                n4 = (int)Math.floor((float)targetSize * f3);
            }
            if (bufferedImage != null && (bl || "gif".equals(type) || writeAlways)) {
                n2 = bufferedImage.getWidth();
                int n8 = bufferedImage.getHeight();
                int n9 = bufferedImage.getType();
                if (n5 != -1) {
                    object3 = new AffineTransform();
                    switch (n5) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            ((AffineTransform)object3).scale(-1.0, 1.0);
                            ((AffineTransform)object3).translate(-n2, 0.0);
                            break;
                        }
                        case 3: {
                            ((AffineTransform)object3).translate(n2, n8);
                            ((AffineTransform)object3).rotate(Math.PI);
                            break;
                        }
                        case 4: {
                            ((AffineTransform)object3).scale(1.0, -1.0);
                            ((AffineTransform)object3).translate(0.0, -n8);
                            break;
                        }
                        case 5: {
                            ((AffineTransform)object3).rotate(-1.5707963267948966);
                            ((AffineTransform)object3).scale(-1.0, 1.0);
                            break;
                        }
                        case 6: {
                            ((AffineTransform)object3).translate(n8, 0.0);
                            ((AffineTransform)object3).rotate(1.5707963267948966);
                            break;
                        }
                        case 7: {
                            ((AffineTransform)object3).scale(-1.0, 1.0);
                            ((AffineTransform)object3).translate(-n8, 0.0);
                            ((AffineTransform)object3).translate(0.0, n2);
                            ((AffineTransform)object3).rotate(4.71238898038469);
                            break;
                        }
                        case 8: {
                            ((AffineTransform)object3).translate(0.0, n2);
                            ((AffineTransform)object3).rotate(4.71238898038469);
                            break;
                        }
                    }
                    object2 = new AffineTransformOp((AffineTransform)object3, 3);
                    BufferedImage bufferedImage2 = ((AffineTransformOp)object2).createCompatibleDestImage(bufferedImage, bufferedImage.getType() == 10 ? bufferedImage.getColorModel() : null);
                    object = (Graphics2D)bufferedImage2.getGraphics();
                    ((Graphics2D)object).setTransform((AffineTransform)object3);
                    ((Graphics)object).drawImage(bufferedImage, 0, 0, null);
                    ((Graphics)object).dispose();
                    bufferedImage = bufferedImage2;
                }
                int n10 = n3 * (f2 >= 2.0f ? 2 : 1);
                int n11 = n4 * (f2 >= 2.0f ? 2 : 1);
                Image image = bufferedImage.getScaledInstance(n11, n10, 16);
                bufferedImage = new BufferedImage(n11, n10, n9 == 0 ? 2 : n9);
                object = bufferedImage.getGraphics();
                ((Graphics)object).drawImage(image, 0, 0, null);
                ((Graphics)object).dispose();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, type, byteArrayOutputStream);
                return new ImagePreview(n4, n3, type, byteArrayOutputStream);
            }
            return new ImagePreview(n4, n3, type, null);
        }
        return null;
    }

    private static int a(DataInputStream dataInputStream) throws IOException {
        for (int i2 = 0; i2 < 100; ++i2) {
            int n2 = dataInputStream.readUnsignedShort();
            if (n2 != 65505) continue;
            int n3 = dataInputStream.readUnsignedShort();
            byte[] byArray = dataInputStream.readNBytes(n3);
            return PreviewGenerator.a(byArray);
        }
        return -1;
    }

    private static int a(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBuffer.getInt() != 1165519206 || byteBuffer.getShort() != 0) {
            throw new IllegalArgumentException("Invalid EXIF Header!");
        }
        byteBuffer = byteBuffer.slice();
        switch (byteBuffer.getShort()) {
            case 18761: {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            case 19789: {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid byte order!");
            }
        }
        if (byteBuffer.getShort() != 42) {
            throw new IllegalArgumentException("Invalid TIFF Header!");
        }
        byteBuffer.position(byteBuffer.getInt());
        int n2 = byteBuffer.getShort() & 0xFFFF;
        for (int i2 = 0; i2 < n2; ++i2) {
            short s = byteBuffer.getShort();
            if (s == 274) {
                byteBuffer.position(byteBuffer.position() + 6);
                return byteBuffer.getShort() & 0xFF;
            }
            byteBuffer.position(byteBuffer.position() + 10);
        }
        return -1;
    }

    @InternalApi
    public static class ImagePreview {
        private ByteArrayOutputStream a;
        private String b;
        private int c;
        private int d;

        public ImagePreview(int width, int height, String type, ByteArrayOutputStream data) {
            this.c = width;
            this.d = height;
            this.b = type;
            this.a = data;
        }

        public int getWidth() {
            return this.c;
        }

        public int getHeight() {
            return this.d;
        }

        public boolean hasPreviewImage() {
            return this.a != null;
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException("There is no preview data to write. Check with hasPreview() first");
            }
            this.a.writeTo(out);
        }

        public byte[] getData() {
            if (this.a == null) {
                throw new IllegalStateException("There is no preview data to write. Check with hasPreview() first");
            }
            return this.a.toByteArray();
        }

        public String getType() {
            return this.b;
        }
    }
}

