/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.image;

import com.inet.annotations.InternalApi;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

@InternalApi
public class ImageScaler {
    public static ImageScalerResult scale(InputStream inputStream, int targetSize) throws IOException {
        Graphics2D graphics2D;
        BufferedImage bufferedImage;
        int n2;
        int n3;
        BufferedImage bufferedImage2 = ImageIO.read(inputStream);
        if (bufferedImage2 == null) {
            return null;
        }
        int n4 = bufferedImage2.getWidth();
        int n5 = bufferedImage2.getHeight();
        boolean bl = targetSize != n4 || targetSize != n5;
        while (true) {
            n3 = n4 / 2;
            n2 = n5 / 2;
            if (n3 < targetSize || n2 < targetSize) break;
            bufferedImage = new BufferedImage(n3, n2, 2);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, n3, n2, 0, 0, n4, n5, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage;
            n4 = n3;
            n5 = n2;
        }
        if (n4 < targetSize && n5 < targetSize) {
            n3 = targetSize * 8;
            n2 = targetSize * 8;
            if (n4 > n5) {
                var8_10 = (double)n4 / (double)n5;
                n3 = targetSize * 8;
                n2 = (int)Math.round((double)n3 / var8_10);
            } else {
                var8_10 = (double)n5 / (double)n4;
                n2 = targetSize * 8;
                n3 = (int)Math.round((double)n2 / var8_10);
            }
            bufferedImage = new BufferedImage(n3, n2, 2);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(bufferedImage2, 0, 0, n3, n2, 0, 0, n4, n5, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage;
            n4 = n3;
            n5 = n2;
        }
        if (n4 != targetSize || n5 != targetSize) {
            n3 = targetSize;
            n2 = targetSize;
            int n6 = 0;
            int n7 = 0;
            if (n4 > n5) {
                var10_14 = (double)n4 / (double)n5;
                n3 = targetSize;
                n2 = (int)Math.round((double)targetSize / var10_14);
                n6 = 0;
                n7 = (targetSize - n2) / 2;
            } else {
                var10_14 = (double)n5 / (double)n4;
                n2 = targetSize;
                n3 = (int)Math.round((double)targetSize / var10_14);
                n6 = (targetSize - n3) / 2;
                n7 = 0;
            }
            BufferedImage bufferedImage3 = new BufferedImage(targetSize, targetSize, 2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage3.getGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D2.drawImage(bufferedImage2, n6, n7, n6 + n3, n7 + n2, 0, 0, n4, n5, null);
            graphics2D2.dispose();
            bufferedImage2 = bufferedImage3;
            n4 = targetSize;
            n5 = targetSize;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "PNG", byteArrayOutputStream);
        return new ImageScalerResult(byteArrayOutputStream.toByteArray(), bl);
    }

    @InternalApi
    public static class ImageScalerResult {
        private byte[] a;
        private boolean b;

        public ImageScalerResult(byte[] imageData, boolean scaled) {
            this.a = imageData;
            this.b = scaled;
        }

        public byte[] getImageData() {
            return this.a;
        }

        public boolean isScaled() {
            return this.b;
        }
    }
}

