/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence;

import com.inet.error.ErrorCode;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.PersistenceStorageResolver;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.StorageResolver;
import com.inet.persistence.file.FileRandomAccessRead;
import com.inet.plugin.ServerPluginManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public abstract class StorageEntry {
    private static final HashMap<String, StorageResolver> a = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageEntry resolve(URL location) {
        Object object;
        Object object2;
        if (location == null) {
            return null;
        }
        if (a.isEmpty()) {
            object2 = a;
            synchronized (object2) {
                if (a.isEmpty()) {
                    object = ServerPluginManager.getInstance().get(StorageResolver.class);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        StorageResolver storageResolver = (StorageResolver)iterator.next();
                        a.put(storageResolver.getExtensionName(), storageResolver);
                    }
                    StorageEntry.a(new PersistenceStorageResolver());
                    StorageEntry.a(new b());
                }
            }
        }
        if ((object = a.get(object2 = location.getProtocol())) == null) {
            return null;
        }
        return object.resolve(location);
    }

    private static void a(StorageResolver storageResolver) {
        a.put(storageResolver.getExtensionName(), storageResolver);
    }

    @Nonnull
    public abstract String getPath();

    @Nonnull
    public abstract String getName();

    @Nullable
    public abstract StorageEntry getParent();

    @Nullable
    public abstract RandomAccessRead getRandomAccessRead();

    public abstract boolean exists();

    @Nonnull
    public abstract List<? extends StorageEntry> getChildren();

    @Nullable
    public abstract InputStream getInputStream();

    public abstract long size();

    @Nonnull
    public abstract URL toURL();

    public abstract void deleteTree();

    public abstract long lastModified();

    private static class b
    implements StorageResolver {
        private b() {
        }

        @Override
        public String getExtensionName() {
            return "file";
        }

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Abstraction layer for scenarios where otherwise File would be used directly. Secured by permission checks as well.")
        public StorageEntry resolve(URL url) {
            File file;
            if (!SystemPermissionChecker.checkHostingAccess(Permission.CONFIGURATION)) {
                return null;
            }
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            return new a(file);
        }
    }

    private static class a
    extends StorageEntry {
        private File a;

        public a(File file) {
            this.a = file;
        }

        @Override
        @Nonnull
        public URL toURL() {
            try {
                return this.a.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorCode.throwAny(malformedURLException);
                return null;
            }
        }

        @Override
        public void deleteTree() {
            IOFunctions.deleteDir(this.a);
        }

        @Override
        public boolean exists() {
            return this.a.exists();
        }

        @Override
        public InputStream getInputStream() {
            if (this.a.isFile()) {
                try {
                    return new FastBufferedInputStream(new FileInputStream(this.a));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public String getName() {
            return this.a.getName();
        }

        @Override
        public List<? extends StorageEntry> getChildren() {
            ArrayList<a> arrayList = new ArrayList<a>();
            File[] fileArray = this.a.listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    try {
                        arrayList.add(new a(file));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return arrayList;
        }

        @Override
        public StorageEntry getParent() {
            File file = this.a.getParentFile();
            return file != null ? new a(file) : null;
        }

        @Override
        public String getPath() {
            return this.a.getPath();
        }

        @Override
        public RandomAccessRead getRandomAccessRead() {
            try {
                return new FileRandomAccessRead(this.a);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        @Override
        public long lastModified() {
            return this.a.lastModified();
        }

        @Override
        public long size() {
            return this.a.isFile() ? this.a.length() : 0L;
        }
    }
}

