/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notification;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.logging.LogManager;
import com.inet.notification.NotificationGenerator;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ThreadUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@InternalApi
public class NotificationGeneratorCache {
    private Map<GUID, Set<GUID>> a = new HashMap<GUID, Set<GUID>>();
    private Map<GUID, Set<GUID>> b = new HashMap<GUID, Set<GUID>>();
    private Map<GUID, String> c = new HashMap<GUID, String>();
    private PersistenceEntry d = Persistence.getInstance().resolve("notificationgeneratorcache");

    public NotificationGeneratorCache() {
        this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeneratorEvaluated(GUID generatorID, Set<GUID> userIDs, DispatcherType dispatcherType) {
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore(generatorID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                Map<GUID, Set<GUID>> map = this.a(dispatcherType, generatorID);
                Set<GUID> set = map.get(generatorID);
                if (set == null) {
                    set = new HashSet<GUID>();
                    map.put(generatorID, set);
                }
                set.addAll(userIDs);
                this.a(generatorID, map, dispatcherType);
            }
        }
    }

    private Map<GUID, Set<GUID>> a(DispatcherType dispatcherType, GUID gUID) {
        Map<GUID, Set<GUID>> map;
        Map<GUID, Set<GUID>> map2 = map = dispatcherType == DispatcherType.web ? this.b : this.a;
        if (!map.containsKey(gUID)) {
            map.put(gUID, this.b(dispatcherType, gUID));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGeneratorCache(GUID generatorID) {
        try (Object object = ThreadUtils.getSemaphore(generatorID);){
            ThreadUtils.Semaphore semaphore = object;
            synchronized (semaphore) {
                for (DispatcherType dispatcherType : DispatcherType.values()) {
                    Map<GUID, Set<GUID>> map = this.a(dispatcherType, generatorID);
                    if (map.remove(generatorID) == null) continue;
                    this.a(generatorID, map, dispatcherType);
                }
            }
        }
        object = this.c;
        synchronized (object) {
            if (this.c.remove(generatorID) != null) {
                this.b();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEvaluated(NotificationGenerator generator, GUID userID, DispatcherType dispatcherType) {
        GUID gUID = generator.getId();
        String string = generator.getPeriodKey();
        if (!Objects.equals(this.c.get(gUID), string)) {
            this.clearGeneratorCache(gUID);
            Map<GUID, String> map = this.c;
            synchronized (map) {
                this.c.put(gUID, string);
                this.b();
            }
            return false;
        }
        return this.isUserEvaluatedForGeneratorId(gUID, userID, dispatcherType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserEvaluatedForGeneratorId(GUID generatorID, GUID userID, DispatcherType dispatcherType) {
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore(generatorID);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                Set<GUID> set = this.a(dispatcherType, generatorID).get(generatorID);
                if (set == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = set.contains(userID);
                return bl;
            }
        }
    }

    private Set<GUID> b(DispatcherType dispatcherType, GUID gUID) {
        PersistenceEntry persistenceEntry = this.d.resolve(gUID.toString() + "." + dispatcherType.name());
        if (!persistenceEntry.exists()) {
            return new HashSet<GUID>();
        }
        try {
            return (Set)new Json().fromJson(persistenceEntry.getString(), (Type)new JsonParameterizedType((Type)((Object)HashSet.class), new Type[]{GUID.class}));
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error("Found corrupt '" + gUID.toString() + "." + dispatcherType.name() + "' file. Will be ignored. Some notifications may be sent again.");
            return new HashSet<GUID>();
        }
    }

    private void a() {
        PersistenceEntry persistenceEntry = this.d.resolve("generatorperiods.keys");
        if (persistenceEntry.exists()) {
            try {
                this.c.putAll((Map)new Json().fromJson(persistenceEntry.getString(), (Type)new JsonParameterizedType((Type)((Object)HashMap.class), new Type[]{GUID.class, String.class})));
            }
            catch (Throwable throwable) {
                LogManager.getApplicationLogger().error("Found corrupt 'generatorperiods.keys' file. Will be ignored. Some notifications may be sent again.");
            }
        }
    }

    private void b() {
        PersistenceEntry persistenceEntry = this.d.resolve("generatorperiods.keys");
        persistenceEntry.setString(new Json().toJson(this.c));
    }

    private void a(GUID gUID, Map<GUID, Set<GUID>> map, DispatcherType dispatcherType) {
        PersistenceEntry persistenceEntry = this.d.resolve(gUID.toString() + "." + dispatcherType.name());
        Set<GUID> set = map.get(gUID);
        if (set == null) {
            if (persistenceEntry.exists()) {
                persistenceEntry.deleteTree();
            }
            return;
        }
        persistenceEntry.setString(new Json().toJson(set));
    }

    @InternalApi
    public static final class DispatcherType
    extends Enum<DispatcherType> {
        public static final /* enum */ DispatcherType web = new DispatcherType();
        public static final /* enum */ DispatcherType external = new DispatcherType();
        private static final /* synthetic */ DispatcherType[] a;

        public static DispatcherType[] values() {
            return (DispatcherType[])a.clone();
        }

        public static DispatcherType valueOf(String name) {
            return Enum.valueOf(DispatcherType.class, name);
        }

        private static /* synthetic */ DispatcherType[] a() {
            return new DispatcherType[]{web, external};
        }

        static {
            a = DispatcherType.a();
        }
    }
}

