/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notification;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.NotificationGeneratorPeriod;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public abstract class NotificationGenerator
implements NotificationGeneratorPeriod {
    @Nonnull
    public abstract GUID getId();

    public abstract String getGroupingKey();

    public abstract boolean isForCurrentUser();

    @Nonnull
    public abstract Notification createNotification();

    @Nonnull
    Set<GUID> filterUserIdsByGroupingKey() {
        String string = this.getGroupingKey();
        if (string == null) {
            string = "system";
        }
        SearchCommand searchCommand = new SearchCommand(UsersAndGroups.FIELD_NOTIFICATIONSETTINGS.getKey(), SearchCondition.SearchTermOperator.Equals, string);
        ServerPluginManager.getInstance().waitOnInitState(60);
        Set<GUID> set = UserManager.getInstance().getSearchEngine().simpleSearch(searchCommand);
        set.addAll(WebSocketEventHandler.getInstance().getAllConnectedUserIDs());
        return set;
    }

    @Nullable
    public abstract Set<GUID> getTargetUserIds(@Nonnull Set<GUID> var1);
}

