/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import java.io.ByteArrayOutputStream;

public class MDNSOutputStream
extends ByteArrayOutputStream {
    public void writeShort(int value) {
        this.write(value >> 8);
        this.write(value);
    }

    public void writeInt(int value) {
        this.writeShort(value >> 16);
        this.writeShort(value);
    }

    public void writeLengthAndUTF(String str, int off, int len) {
        char c2;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < len; ++n2) {
            c2 = str.charAt(off + n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        this.write(n3);
        for (n2 = 0; n2 < len; ++n2) {
            c2 = str.charAt(off + n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                this.write(c2);
                continue;
            }
            if (c2 > '\u07ff') {
                this.write(0xE0 | c2 >> 12 & 0xF);
                this.write(0x80 | c2 >> 6 & 0x3F);
                this.write(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c2 >> 6 & 0x1F);
            this.write(0x80 | c2 >> 0 & 0x3F);
        }
    }

    public void writeName(String name) {
        String string = name;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(46)) < 0) {
                n2 = string.length();
            }
            if (n2 <= 0) {
                this.write(0);
                return;
            }
            String string2 = string.substring(0, n2);
            this.writeLengthAndUTF(string2, 0, string2.length());
            if (!(string = string.substring(n2)).startsWith(".")) continue;
            string = string.substring(1);
        }
    }
}

