/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.markdown;

import com.inet.lib.json.FastStringReader;
import com.inet.lib.markdown.CellMarkDownToken;
import com.inet.lib.markdown.LinkMarkDownToken;
import com.inet.lib.markdown.MarkDownExtension;
import com.inet.lib.markdown.MarkDownParserOptions;
import com.inet.lib.markdown.MarkDownToken;
import com.inet.lib.markdown.MarkDownTokenType;
import com.inet.lib.markdown.parser.MarkDownParser;
import com.inet.lib.util.StringFunctions;
import java.io.Reader;
import java.util.List;
import javax.annotation.Nonnull;

public class MarkDown2Html {
    @Nonnull
    private final MarkDownParserOptions a = new MarkDownParserOptions();
    private String b;
    private boolean c;

    public MarkDown2Html extension(MarkDownExtension extension) {
        this.a.setExtension(extension);
        return this;
    }

    public MarkDown2Html emptyLine(boolean enable) {
        this.a.setEmptyLine(enable);
        return this;
    }

    public MarkDown2Html scanForHyperlinks(boolean enable) {
        this.a.setScanForHyperlinks(enable);
        return this;
    }

    public MarkDown2Html blankTarget(boolean enable) {
        this.b = enable ? "_blank" : null;
        return this;
    }

    public MarkDown2Html hardbreak(boolean enable) {
        this.c = enable;
        return this;
    }

    public String convert(String markdown) {
        if (StringFunctions.isEmpty(markdown)) {
            return markdown;
        }
        return this.convert(new FastStringReader(markdown));
    }

    public String convert(@Nonnull Reader markdown) {
        List<MarkDownToken> list = new MarkDownParser(markdown, this.a).tokenize();
        return this.convert(list);
    }

    public String convert(@Nonnull List<MarkDownToken> tokens) {
        MarkDownExtension markDownExtension = this.a.getExtension();
        Object object = this.b;
        object = object != null ? " target=\"" + (String)object + "\"" : "";
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        block59: for (MarkDownToken markDownToken : tokens) {
            if (markDownExtension != null && markDownExtension.format(markDownToken, stringBuilder)) continue;
            if (bl) {
                bl = false;
            } else {
                switch (markDownToken.getType()) {
                    case Paragraph: 
                    case OrderedList: 
                    case BulletList: 
                    case PreCode: 
                    case Heading1: 
                    case Heading2: 
                    case Heading3: 
                    case Heading4: 
                    case Heading5: 
                    case Heading6: 
                    case HR: 
                    case Table: {
                        stringBuilder.append('\n');
                    }
                }
            }
            switch (markDownToken.getType()) {
                case Text: {
                    stringBuilder.append(StringFunctions.encodeHTML(markDownToken.toString(), false));
                    continue block59;
                }
                case Hyperlink: {
                    LinkMarkDownToken linkMarkDownToken = (LinkMarkDownToken)markDownToken;
                    stringBuilder.append("<a href=\"").append(StringFunctions.encodeHTML(markDownToken.toString())).append('\"').append((String)object);
                    if (linkMarkDownToken.getTitle() != null) {
                        stringBuilder.append(" title=\"").append(StringFunctions.encodeHTML(linkMarkDownToken.getTitle())).append('\"');
                    }
                    stringBuilder.append('>');
                    continue block59;
                }
                case Image: {
                    LinkMarkDownToken linkMarkDownToken = (LinkMarkDownToken)markDownToken;
                    stringBuilder.append("<img src=\"").append(StringFunctions.encodeHTML(linkMarkDownToken.toString())).append("\" alt=\"").append(StringFunctions.encodeHTML(linkMarkDownToken.getAlt())).append("\"");
                    if (linkMarkDownToken.getTitle() != null) {
                        stringBuilder.append(" title=\"").append(StringFunctions.encodeHTML(linkMarkDownToken.getTitle())).append('\"');
                    }
                    stringBuilder.append(" />");
                    continue block59;
                }
                case HyperlinkClose: {
                    stringBuilder.append("</a>");
                    continue block59;
                }
                case Italic: {
                    stringBuilder.append("<em>");
                    continue block59;
                }
                case ItalicClose: {
                    stringBuilder.append("</em>");
                    continue block59;
                }
                case Bold: {
                    stringBuilder.append("<strong>");
                    continue block59;
                }
                case BoldClose: {
                    stringBuilder.append("</strong>");
                    continue block59;
                }
                case Underline: {
                    stringBuilder.append("<u>");
                    continue block59;
                }
                case UnderlineClose: {
                    stringBuilder.append("</u>");
                    continue block59;
                }
                case Strikethrough: {
                    stringBuilder.append("<s>");
                    continue block59;
                }
                case StrikethroughClose: {
                    stringBuilder.append("</s>");
                    continue block59;
                }
                case HardBreak: {
                    stringBuilder.append("<br />\n");
                    bl = true;
                    continue block59;
                }
                case SoftBreak: {
                    if (this.c) {
                        stringBuilder.append("<br />\n");
                    } else {
                        stringBuilder.append("\n");
                    }
                    bl = true;
                    continue block59;
                }
                case Paragraph: {
                    stringBuilder.append("<p>");
                    continue block59;
                }
                case ParagraphClose: {
                    stringBuilder.append("</p>\n");
                    bl = true;
                    continue block59;
                }
                case Heading1: {
                    stringBuilder.append("<h1>");
                    continue block59;
                }
                case Heading1Close: {
                    stringBuilder.append("</h1>\n");
                    bl = true;
                    continue block59;
                }
                case Heading2: {
                    stringBuilder.append("<h2>");
                    continue block59;
                }
                case Heading2Close: {
                    stringBuilder.append("</h2>\n");
                    bl = true;
                    continue block59;
                }
                case Heading3: {
                    stringBuilder.append("<h3>");
                    continue block59;
                }
                case Heading3Close: {
                    stringBuilder.append("</h3>\n");
                    bl = true;
                    continue block59;
                }
                case Heading4: {
                    stringBuilder.append("<h4>");
                    continue block59;
                }
                case Heading4Close: {
                    stringBuilder.append("</h4>\n");
                    bl = true;
                    continue block59;
                }
                case Heading5: {
                    stringBuilder.append("<h5>");
                    continue block59;
                }
                case Heading5Close: {
                    stringBuilder.append("</h5>\n");
                    bl = true;
                    continue block59;
                }
                case Heading6: {
                    stringBuilder.append("<h6>");
                    continue block59;
                }
                case Heading6Close: {
                    stringBuilder.append("</h6>\n");
                    bl = true;
                    continue block59;
                }
                case Code: {
                    stringBuilder.append("<code>");
                    continue block59;
                }
                case CodeClose: {
                    stringBuilder.append("</code>");
                    continue block59;
                }
                case PreCode: {
                    if (markDownToken == MarkDownTokenType.PreCode) {
                        stringBuilder.append("<pre><code>");
                        continue block59;
                    }
                    stringBuilder.append("<pre><code class=\"language-").append(StringFunctions.encodeHTML(markDownToken.toString())).append("\">");
                    continue block59;
                }
                case Blockquote: {
                    stringBuilder.append("<blockquote>\n");
                    bl = true;
                    continue block59;
                }
                case BlockquoteClose: {
                    stringBuilder.append("</blockquote>\n");
                    bl = true;
                    continue block59;
                }
                case PreCodeClose: {
                    if (stringBuilder.charAt(stringBuilder.length() - 1) != '>') {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("</code></pre>\n");
                    bl = true;
                    continue block59;
                }
                case BulletList: {
                    stringBuilder.append("<ul>\n");
                    bl = true;
                    continue block59;
                }
                case BulletListClose: {
                    stringBuilder.append("</ul>\n");
                    bl = true;
                    continue block59;
                }
                case OrderedList: {
                    int n2;
                    Object object2;
                    try {
                        object2 = markDownToken.getReplaceText().trim();
                        n2 = Integer.parseInt((CharSequence)object2, 0, ((String)object2).length() - 1, 10);
                    }
                    catch (Exception exception) {
                        n2 = 1;
                    }
                    if (n2 == 1) {
                        stringBuilder.append("<ol>\n");
                        bl = true;
                        continue block59;
                    }
                    stringBuilder.append("<ol start=\"").append(n2).append("\">\n");
                    continue block59;
                }
                case OrderedListClose: {
                    stringBuilder.append("</ol>\n");
                    bl = true;
                    continue block59;
                }
                case ListItem: {
                    stringBuilder.append("<li>");
                    continue block59;
                }
                case ListItemClose: {
                    stringBuilder.append("</li>\n");
                    bl = true;
                    continue block59;
                }
                case HR: {
                    stringBuilder.append("<hr />\n");
                    bl = true;
                    continue block59;
                }
                case Table: {
                    stringBuilder.append("<table>\n");
                    bl = true;
                    continue block59;
                }
                case TableClose: {
                    stringBuilder.append("</table>\n");
                    bl = true;
                    continue block59;
                }
                case Thead: {
                    stringBuilder.append("<thead>\n");
                    bl = true;
                    continue block59;
                }
                case TheadClose: {
                    stringBuilder.append("</thead>\n");
                    bl = true;
                    continue block59;
                }
                case Tbody: {
                    stringBuilder.append("<tbody>\n");
                    bl = true;
                    continue block59;
                }
                case TbodyClose: {
                    stringBuilder.append("</tbody>\n");
                    bl = true;
                    continue block59;
                }
                case Tr: {
                    stringBuilder.append("<tr>\n");
                    bl = true;
                    continue block59;
                }
                case TrClose: {
                    stringBuilder.append("</tr>\n");
                    bl = true;
                    continue block59;
                }
                case Th: 
                case Td: {
                    stringBuilder.append(markDownToken.getType() == MarkDownTokenType.Th ? "<th" : "<td");
                    Object object2 = (CellMarkDownToken)markDownToken;
                    CellMarkDownToken.Align align = ((CellMarkDownToken)object2).getAlign();
                    if (align != CellMarkDownToken.Align.Default) {
                        stringBuilder.append(" align=\"").append((Object)align).append('\"');
                    }
                    stringBuilder.append('>');
                    continue block59;
                }
                case ThClose: {
                    stringBuilder.append("</th>\n");
                    bl = true;
                    continue block59;
                }
                case TdClose: {
                    stringBuilder.append("</td>\n");
                    bl = true;
                    continue block59;
                }
            }
            throw new Error(markDownToken.getType().toString());
        }
        return stringBuilder.toString();
    }
}

