/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.ico;

import com.inet.lib.ico.BMPDecoder;
import com.inet.lib.ico.LittleEndianInputStream;
import com.inet.lib.ico.a;
import com.inet.lib.ico.b;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ICODecoder {
    private static final int PNG_MAGIC = -1991225785;
    private static final int PNG_MAGIC_LE = 1196314761;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int PNG_MAGIC2_LE = 169478669;

    private ICODecoder() {
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    public static List<BufferedImage> read(URL url) throws IOException {
        return ICODecoder.read(url.openStream());
    }

    public static List<BufferedImage> read(InputStream is) throws IOException {
        int n2;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(is);
        littleEndianInputStream.readShortLE();
        littleEndianInputStream.readShortLE();
        int n3 = littleEndianInputStream.readShortLE();
        a[] aArray = new a[n3];
        for (n2 = 0; n2 < n3; n2 = (short)(n2 + 1)) {
            aArray[n2] = new a(littleEndianInputStream);
        }
        n2 = 0;
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(n3);
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                Object[] objectArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                int n4 = littleEndianInputStream.readIntLE();
                if (n4 == 40) {
                    b b2 = new b(littleEndianInputStream, n4);
                    object4 = b2;
                    object3 = new b((b)object4);
                    ((b)object3).c = ((b)object4).c / 2;
                    b b3 = new b((b)object4);
                    b3.c = ((b)object3).c;
                    ((b)object3).e = 1;
                    ((b)object3).l = 2;
                    object2 = BMPDecoder.read(b3, littleEndianInputStream);
                    object = new BufferedImage(b3.b, b3.c, 2);
                    objectArray = new Color[]{new Color(255, 255, 255), new Color(0, 0, 0)};
                    if (((b)object4).e == 32) {
                        int n5 = aArray[n2].g;
                        int n6 = ((b)object4).a;
                        int n7 = b3.b * b3.c * 4;
                        var17_26 = n5 - n6 - n7;
                        var18_28 = littleEndianInputStream.skipBytes(var17_26);
                        var19_29 = var17_26;
                        while (var18_28 < var19_29) {
                            if (var18_28 < 0) {
                                throw new IOException("Failed to read [skip]");
                            }
                            var19_29 = var17_26 - var18_28;
                            var18_28 = littleEndianInputStream.skipBytes(var19_29);
                        }
                        WritableRaster writableRaster = ((BufferedImage)object2).getRaster();
                        WritableRaster writableRaster2 = ((BufferedImage)object2).getAlphaRaster();
                        WritableRaster writableRaster3 = ((BufferedImage)object).getRaster();
                        WritableRaster writableRaster4 = ((BufferedImage)object).getAlphaRaster();
                        for (int i2 = b3.c - 1; i2 >= 0; --i2) {
                            for (int i3 = 0; i3 < b3.b; ++i3) {
                                int n8 = writableRaster.getSample(i3, i2, 0);
                                int n9 = writableRaster.getSample(i3, i2, 1);
                                int n10 = writableRaster.getSample(i3, i2, 2);
                                int n11 = writableRaster2.getSample(i3, i2, 0);
                                writableRaster3.setSample(i3, i2, 0, n8);
                                writableRaster3.setSample(i3, i2, 1, n9);
                                writableRaster3.setSample(i3, i2, 2, n10);
                                writableRaster4.setSample(i3, i2, 0, n11);
                            }
                        }
                    } else {
                        BufferedImage bufferedImage = BMPDecoder.read((b)object3, littleEndianInputStream, (Color[])objectArray);
                        WritableRaster writableRaster = ((BufferedImage)object).getRaster();
                        WritableRaster writableRaster5 = ((BufferedImage)object).getAlphaRaster();
                        for (var17_26 = 0; var17_26 < b3.c; ++var17_26) {
                            for (var18_28 = 0; var18_28 < b3.b; ++var18_28) {
                                int n12 = ((BufferedImage)object2).getRGB(var18_28, var17_26);
                                var19_29 = n12 >> 16 & 0xFF;
                                int n13 = n12 >> 8 & 0xFF;
                                int n14 = n12 & 0xFF;
                                writableRaster.setSample(var18_28, var17_26, 0, var19_29);
                                writableRaster.setSample(var18_28, var17_26, 1, n13);
                                writableRaster.setSample(var18_28, var17_26, 2, n14);
                                int n15 = bufferedImage.getRGB(var18_28, var17_26);
                                writableRaster5.setSample(var18_28, var17_26, 0, n15);
                            }
                        }
                    }
                    arrayList.add((BufferedImage)object);
                    continue;
                }
                if (n4 == 1196314761) {
                    int n16 = littleEndianInputStream.readIntLE();
                    if (n16 != 169478669) {
                        throw new IOException("Unrecognized icon format for image #" + n2);
                    }
                    object4 = aArray[n2];
                    object3 = new byte[((a)object4).g - 8];
                    int n17 = littleEndianInputStream.read((byte[])object3);
                    if (n17 != ((Object)object3).length) {
                        throw new IOException("Unable to read image #" + n2 + " - incomplete PNG compressed data");
                    }
                    object2 = new ByteArrayOutputStream();
                    object = new DataOutputStream((OutputStream)object2);
                    ((DataOutputStream)object).writeInt(-1991225785);
                    ((DataOutputStream)object).writeInt(218765834);
                    ((FilterOutputStream)object).write((byte[])object3);
                    objectArray = ((ByteArrayOutputStream)object2).toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])objectArray);
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    ImageReader imageReader = ICODecoder.a();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    arrayList.add(bufferedImage);
                    continue;
                }
                throw new IOException("Unrecognized icon format for image #" + n2);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read image # " + n2);
        }
        return arrayList;
    }

    private static ImageReader a() {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("png");
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }
}

