/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.websocket;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.websocket.WebSocketEndpoint;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebSocketServlet;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.EncodedWriter;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.thread.EventDispatcher;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.Session;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class WebsocketConnection {
    private static final ForkJoinPool a = new ForkJoinPool(Math.max(8, Runtime.getRuntime().availableProcessors() - 1));
    private Session b;
    private HttpSession c;
    @Nonnull
    private final String d;
    private final List<Closeable> e = new ArrayList<Closeable>();
    private ArrayList<WebSocketEventData> f;
    private long g;
    private DefaultTimerTask h;
    private EventDispatcher<?> i = new EventDispatcher(false, false, a, 5000L);

    public WebsocketConnection(Session session, @Nonnull String pollingID) {
        this.b = session;
        this.d = pollingID;
    }

    public WebsocketConnection(HttpSession httpSession, final @Nonnull String pollingID) {
        this.c = httpSession;
        this.d = pollingID;
        this.f = new ArrayList();
        this.a();
        this.h = new DefaultTimerTask(){

            @Override
            public void runImpl() throws Throwable {
                if (WebsocketConnection.this.g + 10000L < System.currentTimeMillis()) {
                    if (WebSocketServlet.LOGGER.isInfo()) {
                        WebSocketServlet.LOGGER.info("No fallback polling in the last 10 seconds. Client '" + pollingID + "' seems to be away. Closing connection.");
                    }
                    WebSocketEventHandler webSocketEventHandler = WebSocketEventHandler.getInstance();
                    webSocketEventHandler.connectionClosed(pollingID, WebsocketConnection.this);
                    this.cancel();
                }
            }
        };
        DefaultTimer.getInstance().schedule(this.h, 5000L, 5000L);
    }

    @Nonnull
    public String getPollingID() {
        return this.d;
    }

    public Session getSession() {
        return this.b;
    }

    public HttpSession getHttpSession() {
        return this.c;
    }

    public HttpSession getActiveHttpSession() {
        HttpSession httpSession = this.c;
        if (httpSession == null && this.b != null) {
            httpSession = (HttpSession)this.b.getUserProperties().get(HttpSession.class.getName());
        }
        if (httpSession != null) {
            try {
                httpSession.getCreationTime();
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return httpSession;
    }

    @Nullable
    ArrayList<WebSocketEventData> a() {
        this.g = System.currentTimeMillis();
        return this.f;
    }

    public void sendEvent(String eventName, Object data) {
        Object object;
        Object object2;
        Object object3;
        if (WebSocketServlet.LOGGER.isInfo() && (object3 = this.getSession()) != null) {
            object2 = this.getActiveHttpSession();
            object = object3.getRequestURI();
            String string = String.valueOf(object2.getAttribute("RemoteAddr")) + " \"WSOUT " + eventName + "@" + ((URI)object).getPath() + " " + ((URI)object).getScheme().toUpperCase() + "/" + this.getSession().getProtocolVersion() + "\" -1 -1 \"" + this.getPollingID() + "\" \"" + String.valueOf(object2.getAttribute("user-agent")) + "\"";
            WebSocketServlet.LOGGER.info(string);
        }
        object3 = new WebSocketEventData(eventName, data);
        object2 = new FastByteArrayOutputStream();
        try {
            object = new EncodedWriter((OutputStream)object2);
            try {
                new Json().toJson(object3, (Appendable)object);
            }
            finally {
                ((EncodedWriter)object).close();
            }
        }
        catch (IOException iOException) {
            WebSocketServlet.LOGGER.error(iOException);
            this.sendEvent("error", StringFunctions.getUserFriendlyErrorMessage(iOException));
            return;
        }
        object = ByteBuffer.wrap(((FastByteArrayOutputStream)object2).toByteArray());
        object2 = null;
        this.i.dispatchEvent(new Runnable(){
            final /* synthetic */ ByteBuffer a;
            final /* synthetic */ WebSocketEventData b;
            final /* synthetic */ String c;
            {
                this.a = byteBuffer;
                this.b = webSocketEventData;
                this.c = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                if (WebsocketConnection.this.b != null && WebsocketConnection.this.b.isOpen()) {
                    try {
                        WebsocketConnection.this.b.getBasicRemote().sendBinary(this.a);
                        return;
                    }
                    catch (IOException iOException) {
                        WebSocketServlet.LOGGER.debug(iOException);
                    }
                }
                if (WebsocketConnection.this.f == null) {
                    object = this;
                    synchronized (object) {
                        if (WebsocketConnection.this.f == null) {
                            WebsocketConnection.this.f = new ArrayList();
                        }
                    }
                }
                object = WebsocketConnection.this.f;
                synchronized (object) {
                    WebsocketConnection.this.f.add(this.b);
                }
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(this.c + " - " + WebsocketConnection.this.d);
                HttpSession httpSession = WebsocketConnection.this.getActiveHttpSession();
                if (httpSession != null) {
                    LoginProcessor loginProcessor = LoginManager.getLoginProcessor(httpSession);
                    if (loginProcessor != null) {
                        stringBuilder.append(" - ").append(loginProcessor.getLoginID());
                        stringBuilder.append(" - ").append(String.valueOf(loginProcessor.getUserAccountID()));
                    }
                    stringBuilder.append(" - ").append(httpSession.getAttribute("user-agent"));
                }
                return stringBuilder.toString();
            }
        });
    }

    public void setSessionLocale() {
        Object object;
        if (this.b != null) {
            Locale locale = WebSocketEndpoint.getLocaleFromSession(this.b);
            ClientLocale.setThreadLocale(locale);
        } else if (this.c != null && (object = this.c.getAttribute(Locale.class.getName())) instanceof Locale) {
            ClientLocale.setThreadLocale((Locale)object);
        }
    }

    public void setSessionTimeZone() {
        Object object;
        if (this.b != null) {
            TimeZone timeZone = WebSocketEndpoint.getTimeZoneFromSession(this.b);
            ClientTimezone.setTimeZone(timeZone);
        } else if (this.c != null && (object = this.c.getAttribute(TimeZone.class.getName())) instanceof TimeZone) {
            ClientTimezone.setTimeZone((TimeZone)object);
        }
    }

    void b() {
        if (this.h != null) {
            this.h.cancel();
        }
        if (this.b != null && this.b.isOpen()) {
            try {
                this.b.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Closeable closeable : this.e) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    void a(Closeable closeable) {
        this.e.add(closeable);
    }

    void b(Closeable closeable) {
        this.e.remove(closeable);
    }
}

