/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics.encode;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.logging.LogManager;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

@InternalApi
public class PNGEncoder {
    public static byte[] getPNGImageData(Image img) {
        ImageObserver imageObserver = null;
        return PNGEncoder.getPNGImageData(img, img.getWidth(imageObserver), img.getHeight(imageObserver), imageObserver);
    }

    public static byte[] getPNGImageData(Image img, int imageWidth, int imageHeight, ImageObserver _observer) {
        Object object;
        if (imageHeight == img.getHeight(_observer) && imageWidth == img.getWidth(_observer) && img instanceof RenderedImage && (object = (Object)PNGEncoder.getPNGImageData((RenderedImage)((Object)img))) != null) {
            return object;
        }
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 6);
        object = bufferedImage;
        bufferedImage.getGraphics().drawImage(img, 0, 0, imageWidth, imageHeight, _observer);
        bufferedImage.flush();
        return PNGEncoder.getPNGImageData((RenderedImage)object);
    }

    public static byte[] getPNGImageData(RenderedImage renderedImg) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        try {
            boolean bl = ImageIO.write(renderedImg, "png", fastByteArrayOutputStream);
            if (!bl) {
                return null;
            }
        }
        catch (IOException iOException) {
            if (LogManager.getApplicationLogger().isDebug()) {
                LogManager.getApplicationLogger().debug(iOException);
            }
            return null;
        }
        return fastByteArrayOutputStream.toByteArray();
    }
}

