/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics;

import com.inet.annotations.InternalApi;
import com.inet.font.FontPool;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Stack;

@InternalApi
public abstract class GraphicsBase
extends LayerGraphics2D
implements Cloneable {
    private static final Shape a = new Rectangle(0, 0, 0, 0);
    private static final Color b = Color.BLACK;
    private static final Font c = new Font("SansSerif", 0, 12);
    private Stack<GraphicsBase> d = new Stack();
    private Color e;
    private Composite f = AlphaComposite.SrcOver;
    private Paint g = b;
    private RenderingHints h = new RenderingHints(null);
    private Shape i;
    private Shape j;
    private Shape k;
    private Shape l;
    private Font m = c;
    private Stroke n = new BasicStroke(1.0f);
    private AffineTransform o = new AffineTransform();
    private Color p = b;
    private FontMetrics q;
    private boolean r;
    private boolean s = true;
    private boolean t = true;
    private boolean u = true;
    private boolean v = true;

    private GraphicsBase a() {
        if (this.d.isEmpty()) {
            return this;
        }
        return this.d.peek();
    }

    @Override
    public void finalize() {
    }

    @Override
    public Color getBackground() {
        return this.a().e;
    }

    @Override
    public void setBackground(Color color) {
        this.a().e = color;
        this.setPaintChanged();
    }

    @Override
    public Composite getComposite() {
        return this.a().f;
    }

    @Override
    public void setComposite(Composite comp) {
        this.a().f = comp;
        this.setPaintChanged();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        Graphics2D graphics2D = (Graphics2D)new BufferedImage(1, 1, 2).getGraphics();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        graphics2D.dispose();
        return graphicsConfiguration;
    }

    @Override
    public Paint getPaint() {
        return this.a().g;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint != null) {
            this.a().g = paint;
            if (paint instanceof Color) {
                this.a().setColor((Color)paint);
            }
            this.setPaintChanged();
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.a().h.clone();
    }

    @Override
    public Stroke getStroke() {
        return this.a().n;
    }

    @Override
    public void setStroke(Stroke s) {
        this.a().n = s;
        this.setStrokeChanged();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.a().o, true, true);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.a().o);
    }

    protected AffineTransform getInternalTransform() {
        return this.a().o;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    @Override
    public void rotate(double theta) {
        this.transform(AffineTransform.getRotateInstance(theta));
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    @Override
    public void translate(int x, int y) {
        this.transform(AffineTransform.getTranslateInstance(x, y));
    }

    protected Object clone() throws CloneNotSupportedException {
        GraphicsBase graphicsBase = (GraphicsBase)super.clone();
        graphicsBase.o = new AffineTransform(this.a().o);
        graphicsBase.h = (RenderingHints)this.a().h.clone();
        return graphicsBase;
    }

    @Override
    public void setTransform(AffineTransform tx) {
        if (!this.a().o.equals(tx)) {
            this.a().setTransformImpl(tx);
            this.a().o.setTransform(tx);
            this.b();
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        this.a().transformImpl(tx);
        this.a().o.concatenate(tx);
        this.b();
    }

    protected abstract void setTransformImpl(AffineTransform var1);

    protected abstract void transformImpl(AffineTransform var1);

    public void addRenderingHints(Map hints) {
        this.a().h.putAll((Map<?, ?>)hints);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.a().h = new RenderingHints(hints);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.a().n.createStrokedShape(s);
        }
        return s.intersects(rect);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.a().h.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.a().h.put(hintKey, hintValue);
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
        this.setPaintChanged();
    }

    @Override
    public void setXORMode(Color c2) {
        this.setPaintChanged();
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Composite composite = this.a().f;
        Paint paint = this.a().g;
        this.setComposite(AlphaComposite.Src);
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(paint);
        this.setComposite(composite);
    }

    @Override
    public Color getColor() {
        return this.p;
    }

    @Override
    public void setColor(Color c2) {
        if (c2 != null) {
            this.a().p = c2;
            this.a().g = c2;
            this.setPaintChanged();
        }
    }

    @Override
    public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) throws UnsupportedOperationException {
        try {
            GraphicsBase graphicsBase = (GraphicsBase)super.clone();
            graphicsBase.o = new AffineTransform();
            graphicsBase.setRenderingHints(graphicsBase.h);
            this.d.add(graphicsBase);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public int getNumOfLayers() {
        return this.d.size();
    }

    @Override
    public void paintLastLayer() throws IllegalStateException, UnsupportedOperationException {
        this.d.pop();
    }

    @Override
    public Font getFont() {
        return this.a().m;
    }

    @Override
    public void setFont(Font font) {
        this.a().m = font;
        this.setFontChanged();
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.a().i != null && this.a().getClip() != null) {
            return this.a().getClip().getBounds();
        }
        return null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        if (this.a().j != null) {
            return this.a().j;
        }
        if (this.a().i == null) {
            return null;
        }
        try {
            this.a().j = this.a().o.createInverse().createTransformedShape(this.a().i);
            return this.a().j;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public Shape getDeviceClip() {
        return this.a().k;
    }

    public void setDeviceClip(Shape deviceClip) {
        this.a().k = deviceClip;
        this.a().a(null);
        this.a().b();
    }

    protected Shape getCompositeClip() {
        if (this.a().r) {
            if (this.a().getClip() != null) {
                Area area = new Area(this.a().k);
                Area area2 = new Area(this.a().i);
                area.intersect(area2);
                this.a().l = area.isEmpty() ? a : area;
            } else {
                this.a().l = this.a().k;
            }
            this.a().r = false;
        }
        return this.a().l;
    }

    @Override
    public void setClip(Shape clip) {
        Shape shape = clip;
        if (clip != null && !this.a().o.isIdentity()) {
            clip = this.a().o.createTransformedShape(clip);
        }
        this.a().i = clip;
        this.a().a(shape);
        this.a().b();
    }

    @Override
    public void clip(Shape s) {
        if (s != null && !this.a().o.isIdentity()) {
            s = this.a().o.createTransformedShape(s);
        }
        if (this.a().i != null) {
            Area area = new Area(this.a().i);
            area.intersect(new Area(s));
            s = area.isEmpty() ? a : area;
        }
        this.a().i = s;
        this.a().a(null);
        this.a().b();
    }

    private void b() {
        this.a().r = true;
        this.a().j = null;
    }

    @Override
    public FontMetrics getFontMetrics(Font f2) {
        if (f2.equals(this.getFont()) && this.a().q != null && this.a().q.getFont() != null && this.a().q.getFont().equals(f2)) {
            return this.q;
        }
        FontMetrics fontMetrics = FontPool.getFontMetrics(f2);
        if (f2.equals(this.a().getFont())) {
            this.a().q = fontMetrics;
        }
        return fontMetrics;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(xPoints[0], yPoints[0]);
        for (int i2 = 1; i2 < nPoints; ++i2) {
            generalPath.lineTo(xPoints[i2], yPoints[i2]);
        }
        this.draw(generalPath);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void drawPolygon(Polygon p2) {
        this.draw(p2);
    }

    @Override
    public void fillPolygon(Polygon p2) {
        this.fill(p2);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    protected boolean isClipChanged() {
        return this.a().s;
    }

    private void a(Shape shape) {
        this.a().s = true;
        this.a().j = shape;
    }

    protected void resetClipChanged() {
        this.a().s = false;
    }

    protected boolean isFontChanged() {
        return this.a().v;
    }

    protected void setFontChanged() {
        this.a().v = true;
    }

    protected boolean isPaintChanged() {
        return this.a().t;
    }

    protected void resetPaintChanged() {
        this.a().t = false;
    }

    protected void setPaintChanged() {
        this.a().t = true;
    }

    protected boolean isStrokeChanged() {
        return this.a().u;
    }

    protected void resetStrokeChanged() {
        this.a().u = false;
    }

    protected void setStrokeChanged() {
        this.a().u = true;
    }

    protected static void notSupported(String message) {
        Logger logger = LogManager.getApplicationLogger();
        if (logger.isWarning()) {
            logger.warn("Rendering as Image\n" + message + " is not supported");
        }
        throw new UnsupportedOperationException(message);
    }

    public boolean isSupportLocalCoordinates() {
        return false;
    }
}

