/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.unicode;

import com.inet.font.unicode.UnicodeBlockChecker;
import com.inet.font.unicode.UnicodeCharBlock;
import com.inet.font.unicode.UnicodeCharBlockGroupList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class UnicodeBlockHandler {
    private UnicodeBlockChecker a;

    public UnicodeBlockHandler(UnicodeCharBlockGroupList blockGroupIdList, UnicodeBlockChecker blockChecker) {
        this.a = blockChecker;
    }

    public void handle(UnicodeCharBlockGroupList blockGroupIdList, @Nonnull List<UnicodeCharBlock> supportedBlocks) {
        Integer n2;
        List<Integer> list = blockGroupIdList.getListOfUnicodeRanges();
        for (int i2 = 0; i2 < list.size() && (n2 = list.get(i2)) != null; ++i2) {
            int n3 = n2;
            UnicodeBlockChecker unicodeBlockChecker = null;
            if (UnicodeBlockHandler.isGroupContainsSupplementaryBlock(n3)) {
                unicodeBlockChecker = this.a;
            }
            this.addBlocksFromGroup(n3, supportedBlocks, unicodeBlockChecker);
        }
    }

    public List<UnicodeCharBlock> getSupportedNonPlane0UnicodeBlocks() {
        ArrayList<UnicodeCharBlock> arrayList = new ArrayList<UnicodeCharBlock>();
        for (UnicodeCharBlock unicodeCharBlock : UnicodeCharBlock.a) {
            if (unicodeCharBlock.getFirstChar() < 65536 || !this.a.contains(unicodeCharBlock)) continue;
            arrayList.add(unicodeCharBlock);
        }
        return arrayList;
    }

    public static boolean isGroupContainsSupplementaryBlock(int blockGroupId) {
        for (int i2 = 0; i2 < UnicodeCharBlock.SIZE; ++i2) {
            int n2 = UnicodeCharBlock.getUniqueBlockID(blockGroupId, i2);
            UnicodeCharBlock unicodeCharBlock = UnicodeCharBlock.getUnicodeCharBlock(n2);
            if (unicodeCharBlock == null) {
                return false;
            }
            if (!unicodeCharBlock.isNonPlane0Block()) continue;
            return true;
        }
        return false;
    }

    public void addBlocksFromGroup(int blockGroupId, @Nonnull List<UnicodeCharBlock> list, UnicodeBlockChecker groupChecker) {
        for (int i2 = 0; i2 < UnicodeCharBlock.SIZE; ++i2) {
            int n2 = UnicodeCharBlock.getUniqueBlockID(blockGroupId, i2);
            UnicodeCharBlock unicodeCharBlock = UnicodeCharBlock.getUnicodeCharBlock(n2);
            if (unicodeCharBlock == null) {
                return;
            }
            if (groupChecker == null) {
                list.add(unicodeCharBlock);
                continue;
            }
            if (!groupChecker.hasSupplementaryCodePoints()) {
                if (unicodeCharBlock.isNonPlane0Block()) continue;
                list.add(unicodeCharBlock);
                continue;
            }
            if (!groupChecker.contains(unicodeCharBlock)) continue;
            list.add(unicodeCharBlock);
        }
    }
}

