/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.font.EudcFontHandler;
import com.inet.font.FontUtils;
import com.inet.font.HasFontInfo;
import com.inet.font.layout.FontLayout;
import com.inet.font.layout.TTFontLayout;
import com.inet.font.truetype.ArabicPresentationFormBConverter;
import com.inet.font.truetype.ReplacingFontFinder;
import com.inet.font.truetype.SubFontTT;
import com.inet.font.truetype.TTFont;
import com.inet.lib.list.IntList;
import com.inet.logging.LogManager;
import java.util.HashMap;
import java.util.Map;

public class InstalledFontTT
implements HasFontInfo {
    private static final boolean DISPLAY_NOT_AVAILABLE_CHARS = true;
    static final int MAX_COUNT_OF_MISSING_CHAR = 100;
    static final int NULL_GLYPH = 0;
    private final int a;
    private final int b;
    private final int c;
    private final int d;
    private final TTFont e;
    private IntList f;
    private Map<Integer, LayoutArray> g;
    private final boolean h;
    private ReplacingFontFinder i;
    private static final char CH_MAI_HANAKAT = '\u0e31';
    private static final char CH_YAMAKKAN = '\u0e4e';
    private static final char CH_MAITAIKHU = '\u0e47';
    private static final char CH_SARA_U = '\u0e38';
    private static final char CH_YO_YING = '\u0e0d';
    private TTFontLayout j;

    InstalledFontTT(TTFont ttFont, ReplacingFontFinder fontFinder) {
        this.e = ttFont;
        this.a = ttFont.getAscent();
        this.b = ttFont.getCapHeight();
        this.c = ttFont.getDescent();
        this.d = ttFont.getLineCap();
        this.h = "EUDC".equals(ttFont.f_name);
        this.i = fontFinder;
    }

    public TTFont getTTFont() {
        return this.e;
    }

    public boolean isSymbolCodePage() {
        return this.e.isSymbolCodePage();
    }

    @Override
    public int getAscent() {
        return this.a;
    }

    @Override
    public int getCapHeight() {
        return this.b;
    }

    @Override
    public int getDescent() {
        return this.c;
    }

    public int getLineGap() {
        return this.d;
    }

    @Override
    public int getStemV() {
        return this.getTTFont().d;
    }

    @Override
    public int getBBoxXMin() {
        return this.getTTFont().e;
    }

    @Override
    public int getBBoxYMin() {
        return this.getTTFont().f;
    }

    @Override
    public int getBBoxXMax() {
        return this.getTTFont().g;
    }

    @Override
    public int getBBoxYMax() {
        return this.getTTFont().h;
    }

    @Override
    public int getFlags() {
        return this.getTTFont().e();
    }

    public boolean isEmbedded() {
        return this instanceof SubFontTT && this.e.isEmbedded();
    }

    public String filenameOfTTFont() {
        return this.e.f_name;
    }

    public int getCharFullWidthTT(int ch, int fontStyle, int fontSizeTwips) {
        int n2;
        int n3 = 0;
        switch (ch) {
            case 10: 
            case 13: {
                return 0;
            }
            case 9: {
                int n4 = this.e.b();
                if (n4 > 0) {
                    n3 = this.e.a(0) * 4;
                }
                return n3;
            }
        }
        char c2 = this.e.getGlyph(ch);
        if (!this.isForceReplacing() && c2 == '\uffff' && ArabicPresentationFormBConverter.belongsToPresentationFormsB(ch) && (n2 = ArabicPresentationFormBConverter.getRegularCodePoint((char)ch)) != 0 && ArabicPresentationFormBConverter.isSingleChar(n2)) {
            c2 = this.e.getGlyph(n2);
        }
        if (this.isForceReplacing() || c2 == '\uffff') {
            if (this.f == null) {
                this.f = new IntList();
            }
            if (this.f.size() < 100 && !this.f.contains(ch)) {
                LogManager.getApplicationLogger().info("character " + ch + "=" + ch + " not found in font " + this.getTTFont().getFontCollection().a()[this.getTTFont().a][0]);
                this.f.addElement(ch);
            }
            if (this.isEmbedded()) {
                TTFontLayout tTFontLayout;
                Object object;
                if (this.g != null) {
                    if (this.j != null && this.j.getInstalledFontTT().canDisplay(ch) && this.j.getStyle() == fontStyle) {
                        if (this.j.getSizeTwips() != fontSizeTwips) {
                            this.j = this.j.scaleFontLayout(fontSizeTwips);
                        }
                        this.addMissingChar(ch, this.j, fontStyle);
                        return this.j.getInstalledFontTT().getCharFullWidthTT(ch, fontStyle, fontSizeTwips);
                    }
                    LayoutArray layoutArray = this.g.get(ch);
                    if (layoutArray != null && (object = layoutArray.getLayout(fontStyle)) != null && ((TTFontLayout)object).getInstalledFontTT() != this) {
                        if (((FontLayout)object).getSizeTwips() != fontSizeTwips) {
                            object = ((TTFontLayout)object).scaleFontLayout(fontSizeTwips);
                            layoutArray.setLayout((TTFontLayout)object, fontStyle);
                        }
                        this.j = object;
                        this.addMissingChar(ch, (TTFontLayout)object, fontStyle);
                        return ((TTFontLayout)object).getInstalledFontTT().getCharFullWidthTT(ch, fontStyle, fontSizeTwips);
                    }
                }
                if (this.i != null && (tTFontLayout = this.i.a(ch, this, fontStyle, fontSizeTwips)) != null && (object = tTFontLayout.getInstalledFontTT()) != this) {
                    c2 = ((InstalledFontTT)object).e.getGlyph(ch);
                    this.addMissingChar(ch, tTFontLayout, fontStyle);
                    n3 = ((InstalledFontTT)object).getCharFullWidthTT(ch, 0, fontSizeTwips);
                    if (((InstalledFontTT)object).e.b) {
                        ((InstalledFontTT)object).setGlyph(ch, c2);
                    }
                    this.j = tTFontLayout;
                    return n3;
                }
            } else if (this.g != null) {
                LayoutArray layoutArray = this.g.get(ch);
                TTFontLayout tTFontLayout = layoutArray.getLayout(fontStyle);
                if (tTFontLayout != null) {
                    InstalledFontTT installedFontTT = tTFontLayout.getInstalledFontTT();
                    c2 = installedFontTT.e.getGlyph(ch);
                    n3 = installedFontTT.getCharFullWidthTT(ch, fontStyle, fontSizeTwips);
                    if (installedFontTT.e.b) {
                        installedFontTT.setGlyph(ch, c2);
                    }
                }
                return n3;
            }
            c2 = '\u0000';
        }
        if (c2 != '\uffff') {
            n3 = this.e.getGlyphWidth(c2);
            if (n3 == 0) {
                LogManager.getApplicationLogger().info("character " + ch + "(" + ch + ") has width=0");
            }
            if (this.e.b && this.setGlyph(ch, c2)) {
                switch (ch) {
                    case 1569: {
                        this.a('\ufe80');
                        break;
                    }
                    case 1570: {
                        this.a('\ufe81');
                        break;
                    }
                    case 1571: {
                        this.a('\ufe83');
                        break;
                    }
                    case 1572: {
                        this.a('\ufe85');
                        break;
                    }
                    case 1573: {
                        this.a('\ufe87');
                        break;
                    }
                    case 1574: {
                        this.a('\ufe89');
                        break;
                    }
                    case 1575: {
                        this.a('\ufe8d');
                        break;
                    }
                    case 1576: {
                        this.a('\ufe8f');
                        break;
                    }
                    case 1577: {
                        this.a('\ufe93');
                        break;
                    }
                    case 1578: {
                        this.a('\ufe95');
                        break;
                    }
                    case 1579: {
                        this.a('\ufe99');
                        break;
                    }
                    case 1580: {
                        this.a('\ufe9d');
                        break;
                    }
                    case 1581: {
                        this.a('\ufea1');
                        break;
                    }
                    case 1582: {
                        this.a('\ufea5');
                        break;
                    }
                    case 1583: {
                        this.a('\ufea9');
                        break;
                    }
                    case 1584: {
                        this.a('\ufeab');
                        break;
                    }
                    case 1585: {
                        this.a('\ufead');
                        break;
                    }
                    case 1586: {
                        this.a('\ufeaf');
                        break;
                    }
                    case 1587: {
                        this.a('\ufeb1');
                        break;
                    }
                    case 1588: {
                        this.a('\ufeb5');
                        break;
                    }
                    case 1589: {
                        this.a('\ufeb9');
                        break;
                    }
                    case 1590: {
                        this.a('\ufebd');
                        break;
                    }
                    case 1591: {
                        this.a('\ufec1');
                        break;
                    }
                    case 1592: {
                        this.a('\ufec5');
                        break;
                    }
                    case 1593: {
                        this.a('\ufec9');
                        break;
                    }
                    case 1594: {
                        this.a('\ufecd');
                        break;
                    }
                    case 1601: {
                        this.a('\ufed1');
                        break;
                    }
                    case 1602: {
                        this.a('\ufed5');
                        break;
                    }
                    case 1603: {
                        this.a('\ufed9');
                        break;
                    }
                    case 1604: {
                        this.a('\ufedd');
                        break;
                    }
                    case 1605: {
                        this.a('\ufee1');
                        break;
                    }
                    case 1606: {
                        this.a('\ufee5');
                        break;
                    }
                    case 1607: {
                        this.a('\ufee9');
                        break;
                    }
                    case 1608: {
                        this.a('\ufeed');
                        break;
                    }
                    case 1609: {
                        this.a('\ufeef');
                        break;
                    }
                    case 1610: {
                        this.a('\ufef1');
                        break;
                    }
                    case 1649: {
                        this.a('\ufb50');
                        break;
                    }
                    case 1657: {
                        this.a('\ufb66');
                        break;
                    }
                    case 1658: {
                        this.a('\ufb5e');
                        break;
                    }
                    case 1659: {
                        this.a('\ufb52');
                        break;
                    }
                    case 1662: {
                        this.a('\ufb56');
                        break;
                    }
                    case 1663: {
                        this.a('\ufb62');
                        break;
                    }
                    case 1664: {
                        this.a('\ufb5a');
                        break;
                    }
                    case 1667: {
                        this.a('\ufb76');
                        break;
                    }
                    case 1668: {
                        this.a('\ufb72');
                        break;
                    }
                    case 1670: {
                        this.a('\ufb7a');
                        break;
                    }
                    case 1671: {
                        this.a('\ufb7e');
                        break;
                    }
                    case 1672: {
                        this.a('\ufb88');
                        break;
                    }
                    case 1676: {
                        this.a('\ufb84');
                        break;
                    }
                    case 1677: {
                        this.a('\ufb82');
                        break;
                    }
                    case 1678: {
                        this.a('\ufb86');
                        break;
                    }
                    case 1681: {
                        this.a('\ufb8c');
                        break;
                    }
                    case 1688: {
                        this.a('\ufb8a');
                        break;
                    }
                    case 1700: {
                        this.a('\ufb6a');
                        break;
                    }
                    case 1702: {
                        this.a('\ufb6e');
                        break;
                    }
                    case 1705: {
                        this.a('\ufb8e');
                        break;
                    }
                    case 1709: {
                        this.a('\ufbd3');
                        break;
                    }
                    case 1711: {
                        this.a('\ufb92');
                        break;
                    }
                    case 1713: {
                        this.a('\ufb9a');
                        break;
                    }
                    case 1715: {
                        this.a('\ufb96');
                        break;
                    }
                    case 1722: {
                        this.a('\ufb9e');
                        break;
                    }
                    case 1723: {
                        this.a('\ufba0');
                        break;
                    }
                    case 1726: {
                        this.a('\ufbaa');
                        break;
                    }
                    case 1728: {
                        this.a('\ufba4');
                        break;
                    }
                    case 1729: {
                        this.a('\ufba6');
                        break;
                    }
                    case 1733: {
                        this.a('\ufbe0');
                        break;
                    }
                    case 1734: {
                        this.a('\ufbd9');
                        break;
                    }
                    case 1735: {
                        this.a('\ufbd7');
                        break;
                    }
                    case 1736: {
                        this.a('\ufbdb');
                        break;
                    }
                    case 1737: {
                        this.a('\ufbe2');
                        break;
                    }
                    case 1739: {
                        this.a('\ufbde');
                        break;
                    }
                    case 1740: {
                        this.a('\ufbfc');
                        break;
                    }
                    case 1744: {
                        this.a('\ufbe4');
                        break;
                    }
                    case 1746: {
                        this.a('\ufbae');
                        break;
                    }
                    case 1747: {
                        this.a('\ufbb0');
                    }
                }
                switch (ch) {
                    case 3635: {
                        this.a('\u0e4d');
                        this.a('\u0e32');
                        break;
                    }
                    case 3633: {
                        this.a('\u0e61');
                        this.a('\uf710');
                        this.a('\uf884');
                        break;
                    }
                    case 3636: {
                        this.a('\u0e64');
                        this.a('\uf701');
                        this.a('\uf885');
                        break;
                    }
                    case 3637: {
                        this.a('\u0e65');
                        this.a('\uf702');
                        this.a('\uf886');
                        break;
                    }
                    case 3638: {
                        this.a('\u0e66');
                        this.a('\uf703');
                        this.a('\uf887');
                        break;
                    }
                    case 3639: {
                        this.a('\u0e67');
                        this.a('\uf704');
                        this.a('\uf888');
                        break;
                    }
                    case 3662: {
                        this.a('\u0e7e');
                        break;
                    }
                    case 3655: {
                        this.a('\u0e68');
                        this.a('\u0e76');
                        this.a('\uf712');
                        this.a('\uf889');
                        this.a('\u0e6f');
                        break;
                    }
                    case 3656: {
                        this.a('\u0e69');
                        this.a('\uf70a');
                        this.a('\uf88b');
                        this.a('\u0e77');
                        this.a('\uf705');
                        this.a('\uf88c');
                        this.a('\u0e70');
                        this.a('\uf713');
                        this.a('\uf88a');
                        break;
                    }
                    case 3657: {
                        this.a('\u0e6a');
                        this.a('\uf70b');
                        this.a('\uf88e');
                        this.a('\u0e78');
                        this.a('\uf706');
                        this.a('\uf88f');
                        this.a('\u0e71');
                        this.a('\uf714');
                        this.a('\uf88d');
                        break;
                    }
                    case 3658: {
                        this.a('\u0e6b');
                        this.a('\uf70c');
                        this.a('\uf891');
                        this.a('\u0e79');
                        this.a('\uf707');
                        this.a('\uf892');
                        this.a('\u0e72');
                        this.a('\uf715');
                        this.a('\uf890');
                        break;
                    }
                    case 3659: {
                        this.a('\u0e6c');
                        this.a('\uf70d');
                        this.a('\uf894');
                        this.a('\u0e7a');
                        this.a('\uf708');
                        this.a('\uf895');
                        this.a('\u0e73');
                        this.a('\uf716');
                        this.a('\uf893');
                        break;
                    }
                    case 3660: {
                        this.a('\u0e6d');
                        this.a('\uf70e');
                        this.a('\uf897');
                        this.a('\u0e7b');
                        this.a('\uf709');
                        this.a('\uf898');
                        this.a('\u0e74');
                        this.a('\uf717');
                        this.a('\uf896');
                        break;
                    }
                    case 3661: {
                        this.a('\u0e6e');
                        this.a('\u0e7c');
                        this.a('\uf711');
                        this.a('\uf899');
                        this.a('\u0e75');
                        break;
                    }
                    case 3640: {
                        this.a('\u0e3c');
                        this.a('\uf718');
                        break;
                    }
                    case 3641: {
                        this.a('\u0e3d');
                        this.a('\uf719');
                        break;
                    }
                    case 3642: {
                        this.a('\u0e3e');
                        this.a('\uf71a');
                        break;
                    }
                    case 3597: {
                        this.a('\u0e60');
                        this.a('\uf70f');
                        break;
                    }
                    case 3600: {
                        this.a('\u0e63');
                        this.a('\uf700');
                    }
                }
            }
        }
        return n3;
    }

    private void a(char c2) {
        char c3 = this.e.getGlyph(c2);
        if (c3 != '\uffff') {
            this.setGlyph(c2, c3);
        }
    }

    protected boolean setGlyph(int ch, int glyph) {
        return false;
    }

    public boolean canDisplay(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return this.e.getGlyph(ch) != '\uffff';
    }

    public void addMissingChar(int ch, TTFontLayout fontLayout, int style) {
        LayoutArray layoutArray = null;
        if (this.g == null) {
            this.g = new HashMap<Integer, LayoutArray>();
            char c2 = this.e.getGlyph(65533);
            if (c2 != '\uffff') {
                this.setGlyph(65533, c2);
            }
        } else {
            layoutArray = this.g.get(ch);
        }
        if (layoutArray == null) {
            layoutArray = new LayoutArray();
            this.g.put(ch, layoutArray);
        }
        if (layoutArray.getLayout(style) == null) {
            layoutArray.setLayout(fontLayout, style);
        }
    }

    public Map<Integer, LayoutArray> getMissingCharsLayoutMap() {
        return this.g;
    }

    public int getCharWidth(int ch, int fontSize, int fontStyle) {
        if (!this.canDisplay(ch) && !this.h && EudcFontHandler.hasEudcFont() && EudcFontHandler.canBeDisplyedByEUDC(ch)) {
            int n2 = EudcFontHandler.getCharWidth(ch, fontSize);
            return n2 * 1000;
        }
        int n3 = this.getCharFullWidthTT(ch, fontStyle, fontSize);
        return n3 * fontSize;
    }

    public int getNativeStyle() {
        return this.getTTFont() != null ? this.getTTFont().c() : 0;
    }

    protected ReplacingFontFinder getReplacingFontFinder() {
        return this.i;
    }

    public String getFontType() {
        String string = this.e.getFontFamilyClass();
        if (string == null) {
            string = FontUtils.findFontFamilyType(this.filenameOfTTFont());
        }
        return string;
    }

    public boolean isForceReplacing() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.e == ((InstalledFontTT)obj).e;
    }

    public static class LayoutArray {
        private TTFontLayout[] a = new TTFontLayout[4];

        public TTFontLayout getLayout(int index) {
            if (index < 4) {
                return this.a[index];
            }
            throw new IndexOutOfBoundsException("index of layout array is " + index);
        }

        public void setLayout(TTFontLayout layout, int index) {
            if (this.a[index] == null) {
                this.a[index] = layout;
            }
        }
    }
}

