/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.logging.LogManager;
import java.awt.Font;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Nonnull;

public abstract class FontLayout
implements Serializable {
    private final int a;
    private final String b;
    private final int c;
    private final int d;
    private int e;
    private HashMap<Character, FontLayout> f;
    private int g = -1;

    protected FontLayout(String name, int style, int sizeTwips) {
        this.a = sizeTwips;
        this.b = name;
        this.c = style & 3;
        this.d = FontLayout.hashCode(this.b, this.c, this.a);
    }

    protected static boolean requiresSpecialLayout(char c2) {
        return c2 >= '\u0590' && c2 < '\u0e80' || c2 >= '\u202a' && c2 < '\u202f' || Character.isHighSurrogate(c2);
    }

    public int stringWidth(String text) {
        int n2 = 0;
        int n3 = text.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = text.charAt(i2);
            if (FontLayout.requiresSpecialLayout(c2)) {
                return this.stringWidthSpecial(text);
            }
            int n4 = this.charWidth(c2);
            if (n4 >= 0) {
                n2 += n4;
                continue;
            }
            LogManager.getApplicationLogger().warn("symbol not found c=" + c2);
        }
        return n2;
    }

    public abstract int stringWidthSpecial(String var1);

    public abstract int charWidth(int var1);

    public abstract int getAscent();

    public abstract int getDescent();

    public abstract int getLeading();

    public int getItalicIndent() {
        if (this.g < 0) {
            this.g = (this.c & 2) > 0 ? (int)Math.ceil((double)this.getAscent() / 20.0) : 0;
        }
        return this.g;
    }

    protected void setItalicIndent(int italicIndent) {
        this.g = italicIndent;
    }

    public final String getName() {
        return this.b;
    }

    public final int getSizeTwips() {
        return this.a;
    }

    public final int getSizePoints() {
        return (int)Math.floor((double)this.a / 20.0);
    }

    public final int getStyle() {
        return this.c;
    }

    public final boolean equals(String fontName, int fontStyle, int fontSize) {
        return this.a == fontSize && this.c == fontStyle && this.b.equals(fontName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FontLayout) {
            FontLayout fontLayout = (FontLayout)obj;
            return fontLayout.a == this.a && fontLayout.c == this.c && fontLayout.b.equals(this.b);
        }
        return false;
    }

    public static final int hashCode(String fontName, int style, int size) {
        return (fontName.hashCode() * 31 + size) * 31 + (style & 3);
    }

    public final int hashCode() {
        return this.d;
    }

    public Font getJavaFont() {
        return new Font(this.b, this.c, this.a / 15);
    }

    public boolean isSymbolCodePage() {
        return false;
    }

    public void setExtraLeading(int extraLeading) {
        this.e = extraLeading;
    }

    public int getExtraLeading() {
        return this.e;
    }

    public boolean canDisplay(char ch) {
        return true;
    }

    public HashMap<Character, FontLayout> getCharToFontLayoutMap() {
        return this.f;
    }

    @Nonnull
    public FontLayout unwrap() {
        return this;
    }
}

