/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeGUID
extends FieldType<GUID> {
    public FieldTypeGUID(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable GUID value) {
        return StringFunctions.stringValueOf(value);
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.ID, true, GuidTokenizer.INSTANCE, 100, labelProvider, false));
    }

    public static FieldTypeGUID withoutSearchtag(String key) {
        return new FieldTypeGUID(key, () -> null){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public GUID valueOf(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return GUID.valueOf(value);
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.IS_NOT_EMPTY);
    }
}

