/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.core.license;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseInfoHolder;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.core.license.LicenseEntry;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.plugin.FeatureLicenseInformation;
import com.inet.plugin.ServerPluginManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
public class LicenseConfigProperty
extends ItemListConfigProperty {
    public static final String ACTION_IMPORT_LICENSE = "import.license.action";
    public static final String ACTION_ADD_LICENSE = "license.add";
    public static final String ACTION_TRIAL_LICENSE = "action.generateTrial";

    public LicenseConfigProperty(ConfigStructureSettings settings) {
        this(100, settings, LicenseConfigProperty.getRowAction(settings));
    }

    public LicenseConfigProperty(int sortid, ConfigStructureSettings settings, ConfigRowAction[] licenseActions) {
        super(sortid, ConfigKey.LICENSEKEY.getKey(), "ItemList" + ConfigKey.LICENSEKEY.getKey(), LicenseConfigProperty.getLicenseList(settings), CoreSystemStructureProvider.INSTANCE.translate(settings, "license.actions", new Object[0]), licenseActions);
    }

    public static void addLicensesTo(List<LicenseEntry> licenses, String licenseKey, ConfigStructureSettings settings) {
        LicenseInfoHolder licenseInfoHolder = new ConfigKeyParser().getLicenseInfo(licenseKey);
        LicenseInfo licenseInfo = licenseInfoHolder.getCurrent();
        Map<String, LicenseInfo> map = licenseInfoHolder.getAllFeatures();
        List<FeatureLicenseInformation> list = ServerPluginManager.getInstance().get(FeatureLicenseInformation.class);
        for (LicenseInfo licenseInfo2 : licenseInfoHolder.getAll()) {
            boolean bl;
            if (!licenseInfo2.isValid()) {
                bl = false;
            } else if (licenseInfo2 == licenseInfo) {
                bl = true;
            } else if (map.containsValue(licenseInfo2)) {
                bl = false;
                for (FeatureLicenseInformation featureLicenseInformation : list) {
                    if (!map.containsKey(featureLicenseInformation.getFeature())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            LicenseEntry licenseEntry = new LicenseEntry(licenseInfo2, CoreSystemStructureProvider.INSTANCE, settings, bl);
            licenses.add(licenseEntry);
        }
    }

    public static String convertToLicenseList(String value) {
        if (value != null && value.length() > 0) {
            ArrayList arrayList = (ArrayList)new Json().fromJson(value, (Type)new JsonParameterizedType((Type)((Object)ArrayList.class), new Type[]{LicenseEntry.class}));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n2 = 0;
            for (LicenseEntry licenseEntry : arrayList) {
                int n3;
                Object object = licenseEntry.getLicenseKey();
                if (object == null || ((String)object).isEmpty()) continue;
                while ((n3 = ((String)object).indexOf(35)) >= 0) {
                    int n4 = ((String)object).indexOf(10, n3) + 1;
                    if (n4 <= 0) {
                        n4 = ((String)object).length();
                    }
                    object = ((String)object).substring(0, n3) + ((String)object).substring(n4);
                }
                if (licenseEntry.isExisting()) {
                    arrayList2.add((String)object);
                    continue;
                }
                arrayList2.add(n2++, (String)object);
            }
            return String.join((CharSequence)",", arrayList2);
        }
        return "";
    }

    @Nonnull
    public static List<LicenseEntry> getLicenseList(@Nonnull ConfigStructureSettings settings) {
        ArrayList<LicenseEntry> arrayList = new ArrayList<LicenseEntry>();
        LicenseConfigProperty.addLicensesTo(arrayList, settings.getLicenseKey(), settings);
        return arrayList;
    }

    protected static ConfigRowAction[] getRowAction(ConfigStructureSettings settings) {
        ConfigRowAction[] configRowActionArray;
        ConfigAction configAction = new ConfigAction(ACTION_ADD_LICENSE, CoreSystemStructureProvider.INSTANCE.translate(settings, ACTION_ADD_LICENSE, new Object[0]));
        ConfigAction configAction2 = new ConfigAction(ACTION_IMPORT_LICENSE, CoreSystemStructureProvider.INSTANCE.translate(settings, "license.import", new Object[0]));
        ConfigCategory configCategory = new ConfigCategory(0, ACTION_ADD_LICENSE, CoreSystemStructureProvider.INSTANCE.translate(settings, ACTION_ADD_LICENSE, new Object[0]), "system-license");
        ArrayList<ConfigPropertyGroup> arrayList = new ArrayList<ConfigPropertyGroup>();
        arrayList.add(new ConfigPropertyGroup(0, "license.add.group"));
        HashMap<String, List<ConfigProperty>> hashMap = new HashMap<String, List<ConfigProperty>>();
        ArrayList<ConfigProperty> arrayList2 = new ArrayList<ConfigProperty>();
        hashMap.put("license.add.group", arrayList2);
        ConfigProperty configProperty = new ConfigProperty(0, "currentlicensekey", "MultiLineText", CoreSystemStructureProvider.INSTANCE.translate(settings, ConfigKey.LICENSEKEY.getKey(), new Object[0]), null, null, null);
        arrayList2.add(configProperty);
        if (settings.getLicense().isValid()) {
            configRowActionArray = new ConfigRowAction[]{new ConfigRowAction(configAction, null, configCategory, arrayList, hashMap, null), new ConfigRowAction(configAction2, null, null, null, null, null)};
        } else {
            configRowActionArray = new ConfigRowAction[3];
            configRowActionArray[0] = new ConfigRowAction(configAction, null, configCategory, arrayList, hashMap, null);
            configRowActionArray[1] = new ConfigRowAction(configAction2, null, null, null, null, null);
            ConfigAction configAction3 = new ConfigAction(ACTION_TRIAL_LICENSE, CoreSystemStructureProvider.INSTANCE.translate(settings, ACTION_TRIAL_LICENSE, new Object[0]));
            configRowActionArray[2] = new ConfigRowAction(configAction3, null, null, null, null, null);
        }
        return configRowActionArray;
    }
}

