/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.recovery;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.recovery.RecoveryConfiguration;
import com.inet.config.recovery.TextAreaInputStream;
import com.inet.config.recovery.TextAreaOutputStream;
import com.inet.lib.ico.WindowIcon;
import com.inet.lib.json.Json;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.PreferencesUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.StartupLogger;
import com.inet.persistence.Persistence;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.InetcoreServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ResourceFile;
import com.inet.process.ProcessStarter;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

@InternalApi
public class RecoveryLauncher {
    private ServerPluginDescription a;
    private String b;
    private String c;
    private String d;
    private String e;
    private String f;
    private JLabel g;
    private Action h;
    private boolean i;
    private static final int LINUX = 0;
    private static final int WINDOWS = 1;
    private static final int MAC = 2;
    private static final List<String> j = Arrays.asList("inetcore", "webserver", "help", "remotegui", "theme", "reporting", "htmlengine");

    public static void main(String[] args) throws Exception {
        try {
            Object object;
            CoreServerPlugin coreServerPlugin;
            String string = args.length == 0 || args[0].startsWith("-") ? null : args[0];
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            ServerPluginDescription serverPluginDescription = serverPluginManager.loadCoreServerPluginDescriptionForServerStart(string);
            if (serverPluginDescription == null) {
                serverPluginDescription = ServerPluginDescription.create(new InetcoreServerPlugin(), InetcoreServerPlugin.class.getClassLoader());
            } else if (Persistence.isFilePersistence()) {
                try {
                    String string2;
                    coreServerPlugin = (CoreServerPlugin)serverPluginDescription.getServerPlugin();
                    object = ProcessStarter.getPreferences(coreServerPlugin.getDefaultConfig());
                    if (object != null && (string2 = ProcessStarter.getAppDataPath(serverPluginDescription.getId(), (Preferences)object, new StartupLogger())) != null) {
                        System.setProperty("AppDataPath", string2);
                        ServerPluginDescription serverPluginDescription2 = serverPluginManager.loadCoreServerPluginDescriptionForServerStart(string);
                        if (serverPluginDescription2 != null) {
                            serverPluginDescription = serverPluginDescription2;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
            serverPluginManager.setCorePluginId(serverPluginDescription.getId());
            coreServerPlugin = (CoreServerPlugin)serverPluginDescription.getServerPlugin();
            object = coreServerPlugin.getRecoveryLauncher();
            ((RecoveryLauncher)object).a = serverPluginDescription;
            ((RecoveryLauncher)object).mainLoop(args);
        }
        catch (Throwable throwable) {
            LogManager.stopSpooler();
            throw throwable;
        }
    }

    protected final void mainLoop(String[] args) throws Exception {
        this.i = true;
        if (args.length > 0) {
            this.i = false;
            int n2 = 0;
            while (n2 < args.length) {
                int n3 = this.consumeArgs(args, n2);
                if (n2 >= n3) {
                    System.out.println("Invalid argument: " + args[n2] + ", open the help with -help");
                    return;
                }
                n2 = n3;
            }
        }
        if (this.i) {
            this.start();
        } else {
            try {
                ServerPluginManager.getInstance().setCorePluginId(this.a.getId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.exit();
        }
    }

    protected void exit() {
        System.exit(0);
    }

    protected int consumeArgs(String[] args, int idx) throws Exception {
        String string;
        int n2 = idx;
        switch (string = args[n2++].toLowerCase()) {
            case "-importconfig": 
            case "-forceimportconfig": {
                String string2 = null;
                String string3 = null;
                if (args.length >= n2 + 2) {
                    string2 = args[n2++];
                    string3 = args[n2++];
                }
                this.a(string2, string3, string.equalsIgnoreCase("-forceImportConfig"));
                break;
            }
            case "-listconfigurations": {
                RecoveryLauncher.f();
                break;
            }
            case "-exportconfig": {
                String string4 = null;
                String string5 = null;
                if (args.length >= n2 + 2) {
                    string4 = args[n2++];
                    string5 = args[n2++];
                }
                try {
                    this.a(string4, string5);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
                break;
            }
            case "-clearreports.preferredconfig": {
                if (n2 < args.length) {
                    ConfigurationManager.setRecoveryConfiguration(args[n2++]);
                }
                this.i = true;
                break;
            }
            case "-client.ip": {
                if (n2 < args.length) {
                    this.b = args[n2++];
                }
                this.i = true;
                break;
            }
            case "-browserhelp": {
                ConfigurationManager.setHelpCenterMode(true);
                this.i = true;
                break;
            }
            case "-port": {
                if (n2 < args.length) {
                    this.c = args[n2++];
                }
                this.i = true;
                break;
            }
            case "-sslport": {
                if (n2 < args.length) {
                    this.d = args[n2++];
                }
                this.i = true;
                break;
            }
            case "-plugins": {
                if (n2 < args.length) {
                    this.e = args[n2++];
                }
                this.i = true;
                break;
            }
            case "-h": 
            case "-help": 
            case "--help": {
                if (System.console() == null && !GraphicsEnvironment.isHeadless()) {
                    JFrame jFrame = this.d();
                    Container container = jFrame.getContentPane();
                    JTextArea jTextArea = new JTextArea();
                    Font font = new Font("Monospaced", 0, 12);
                    jTextArea.setFont(font);
                    FontMetrics fontMetrics = jTextArea.getFontMetrics(font);
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    jScrollPane.setPreferredSize(new Dimension(fontMetrics.stringWidth(" ") * 100, fontMetrics.getHeight() * 30));
                    container.add((Component)jScrollPane, "Center");
                    jFrame.pack();
                    jFrame.setLocationRelativeTo(null);
                    jFrame.setVisible(true);
                    TextAreaOutputStream textAreaOutputStream = new TextAreaOutputStream(jTextArea, 200);
                    PrintStream printStream = new PrintStream(textAreaOutputStream);
                    System.setOut(printStream);
                    System.setErr(printStream);
                    TextAreaInputStream textAreaInputStream = new TextAreaInputStream(jTextArea);
                    System.setIn(textAreaInputStream);
                }
                System.out.println("");
                System.out.println("System Properties");
                System.out.println("-----------------");
                System.out.println("The following system properties are available to control the behavior of");
                System.out.println("the recovery manager:");
                System.out.println("");
                System.out.println("Parameter Name                   | Description                            ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-Dclearreports.config            | Location of the configuration to use   ");
                System.out.println("                                 |                                        ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-Dclearreports.configfile        | Location of a config properties  ");
                System.out.println("                                 | file that will be imported into        ");
                System.out.println("                                 | temporary configuration                ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-DCC:xxxx=yyyy                   | Command line arguments to set property ");
                System.out.println("                                 | values of the Server            ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-Ddebug                          | Enable/Disable the debug options       ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-Duser.country                   | Country of the used locale             ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-Duser.language                  | Language of the used locale            ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("");
                System.out.println("Press ENTER for the next section...");
                System.in.read();
                System.out.println("Command Line Parameters");
                System.out.println("-----------------------");
                System.out.println("With the following command line parameters you can use the Configuration  ");
                System.out.println("Manager without GUI to import a configurations or Data Sources");
                System.out.println("");
                System.out.println("Parameter Name                   | Description                            ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-listconfigurations              | Lists the existing configurations      ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-importConfig <name> <file>      | Imports properties file if specified   ");
                System.out.println("                                 | configuration does not exist");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-forceImportConfig <name> <file> | Imports properties file and replace    ");
                System.out.println("                                 | existing configuration                 ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-exportConfig <name> <file>      | Exports the specified configuration in ");
                System.out.println("                                 | a properties files                     ");
                this.printHelp();
                System.out.println("");
                System.out.println("");
                System.out.println("With the following command line parameter you can set the active          ");
                System.out.println("configuration for the \"Recovery Manager\".           ");
                System.out.println("");
                System.out.println("Parameter Name                   | Description                            ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-clearreports.preferredconfig    | Select the active configuration        ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-client.ip <ip-addresses>        | The IP addresses (IPv4 or IPv6) of the ");
                System.out.println("                                 | client that will be able to connect to ");
                System.out.println("                                 | the Recovery Manager.                  ");
                System.out.println("                                 | When setting this parameter, the       ");
                System.out.println("                                 | server is started in headless mode.    ");
                System.out.println("                                 | The default value is 127.0.0.1,::1     ");
                System.out.println("                                 | Use , or ; for multiple values.        ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-port <port>                     | The TCP IP port of the recovery server ");
                System.out.println("-sslport <port>                  | The HTTPS port of the recovery server  ");
                System.out.println("                                 | if HTTPS is configured.                ");
                System.out.println("--------------------------------------------------------------------------");
                System.out.println("-plugins <plugins>               | A comma separated list of extra plugins");
                System.out.println("                                 | that should be loaded.                 ");
                System.out.println("");
                System.out.println("sample:");
                System.out.println("java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -clearreports.preferredconfig User/Default -client.ip <ip-address>");
                break;
            }
            default: {
                if (args[n2 - 1].startsWith("-D")) {
                    String string6 = args[n2 - 1].substring(2);
                    int n3 = string6.indexOf("=");
                    if (n3 < 0) {
                        System.setProperty(string6, "");
                        break;
                    }
                    System.setProperty(string6.substring(0, n3), string6.substring(n3 + 1));
                    break;
                }
                return idx;
            }
        }
        return n2;
    }

    protected void printHelp() {
    }

    protected void start() throws Exception {
        ConfigurationManager.setRecoveryMode(true);
        PreferencesUtils.userRoot();
        if (ConfigurationManager.getRecoveryConfiguration() == null) {
            boolean bl = ConfigurationManager.isWriteable(1);
            int n2 = bl && ConfigurationManager.getInstance().get(1, ConfigurationManager.NAME_DEFAULT) != null ? 1 : (ConfigurationManager.getInstance().get(2, ConfigurationManager.NAME_DEFAULT) != null ? 2 : (bl ? 1 : 2));
            ConfigurationManager.setRecoveryConfiguration(ConfigurationManager.getScopeName(n2) + "/" + ConfigurationManager.NAME_DEFAULT);
        }
        if (this.b == null) {
            this.f = "Starting configuration ...";
            try {
                try {
                    this.e();
                }
                catch (HeadlessException headlessException) {
                    System.out.println();
                    System.out.println("You are using the " + RecoveryLauncher.c() + " in an environment");
                    System.out.println("that does not support the graphical interface (headless).");
                    System.out.println("To start the recovery manager and use it from a system with a browser,");
                    System.out.println("use the following command line parameter: -client.ip <ip-address>");
                    System.out.println();
                    System.out.println("Use the command line parameter '-help' for more information and options.");
                    System.exit(1);
                }
                this.a(System.console() == null);
                this.a(RecoveryLauncher.h());
                this.f = "http://127.0.0.1:" + this.a() + (ConfigurationManager.isHelpCenterMode() ? "/help" : this.getUrlPath());
                this.h.setEnabled(true);
                this.g.setText("<html>" + this.f + "</html>");
                RecoveryLauncher.a(new URI(this.f));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this.g, StringFunctions.getUserFriendlyErrorMessage(throwable), "Error", 0);
                System.exit(1);
            }
        } else {
            this.a(true);
            this.a(null);
            System.out.println();
            System.out.println("Connect to the " + RecoveryLauncher.c() + " using:");
            String string = ConfigurationManager.isHelpCenterMode() ? "/help" : this.getUrlPath();
            InetAddress inetAddress = NetworkFunctions.getLocalHost();
            List<URL> list = this.b();
            for (URL uRL : new ArrayList<URL>(list)) {
                boolean bl = false;
                URL uRL2 = new URL(uRL.getProtocol(), inetAddress.getHostName(), uRL.getPort(), "");
                if (!list.contains(list)) {
                    list.add(uRL2);
                    bl = true;
                }
                uRL2 = new URL(uRL.getProtocol(), inetAddress.getHostAddress(), uRL.getPort(), "");
                if (!list.contains(list)) {
                    list.add(uRL2);
                    bl = true;
                }
                if (!bl || !"localhost".equals(uRL.getHost())) continue;
                list.remove(uRL);
            }
            for (URL uRL : list) {
                System.out.println("* " + String.valueOf(uRL) + string);
            }
            System.out.println("from the client " + this.b);
            System.out.println("\nThe browser must use the IP address you specified as a parameter..\n");
        }
    }

    private void a(@Nullable String string) throws Exception {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        Properties properties = serverPluginManager.getStartProperties();
        properties.setProperty("autodetectPort", "true");
        if (string != null) {
            properties.setProperty("bindAddress", string);
        }
        if (this.b != null) {
            properties.setProperty("clientIP", this.b);
        }
        serverPluginManager.init(this.a);
        LoginProcessor.setCurrentForAllThreads(new LoginProcessor(null){

            @Override
            public boolean supportsRoles() {
                return false;
            }

            @Override
            public boolean isWebUserInRole(String role) {
                return true;
            }

            @Override
            public UserAccountType getUserAccountType() {
                return UserAccountType.Administrator;
            }

            @Override
            public String getLoginSource() {
                return RecoveryLauncher.c();
            }

            @Override
            @Nullable
            public String getLoginID() {
                return RecoveryLauncher.c();
            }

            @Override
            protected UserAccount getOrCreateUserAccount(String loginID) {
                UserAccount userAccount = super.getOrCreateUserAccount(loginID);
                String string = ConfigurationManager.isHelpCenterMode() ? "help.png" : "recovery.png";
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream != null) {
                    UserManager.getInstance().storeBinaryData(userAccount.getID(), new BinaryDataKey("useravatar", false), inputStream, -1);
                }
                return userAccount;
            }
        });
        if (!serverPluginManager.isPluginLoaded("webserver")) {
            throw new Exception("There is no webserver plugin. Please add webserver.zip to the plugins directory.");
        }
    }

    protected String getUrlPath() {
        return "/";
    }

    int a() throws MalformedURLException {
        String[] stringArray;
        Properties properties = ServerPluginManager.getInstance().getStartProperties();
        String string = properties.getProperty("UrlStrings");
        for (String string2 : stringArray = string.split(",")) {
            try {
                URL throwable = new URL(string2);
                if (!"http".equals(throwable.getProtocol())) continue;
                int n2 = throwable.getPort();
                return n2 < 0 ? 80 : n2;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
        String string3 = properties.getProperty("UrlString");
        return new URL(string3).getPort();
    }

    @Nonnull
    List<URL> b() {
        Properties properties = ServerPluginManager.getInstance().getStartProperties();
        String string = properties.getProperty("UrlStrings");
        String[] stringArray = string.split(",");
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string2 : stringArray) {
            try {
                arrayList.add(new URL(string2));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
        return arrayList;
    }

    private void a(boolean bl) throws Exception {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Configuration configuration = configurationManager.getCurrent();
        configurationManager.setTemporaryProperties(new Properties());
        Properties properties = this.createProperties(bl);
        if (ConfigurationManager.isHelpCenterMode()) {
            Object object = System.getProperty("preserveConfigProperties", "");
            object = (String)object + "," + String.join((CharSequence)",", ConfigKey.LICENSEKEY.getKey(), "theme.themename", "theme.themecolors", "theme.themepermissions");
            for (String string : ((String)object).split(",")) {
                String string2;
                if ((string = string.trim()).length() == 0 || (string2 = configuration.get(string)) == null) continue;
                properties.put(string, string2);
            }
        }
        this.a(configuration, properties);
        configurationManager.setTemporaryProperties(properties);
    }

    private void a(@Nonnull Configuration configuration, @Nonnull Properties properties) {
        String string = configuration.get(ConfigKey.LISTENER_CONNECTION_TYPE);
        if ("plain_and_secure".equals(string) || "secure".equals(string)) {
            String[] stringArray;
            properties.put(ConfigKey.LISTENER_CONNECTION_TYPE.getKey(), "plain_and_secure");
            for (String string2 : stringArray = new String[]{"listener.ssl.certificate.type", ConfigKey.LISTENER_SSL_CERTIFICATE.getKey(), ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey()}) {
                String string3 = configuration.get(string2);
                if (string3 == null) continue;
                properties.put(string2, string3);
            }
        }
    }

    @Nonnull
    protected Properties createProperties(boolean logFile) throws Exception {
        Serializable serializable;
        Properties properties = new Properties();
        properties.setProperty(ConfigKey.SYSTEMPERMISSION_ENABLED.getKey(), "true");
        if (this.c != null) {
            properties.setProperty(ConfigKey.LISTENER_PORT.getKey(), Integer.toString(Integer.parseInt(this.c) - 1));
        }
        if (this.d != null) {
            properties.setProperty(ConfigKey.LISTENER_SSL_PORT.getKey(), Integer.toString(Integer.parseInt(this.d) - 1));
        }
        properties.setProperty(ConfigKey.LOG_LEVELS.getKey(), "{'Reporting':4,'Config':4}");
        if (logFile) {
            try {
                serializable = File.createTempFile("recovery-configuration-", ".log");
                System.out.println("Logging to: " + String.valueOf(serializable));
                properties.setProperty(ConfigKey.LOG_FILE.getKey(), ((File)serializable).toString());
            }
            catch (IOException iOException) {
                LogManager.getConfigLogger().fatal(iOException);
            }
        } else {
            properties.setProperty(ConfigKey.LOG_FILE.getKey(), "");
        }
        serializable = new HashMap();
        for (ResourceFile resourceFile : ServerPluginManager.getInstance().getPluginDirs()) {
            ResourceFile[] resourceFileArray = resourceFile.listFiles();
            if (resourceFileArray == null) continue;
            for (ResourceFile resourceFile2 : resourceFileArray) {
                String string = resourceFile2.getName();
                if (!string.endsWith(".zip")) continue;
                String string2 = string.substring(0, string.length() - 4);
                if (ConfigurationManager.isHelpCenterMode()) {
                    serializable.put(string2, j.contains(string2));
                    continue;
                }
                if (!string.startsWith("authentication.")) continue;
                serializable.put(string2, Boolean.TRUE);
            }
        }
        serializable.put("setupwizard", Boolean.FALSE);
        serializable.put("notification", Boolean.FALSE);
        if (this.e != null) {
            for (String string : this.e.split(",")) {
                String string3 = string.trim();
                if (string3.isEmpty()) continue;
                serializable.put(string3, Boolean.TRUE);
            }
        }
        properties.setProperty(ConfigKey.PLUGINS_ACTIVATED.getKey(), new Json().toJson(serializable));
        return properties;
    }

    private static String c() {
        return ConfigurationManager.isHelpCenterMode() ? "Help Center" : "Recovery Manager";
    }

    private JFrame d() {
        JFrame jFrame = new JFrame(RecoveryLauncher.c());
        jFrame.setDefaultCloseOperation(3);
        URL uRL = RecoveryConfiguration.class.getResource("Config-Manager.ico");
        WindowIcon.setApplicationIcon(jFrame, uRL);
        return jFrame;
    }

    private void e() throws HeadlessException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = this.d();
        Container container = jFrame.getContentPane();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        if (ConfigurationManager.isHelpCenterMode()) {
            jLabel.setText("Help Center for your Server");
            jLabel2.setText("Allows localhost only access to a help tool via a separate web application.");
        } else {
            jLabel.setText("Recovery and Configuration for your Server");
            jLabel2.setText("Allows localhost only access to a configuration tool via a separate web application.");
        }
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridBagLayout());
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel2.setVerticalAlignment(1);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 5, 2), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 20, 5, 5), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 13, 1, new Insets(10, 37, 10, 10), 0, 0));
        URL uRL = RecoveryConfiguration.class.getResource("Config_32.png");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : null;
        jLabel3.setIcon(imageIcon);
        container.add((Component)jPanel, "North");
        JLabel jLabel4 = new JLabel(ConfigurationManager.isHelpCenterMode() ? "<html><center><p>This tool is mainly designed for help purposes.<p style='padding-top: 5px;'><span style='color: #aa0000; font-size: 80%;'>Attention: the access is localhost only and does not provide all server functionality.</span>" : "<html><center><p>This tool is mainly designed for configuration recovery purposes.<p>All features from the remote configuration manager are available.<p style='padding-top: 5px;'><span style='color: #aa0000; font-size: 80%;'>Attention: the access is localhost only and does not provide all server functionality.</span>");
        this.h = new AbstractAction("Copy URL to clipboard"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                StringSelection stringSelection = new StringSelection(RecoveryLauncher.this.f);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        };
        this.h.setEnabled(false);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.h);
        this.g = new JLabel("<html>" + this.f + "</html>");
        this.g.setFont(new Font("Dialog", 0, 20));
        this.g.setForeground(new Color(16823));
        this.g.setCursor(new Cursor(12));
        this.g.setComponentPopupMenu(jPopupMenu);
        this.g.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                RecoveryLauncher.this.g.setText("<html>" + RecoveryLauncher.this.f + "</html>");
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                if (RecoveryLauncher.this.f.startsWith("http")) {
                    RecoveryLauncher.this.g.setText("<html><u>" + RecoveryLauncher.this.f + "</u></html>");
                }
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
                try {
                    if (e2.getButton() == 1 && RecoveryLauncher.this.f.startsWith("http")) {
                        RecoveryLauncher.a(new URI(RecoveryLauncher.this.f));
                    }
                }
                catch (Exception exception) {
                    LogManager.getConfigLogger().error(exception);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jLabel4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        jPanel2.add((Component)this.g, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        Dimension dimension = jPanel2.getPreferredSize();
        dimension.height = Math.max(200, dimension.height);
        jPanel2.setPreferredSize(dimension);
        container.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 10));
        JButton jButton = new JButton("Shutdown"){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        jFrame.getRootPane().setDefaultButton(jButton);
        jPanel3.add(jButton);
        container.add((Component)jPanel3, "South");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No remote user input is used")
    private void a(String string, String string2, boolean bl) {
        if (bl) {
            System.out.println("Forced import of configuration requested (will overwrite old configuration if necessary).");
        } else {
            System.out.println("Import of configuration requested.");
        }
        if (string == null) {
            System.err.println("The new configuration name must be specified in the format scope/name, e.g. User/myConfig");
            if (bl) {
                System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -forceImportConfig <name> <file>");
            } else {
                System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -importConfig <name> <file>");
            }
            return;
        }
        if (string2 == null) {
            System.err.println("A properties file must be specified.");
            if (bl) {
                System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -forceImportConfig <name> <file>");
            } else {
                System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -importConfig <name> <file>");
            }
            return;
        }
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            System.err.println("The configuration name must be in the format scope/name, e.g. User/myConfig");
            return;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        int n3 = RecoveryLauncher.b(string3);
        if (!RecoveryLauncher.a(n3)) {
            return;
        }
        if (string4.length() <= 0) {
            System.err.println("A name for the new configuration must be specified.");
            return;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        if (configurationManager.get(n3, string4) != null && !bl) {
            System.err.println("A configuration with the name \"" + string4 + "\" already exists in the scope \"" + ConfigurationManager.getScopeName(n3) + "\". Please specify another name,\nor use the command line argument forceImportConfig instead, to overwrite the configuration, e.g.:\njava -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -forceImportConfig " + string + " " + string2);
            return;
        }
        File file = new File(string2);
        if (!RecoveryLauncher.a(file)) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            if (configurationManager.get(n3, string4) != null && bl) {
                System.out.println("Deleting old configuration at " + string + "...");
                configurationManager.delete(n3, string4);
            }
            System.out.println("Importing configuration into " + string + "...");
            configurationManager.importFromStream(n3, string4, fileInputStream);
            fileInputStream.close();
            configurationManager.get(n3, string4);
            System.out.print("The configuration \"" + string4 + "\" was successfully imported into the scope \"" + ConfigurationManager.getScopeName(n3) + "\"");
            if (n3 == 2) {
                System.out.println(" for the user \"" + System.getProperty("user.name") + "\".");
            } else {
                System.out.println(".");
            }
        }
        catch (SecurityException securityException) {
            System.err.println("A SecurityException occurred, please check your rights for the selected scope.");
            System.err.println(securityException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println("A exception occurred while reading from the specified file.");
            System.err.println(iOException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Importing failed due to the following problem:");
            System.err.println(illegalArgumentException.getLocalizedMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean a(File file) {
        if (!file.exists()) {
            System.err.println("A file with the name \"" + file.getName() + "\" does not exist.");
            return false;
        }
        if (!file.isFile()) {
            System.err.println("The specified source file \"" + file.getName() + "\" is not a file.");
            return false;
        }
        if (!file.canRead()) {
            System.err.println("The specified source file \"" + file.getName() + "\" is not readable.");
            return false;
        }
        return true;
    }

    private static boolean a(int n2) {
        if (n2 == -1) {
            System.err.println("Only the import to scope \"" + ConfigurationManager.getScopeName(2) + "\" or \"" + ConfigurationManager.getScopeName(1) + "\" is possible.");
            return false;
        }
        if (!ConfigurationManager.isWriteable(n2)) {
            String string = "You have no writing rights to scope \"" + ConfigurationManager.getScopeName(n2) + "\".";
            if (n2 == 2 && !Persistence.isFilePersistence()) {
                string = string + "\nIf you do not use the file based persistence then you have to use the SYSTEM scope.";
            }
            System.err.println(string);
            return false;
        }
        return true;
    }

    private static boolean b(int n2) {
        if (n2 == -1) {
            System.err.println("Only the export from scope \"" + ConfigurationManager.getScopeName(2) + "\" or \"" + ConfigurationManager.getScopeName(1) + "\" is possible.");
            return false;
        }
        if (!ConfigurationManager.isReadable(n2)) {
            System.err.println("You have no rights to read from scope \"" + ConfigurationManager.getScopeName(n2) + "\".");
            return false;
        }
        return true;
    }

    private static int b(String string) {
        int n2 = -1;
        if (string.equalsIgnoreCase(ConfigurationManager.getScopeName(2))) {
            n2 = 2;
        } else if (string.equalsIgnoreCase(ConfigurationManager.getScopeName(1))) {
            n2 = 1;
        }
        return n2;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No remote user input is used")
    private void a(String string, String string2) throws SecurityException, IOException {
        Object object;
        System.out.println("Export of configuration requested.");
        if (string == null || string2 == null) {
            System.err.println("The configuration name (in the format scope/name, e.g. User/myConfig) and a file to export to must be specified.");
            System.err.println("Usage: java -cp inetcore.jar com.inet.config.recovery.RecoveryConfiguration -exportConfig <name> <file>");
            return;
        }
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            System.err.println("The configuration name must be in the format scope/name, e.g. User/myConfig");
            return;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        int n3 = RecoveryLauncher.b(string3);
        if (!RecoveryLauncher.b(n3)) {
            return;
        }
        if (string4.length() <= 0) {
            System.err.println("A name for the configuration must be specified.");
            return;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        try {
            object = configurationManager.get(n3, string4);
            if (object == null) {
                System.err.println("The Configuration " + ConfigurationManager.getScopeName(n3) + "/" + string4 + " does not exist.");
                return;
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Access denied for the scope " + ConfigurationManager.getScopeName(n3) + ".");
            return;
        }
        object = new FileOutputStream(new File(string2));
        configurationManager.exportToStream(n3, string4, (OutputStream)object);
    }

    private static void f() {
        System.out.println("System Scope");
        System.out.println("------------");
        RecoveryLauncher.c(1);
        System.out.println();
        System.out.println("User Scope");
        System.out.println("----------");
        RecoveryLauncher.c(2);
    }

    private static void c(int n2) {
        Configuration[] configurationArray;
        for (Configuration configuration : configurationArray = ConfigurationManager.getInstance().getAll(n2)) {
            System.out.println(configuration.getName());
        }
    }

    private static void a(URI uRI) {
        try {
            Desktop.getDesktop().browse(uRI);
            return;
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().warn(throwable);
            RecoveryLauncher.a((Object)uRI);
            return;
        }
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="No client parameter are used")
    private static void a(Object object) throws RuntimeException {
        block10: {
            int n2 = RecoveryLauncher.g();
            String string = object.toString();
            try {
                block2 : switch (n2) {
                    case 1: {
                        String string2 = "cmd.exe /C explorer \"" + string + "\"";
                        Runtime.getRuntime().exec(string2);
                        break;
                    }
                    case 2: {
                        Process process = Runtime.getRuntime().exec(new String[]{"open", string});
                        int n3 = process.waitFor();
                        if (n3 != 0) {
                            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                            Method method = clazz.getDeclaredMethod("openURL", String.class);
                            method.invoke(null, object);
                            break;
                        }
                        break block10;
                    }
                    default: {
                        String[] stringArray = new String[]{"xdg-open", "gnome-open", "kfmclient exec", "sensible-browser", "x-www-browser", "firefox", "google-chrome", "opera", "konqueror", "epiphany", "netscape", "mozilla"};
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            try {
                                String[] stringArray2 = stringArray[i2].split("\\s+");
                                String[] stringArray3 = new String[stringArray2.length + 1];
                                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                                stringArray3[stringArray3.length - 1] = string;
                                Process process = Runtime.getRuntime().exec(stringArray3);
                                if (process.waitFor() != 0) continue;
                                break block2;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break block10;
                    }
                }
                {
                    break block10;
                    break;
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException("The using the os specific fallback failed: " + throwable.getMessage(), throwable);
            }
        }
    }

    private static int g() {
        int n2 = 0;
        try {
            String string = System.getProperty("os.name");
            if (string.indexOf("Win") != -1) {
                n2 = 1;
            } else if (string.indexOf("Mac") != -1) {
                n2 = 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    @Nonnull
    private static String h() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!(inetAddress instanceof Inet6Address)) continue;
                    return "127.0.0.1,::1";
                }
            }
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().debug(throwable);
        }
        return "127.0.0.1";
    }
}

