/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.internal;

import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.website.WellKnownWebsites;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.SuppressFBWarnings;

public class LicenseTokenTimerTask
extends DefaultTimerTask {
    private static final String BASE_URL = WellKnownWebsites.LICENSING_BASE_URL + "callback/callback?fqdn=";
    private final String a;
    private int b;

    public LicenseTokenTimerTask(String fqdn) {
        this.a = fqdn;
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only fix URL is used")
    public void runImpl() throws Throwable {
        block5: {
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            if (serverPluginManager.getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
                return;
            }
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            StringBuilder stringBuilder = new StringBuilder(BASE_URL).append(EncodingFunctions.encodeUrlParameter(this.a));
            stringBuilder.append("&version=").append(EncodingFunctions.encodeUrlParameter(applicationDescription.getVersion().toString()));
            stringBuilder.append("&app=").append(EncodingFunctions.encodeUrlParameter(applicationDescription.getApplicationName()));
            Logger logger = LogManager.getConfigLogger();
            URL uRL = new URL(stringBuilder.toString());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                logger.info("Checking for new license token for FQDN: " + this.a);
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setReadTimeout(5000);
                int n2 = httpURLConnection.getResponseCode();
                if (n2 == 200) {
                    this.cancel();
                    return;
                }
                logger.error("License token request returns: " + n2 + " " + httpURLConnection.getResponseMessage() + "\n" + IOFunctions.readAsciiString(httpURLConnection.getInputStream()));
            }
            catch (IOException iOException) {
                logger.error(iOException);
                InputStream inputStream = httpURLConnection.getErrorStream();
                if (inputStream == null) break block5;
                logger.error("License token request returns: " + IOFunctions.readAsciiString(inputStream));
            }
        }
        if (++this.b >= 5) {
            this.cancel();
        }
    }
}

