/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader.translations;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.lib.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;

public class LanguageUtils {
    public static List<LocalizedKey> getAdditionalLanguages(@Nonnull Set<String> supportedLanguages) {
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        for (String string : Locale.getISOLanguages()) {
            Locale locale;
            if (supportedLanguages.contains(string)) continue;
            if (string.equals("zh")) {
                locale = LocaleUtils.valueOf("zh_HK");
                arrayList.add(new LocalizedKey(locale.getLanguage(), locale.getDisplayName()));
                Locale locale2 = LocaleUtils.valueOf("zh_TW");
                arrayList.add(new LocalizedKey(locale2.getLanguage(), locale2.getDisplayName()));
                continue;
            }
            locale = LocaleUtils.valueOf(string);
            arrayList.add(new LocalizedKey(locale.getLanguage(), locale.getDisplayName()));
        }
        Comparator<LocalizedKey> comparator = new Comparator<LocalizedKey>(){

            public int a(LocalizedKey localizedKey, LocalizedKey localizedKey2) {
                return localizedKey.getDisplayName().compareTo(localizedKey2.getDisplayName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((LocalizedKey)object, (LocalizedKey)object2);
            }
        };
        Collections.sort(arrayList, comparator);
        return arrayList;
    }
}

