/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.stayloggedin;

import com.inet.annotations.JsonData;
import com.inet.http.utils.Browser;
import com.inet.http.utils.UserAgent;
import com.inet.lib.core.OS;
import com.inet.lib.util.PasswordHashing;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonData
public class StayLoggedInSession {
    private Browser browser;
    private OS os;
    private long lastUse;
    private String provider;
    private String clientID;
    private String hashToken;

    private StayLoggedInSession() {
    }

    public StayLoggedInSession(@Nonnull HttpServletRequest request, String loginProvider, String @Nonnull [] triple) {
        UserAgent userAgent = new UserAgent(request.getHeader("User-Agent"));
        this.browser = userAgent.browser;
        this.os = userAgent.os;
        this.lastUse = System.currentTimeMillis();
        this.provider = loginProvider;
        this.clientID = triple[1];
        this.hashToken = PasswordHashing.hash(triple[2].toCharArray());
        Objects.requireNonNull(this.browser);
        Objects.requireNonNull(this.os);
        Objects.requireNonNull(this.provider);
        Objects.requireNonNull(this.clientID);
    }

    public String getClientID() {
        return this.clientID;
    }

    public long getLastUse() {
        return this.lastUse;
    }

    public String getHashToken() {
        return this.hashToken;
    }

    @Nonnull
    public String getProvider() {
        return this.provider;
    }

    @Nonnull
    public Browser getBrowser() {
        return this.browser;
    }

    public OS getOS() {
        return this.os;
    }

    public int hashCode() {
        return this.clientID.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StayLoggedInSession stayLoggedInSession = (StayLoggedInSession)obj;
        return Objects.equals(this.clientID, stayLoggedInSession.clientID) && Objects.equals(this.hashToken, stayLoggedInSession.hashToken);
    }
}

